module type S = sig

type 'a t = 'a CamlinternalLazy.t

(*
type 'a t = 'a Stdcompat__init.lazy_t
*)
(** @since 4.08.0: type 'a t = 'a CamlinternalLazy.t
 *)

exception Undefined 
(** Alias for {!Lazy.Undefined} *)

val map : ('a -> 'b) -> 'a t -> 'b t
(** @since 4.13.0: val map : ('a -> 'b) -> 'a t -> 'b t *)

val map_val : ('a -> 'b) -> 'a t -> 'b t
(** @since 4.13.0: val map_val : ('a -> 'b) -> 'a t -> 'b t *)

val is_val : 'a t -> bool
(** @since 4.00.0: val is_val : 'a t -> bool *)

val from_val : 'a -> 'a t
(** @since 4.00.0: val from_val : 'a -> 'a t *)

val from_fun : (unit -> 'a) -> 'a t
(** @since 4.00.0: val from_fun : (unit -> 'a) -> 'a t *)


external force : 'a t -> 'a = "%lazy_force"

(*
val force : 'a t -> 'a
*)
(** @since 3.11.0: external force : 'a t -> 'a = "%lazy_force"
@since 3.07.0: val force : 'a t -> 'a
 *)

val force_val : 'a t -> 'a
(** Alias for {!Lazy.force_val} *)

end
