module type S = sig

type t = out_channel

(*
type t = out_channel
*)
(** @since 4.14.0: type t = out_channel
 *)


type open_flag = Out_channel.open_flag =
  | Open_rdonly 
  | Open_wronly 
  | Open_append 
  | Open_creat 
  | Open_trunc 
  | Open_excl 
  | Open_binary 
  | Open_text 
  | Open_nonblock 

(*
type open_flag =
  | Open_rdonly 
  | Open_wronly 
  | Open_append 
  | Open_creat 
  | Open_trunc 
  | Open_excl 
  | Open_binary 
  | Open_text 
  | Open_nonblock 
*)
(** @since 4.14.0:
    type open_flag = Out_channel.open_flag =
      | Open_rdonly 
      | Open_wronly 
      | Open_append 
      | Open_creat 
      | Open_trunc 
      | Open_excl 
      | Open_binary 
      | Open_text 
      | Open_nonblock 
 *)

val output_bigarray :
  t ->
    ('a, Bigarray.int8_unsigned_elt, Bigarray.c_layout) Bigarray.Array1.t ->
      int -> int -> unit
(** @since 5.2.0:
    val output_bigarray :
      t ->
        ('a, Bigarray.int8_unsigned_elt, Bigarray.c_layout) Bigarray.Array1.t
          -> int -> int -> unit *)

val is_binary_mode : t -> bool
(** @since 5.2.0: val is_binary_mode : t -> bool *)

val isatty : t -> bool
(** @since 5.1.0: val isatty : t -> bool *)

val stdout : t
(** @since 4.14.0: val stdout : t *)

val stderr : t
(** @since 4.14.0: val stderr : t *)

val open_bin : string -> t
(** @since 4.14.0: val open_bin : string -> t *)

val open_text : string -> t
(** @since 4.14.0: val open_text : string -> t *)

val open_gen : open_flag list -> int -> string -> t
(** @since 4.14.0: val open_gen : open_flag list -> int -> string -> t *)

val with_open_bin : string -> (t -> 'a) -> 'a
(** @since 4.14.0: val with_open_bin : string -> (t -> 'a) -> 'a *)

val with_open_text : string -> (t -> 'a) -> 'a
(** @since 4.14.0: val with_open_text : string -> (t -> 'a) -> 'a *)

val with_open_gen : open_flag list -> int -> string -> (t -> 'a) -> 'a
(** @since 4.14.0:
    val with_open_gen : open_flag list -> int -> string -> (t -> 'a) -> 'a *)

val close : t -> unit
(** @since 4.14.0: val close : t -> unit *)

val close_noerr : t -> unit
(** @since 4.14.0: val close_noerr : t -> unit *)

val output_char : t -> char -> unit
(** @since 4.14.0: val output_char : t -> char -> unit *)

val output_byte : t -> int -> unit
(** @since 4.14.0: val output_byte : t -> int -> unit *)

val output_string : t -> string -> unit
(** @since 4.14.0: val output_string : t -> string -> unit *)


val output_bytes : t -> bytes -> unit

(*
val output_bytes : t -> Stdcompat__init.bytes -> unit
*)
(** @since 4.14.0: val output_bytes : t -> bytes -> unit
 *)


val output : t -> bytes -> int -> int -> unit

(*
val output : t -> Stdcompat__init.bytes -> int -> int -> unit
*)
(** @since 4.14.0: val output : t -> bytes -> int -> int -> unit
 *)

val output_substring : t -> string -> int -> int -> unit
(** @since 4.14.0: val output_substring : t -> string -> int -> int -> unit *)

val flush : t -> unit
(** @since 4.14.0: val flush : t -> unit *)

val flush_all : unit -> unit
(** @since 4.14.0: val flush_all : unit -> unit *)

val seek : t -> int64 -> unit
(** @since 4.14.0: val seek : t -> int64 -> unit *)

val pos : t -> int64
(** @since 4.14.0: val pos : t -> int64 *)

val length : t -> int64
(** @since 4.14.0: val length : t -> int64 *)

val set_binary_mode : t -> bool -> unit
(** @since 4.14.0: val set_binary_mode : t -> bool -> unit *)

val set_buffered : t -> bool -> unit
(** @since 4.14.0: val set_buffered : t -> bool -> unit *)

val is_buffered : t -> bool
(** @since 4.14.0: val is_buffered : t -> bool *)

end
