module type S = sig

type !'a t = 'a Queue.t

(*
type 'a t = 'a Queue.t
*)

(** Alias for {!Queue.t} *)

exception Empty 
(** Alias for {!Queue.Empty} *)

val take_opt : 'a t -> 'a option
(** @since 4.08.0: val take_opt : 'a t -> 'a option *)

val peek_opt : 'a t -> 'a option
(** @since 4.08.0: val peek_opt : 'a t -> 'a option *)


val to_seq : 'a t -> 'a Seq.t

(*
val to_seq : 'a t -> 'a Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seq : 'a t -> 'a Seq.t
 *)


val add_seq : 'a t -> 'a Seq.t -> unit

(*
val add_seq : 'a t -> 'a Stdcompat__seq.t -> unit
*)
(** @since 4.07.0: val add_seq : 'a t -> 'a Seq.t -> unit
 *)


val of_seq : 'a Seq.t -> 'a t

(*
val of_seq : 'a Stdcompat__seq.t -> 'a t
*)
(** @since 4.07.0: val of_seq : 'a Seq.t -> 'a t
 *)

val create : unit -> 'a t
(** Alias for {!Queue.create} *)

val add : 'a -> 'a t -> unit
(** Alias for {!Queue.add} *)

val push : 'a -> 'a t -> unit
(** Alias for {!Queue.push} *)

val take : 'a t -> 'a
(** Alias for {!Queue.take} *)

val pop : 'a t -> 'a
(** Alias for {!Queue.pop} *)

val peek : 'a t -> 'a
(** Alias for {!Queue.peek} *)

val top : 'a t -> 'a
(** Alias for {!Queue.top} *)

val clear : 'a t -> unit
(** Alias for {!Queue.clear} *)

val copy : 'a t -> 'a t
(** Alias for {!Queue.copy} *)

val is_empty : 'a t -> bool
(** Alias for {!Queue.is_empty} *)

val length : 'a t -> int
(** Alias for {!Queue.length} *)

val iter : ('a -> unit) -> 'a t -> unit
(** Alias for {!Queue.iter} *)


val fold : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc

(*

val fold : ('b -> 'a -> 'b) -> 'b -> 'a t -> 'b

(*
val fold : ('a -> 'b -> 'a) -> 'a -> 'b t -> 'a
*)

*)
(** @since 5.1.0: val fold : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
@since 4.00.0: val fold : ('b -> 'a -> 'b) -> 'b -> 'a t -> 'b
@since 3.07.0: val fold : ('a -> 'b -> 'a) -> 'a -> 'b t -> 'a
 *)

val transfer : 'a t -> 'a t -> unit
(** Alias for {!Queue.transfer} *)

val drop : 'a t -> unit

end
