#include <string.h>


void stdcompat_dummy_symbol()
{
  /* If the library is empty, then the following error message appears on macOS:
     ld: archive has no table of contents file './libtest_prog_stubs.a' for
     architecture arm64

     One solution is to execute `ranlib libtest_prog_stubs.a` after `ocamlmklib`
     and before `ocamlopt` use the library, but I don't know how to make dune
     execute the command.

     Another solution is to export a dummy symbol!
  */
}


#if 0

#include <caml/major_gc.h>

#define CAML_INTERNALS
#include <caml/memory.h>

#include <caml/sys.h>
#include <caml/osdeps.h>

#if 0
#if 0
CAMLextern void sys_error (value);
#define caml_sys_error sys_error
#endif

CAMLextern void caml_sys_error (value);

#endif
#ifdef _WIN32
#include <direct.h>
#else
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#endif

#if 0
#define caml_alloc_string alloc_string
#endif

CAMLprim value caml_sys_mkdir(value path, value perm)
{
  CAMLparam2(path, perm);
  int ret;

  char_os * p = caml_stat_strdup_to_os(String_val(path));
  #ifdef _WIN32
    ret = _wmkdir(p);
  #else
    ret = mkdir(p, Int_val(perm));
  #endif
  caml_stat_free(p);

#if 0
  char * p;
  p = String_val(path);
  #ifdef _WIN32
    ret = _mkdir(p);
  #else
    ret = mkdir(p, Int_val(perm));
  #endif
#endif
  if (ret == -1) caml_sys_error(path);
  CAMLreturn(Val_unit);
}

CAMLprim value caml_sys_rmdir(value path)
{
  CAMLparam1(path);
  int ret;

  char_os * p = caml_stat_strdup_to_os(String_val(path));
  #ifdef _WIN32
    ret = _wrmdir(p);
  #else
    ret = rmdir(p);
  #endif
  caml_stat_free(p);

#if 0
  char * p;
  p = String_val(path);
  #ifdef _WIN32
    ret = _rmdir(p);
  #else
    ret = rmdir(p);
  #endif
#endif
  if (ret == -1) caml_sys_error(path);
  CAMLreturn(Val_unit);
}
#endif

#if 0
value
caml_alloc_initialized_string(mlsize_t len, const char *p)
{
  value result = caml_alloc_string(len);
  memcpy((char *)String_val(result), p, len);
  return result;
}
#endif
