/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_STEAMROLLER;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_STEAMROLLER.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_STEAMROLLER, shgemm_beta_STEAMROLLER,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_STEAMROLLER, shgemm_itcopy_STEAMROLLER,
#else
  shgemm_oncopy_STEAMROLLER, shgemm_otcopy_STEAMROLLER,
#endif
  shgemm_oncopy_STEAMROLLER, shgemm_otcopy_STEAMROLLER,
  shgemv_n_STEAMROLLER, shgemv_t_STEAMROLLER,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_STEAMROLLER, sbdtobf16_k_STEAMROLLER, sbf16tos_k_STEAMROLLER, dbf16tod_k_STEAMROLLER,

  samax_k_STEAMROLLER,  samin_k_STEAMROLLER,  smax_k_STEAMROLLER,  smin_k_STEAMROLLER,
  isamax_k_STEAMROLLER, isamin_k_STEAMROLLER, ismax_k_STEAMROLLER, ismin_k_STEAMROLLER,
  snrm2_k_STEAMROLLER,  sasum_k_STEAMROLLER,  ssum_k_STEAMROLLER, scopy_k_STEAMROLLER, sbdot_k_STEAMROLLER,
  dsdot_k_STEAMROLLER,
  srot_k_STEAMROLLER,   srotm_k_STEAMROLLER, bscal_k_STEAMROLLER, saxpy_k_STEAMROLLER,  sscal_k_STEAMROLLER, sswap_k_STEAMROLLER,
  bgemv_n_STEAMROLLER, bgemv_t_STEAMROLLER, sbgemv_n_STEAMROLLER, sbgemv_t_STEAMROLLER, sger_k_STEAMROLLER,
  ssymv_L_STEAMROLLER, ssymv_U_STEAMROLLER,

  bgemm_kernel_STEAMROLLER, bgemm_beta_STEAMROLLER,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_STEAMROLLER, bgemm_itcopy_STEAMROLLER,
#else
  bgemm_oncopy_STEAMROLLER, bgemm_otcopy_STEAMROLLER,
#endif
  bgemm_oncopy_STEAMROLLER, bgemm_otcopy_STEAMROLLER,

  sbgemm_kernel_STEAMROLLER, sbgemm_beta_STEAMROLLER,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_STEAMROLLER, sbgemm_itcopy_STEAMROLLER,
#else
  sbgemm_oncopy_STEAMROLLER, sbgemm_otcopy_STEAMROLLER,
#endif
  sbgemm_oncopy_STEAMROLLER, sbgemm_otcopy_STEAMROLLER,

  strsm_kernel_LN_STEAMROLLER, strsm_kernel_LT_STEAMROLLER, strsm_kernel_RN_STEAMROLLER, strsm_kernel_RT_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_STEAMROLLER, strsm_iunncopy_STEAMROLLER, strsm_iutucopy_STEAMROLLER, strsm_iutncopy_STEAMROLLER,
  strsm_ilnucopy_STEAMROLLER, strsm_ilnncopy_STEAMROLLER, strsm_iltucopy_STEAMROLLER, strsm_iltncopy_STEAMROLLER,
#else
  strsm_ounucopy_STEAMROLLER, strsm_ounncopy_STEAMROLLER, strsm_outucopy_STEAMROLLER, strsm_outncopy_STEAMROLLER,
  strsm_olnucopy_STEAMROLLER, strsm_olnncopy_STEAMROLLER, strsm_oltucopy_STEAMROLLER, strsm_oltncopy_STEAMROLLER,
#endif
  strsm_ounucopy_STEAMROLLER, strsm_ounncopy_STEAMROLLER, strsm_outucopy_STEAMROLLER, strsm_outncopy_STEAMROLLER,
  strsm_olnucopy_STEAMROLLER, strsm_olnncopy_STEAMROLLER, strsm_oltucopy_STEAMROLLER, strsm_oltncopy_STEAMROLLER,
  strmm_kernel_RN_STEAMROLLER, strmm_kernel_RT_STEAMROLLER, strmm_kernel_LN_STEAMROLLER, strmm_kernel_LT_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_STEAMROLLER, strmm_iunncopy_STEAMROLLER, strmm_iutucopy_STEAMROLLER, strmm_iutncopy_STEAMROLLER,
  strmm_ilnucopy_STEAMROLLER, strmm_ilnncopy_STEAMROLLER, strmm_iltucopy_STEAMROLLER, strmm_iltncopy_STEAMROLLER,
#else
  strmm_ounucopy_STEAMROLLER, strmm_ounncopy_STEAMROLLER, strmm_outucopy_STEAMROLLER, strmm_outncopy_STEAMROLLER,
  strmm_olnucopy_STEAMROLLER, strmm_olnncopy_STEAMROLLER, strmm_oltucopy_STEAMROLLER, strmm_oltncopy_STEAMROLLER,
#endif
  strmm_ounucopy_STEAMROLLER, strmm_ounncopy_STEAMROLLER, strmm_outucopy_STEAMROLLER, strmm_outncopy_STEAMROLLER,
  strmm_olnucopy_STEAMROLLER, strmm_olnncopy_STEAMROLLER, strmm_oltucopy_STEAMROLLER, strmm_oltncopy_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_STEAMROLLER, ssymm_iltcopy_STEAMROLLER,
#else
  ssymm_outcopy_STEAMROLLER, ssymm_oltcopy_STEAMROLLER,
#endif
  ssymm_outcopy_STEAMROLLER, ssymm_oltcopy_STEAMROLLER,

#ifndef NO_LAPACK
  sneg_tcopy_STEAMROLLER, slaswp_ncopy_STEAMROLLER,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_STEAMROLLER,
  sbgemm_small_kernel_nn_STEAMROLLER, sbgemm_small_kernel_nt_STEAMROLLER, sbgemm_small_kernel_tn_STEAMROLLER, sbgemm_small_kernel_tt_STEAMROLLER,
  sbgemm_small_kernel_b0_nn_STEAMROLLER, sbgemm_small_kernel_b0_nt_STEAMROLLER, sbgemm_small_kernel_b0_tn_STEAMROLLER, sbgemm_small_kernel_b0_tt_STEAMROLLER,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_STEAMROLLER,  samin_k_STEAMROLLER,  smax_k_STEAMROLLER,  smin_k_STEAMROLLER,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_STEAMROLLER,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_STEAMROLLER, ismax_k_STEAMROLLER, ismin_k_STEAMROLLER,
  snrm2_k_STEAMROLLER,  sasum_k_STEAMROLLER,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_STEAMROLLER,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_STEAMROLLER, sdot_k_STEAMROLLER,
//  dsdot_k_STEAMROLLER,
  srot_k_STEAMROLLER,  srotm_k_STEAMROLLER,  saxpy_k_STEAMROLLER,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_STEAMROLLER,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_STEAMROLLER,
  sgemv_n_STEAMROLLER,  sgemv_t_STEAMROLLER,
#endif
#if BUILD_SINGLE == 1
  sger_k_STEAMROLLER,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_STEAMROLLER, ssymv_U_STEAMROLLER,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_STEAMROLLER,
  sgemm_direct_performant_STEAMROLLER,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_STEAMROLLER,
  sgemm_direct_alpha_beta_STEAMROLLER,
  ssymm_direct_alpha_betaLU_STEAMROLLER,
  ssymm_direct_alpha_betaLL_STEAMROLLER,
  strmm_direct_LNUN_STEAMROLLER,
  strmm_direct_LNLN_STEAMROLLER,
  strmm_direct_LTUN_STEAMROLLER,
  strmm_direct_LTLN_STEAMROLLER,
  ssyrk_direct_alpha_betaUN_STEAMROLLER,
  ssyrk_direct_alpha_betaUT_STEAMROLLER,
  ssyrk_direct_alpha_betaLN_STEAMROLLER,
  ssyrk_direct_alpha_betaLT_STEAMROLLER,
  ssyr2k_direct_alpha_betaUN_STEAMROLLER,
  ssyr2k_direct_alpha_betaUT_STEAMROLLER,
  ssyr2k_direct_alpha_betaLN_STEAMROLLER,
  ssyr2k_direct_alpha_betaLT_STEAMROLLER,
#endif

  sgemm_kernel_STEAMROLLER, sgemm_beta_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_STEAMROLLER, sgemm_itcopy_STEAMROLLER,
#else
  sgemm_oncopy_STEAMROLLER, sgemm_otcopy_STEAMROLLER,
#endif
  sgemm_oncopy_STEAMROLLER, sgemm_otcopy_STEAMROLLER,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_STEAMROLLER,
  sgemm_small_kernel_nn_STEAMROLLER, sgemm_small_kernel_nt_STEAMROLLER, sgemm_small_kernel_tn_STEAMROLLER, sgemm_small_kernel_tt_STEAMROLLER,
  sgemm_small_kernel_b0_nn_STEAMROLLER, sgemm_small_kernel_b0_nt_STEAMROLLER, sgemm_small_kernel_b0_tn_STEAMROLLER, sgemm_small_kernel_b0_tt_STEAMROLLER,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_STEAMROLLER, strsm_kernel_LT_STEAMROLLER, strsm_kernel_RN_STEAMROLLER, strsm_kernel_RT_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_STEAMROLLER, strsm_iunncopy_STEAMROLLER, strsm_iutucopy_STEAMROLLER, strsm_iutncopy_STEAMROLLER,
  strsm_ilnucopy_STEAMROLLER, strsm_ilnncopy_STEAMROLLER, strsm_iltucopy_STEAMROLLER, strsm_iltncopy_STEAMROLLER,
#else
  strsm_ounucopy_STEAMROLLER, strsm_ounncopy_STEAMROLLER, strsm_outucopy_STEAMROLLER, strsm_outncopy_STEAMROLLER,
  strsm_olnucopy_STEAMROLLER, strsm_olnncopy_STEAMROLLER, strsm_oltucopy_STEAMROLLER, strsm_oltncopy_STEAMROLLER,
#endif
  strsm_ounucopy_STEAMROLLER, strsm_ounncopy_STEAMROLLER, strsm_outucopy_STEAMROLLER, strsm_outncopy_STEAMROLLER,
  strsm_olnucopy_STEAMROLLER, strsm_olnncopy_STEAMROLLER, strsm_oltucopy_STEAMROLLER, strsm_oltncopy_STEAMROLLER,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_STEAMROLLER, strmm_kernel_RT_STEAMROLLER, strmm_kernel_LN_STEAMROLLER, strmm_kernel_LT_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_STEAMROLLER, strmm_iunncopy_STEAMROLLER, strmm_iutucopy_STEAMROLLER, strmm_iutncopy_STEAMROLLER,
  strmm_ilnucopy_STEAMROLLER, strmm_ilnncopy_STEAMROLLER, strmm_iltucopy_STEAMROLLER, strmm_iltncopy_STEAMROLLER,
#else
  strmm_ounucopy_STEAMROLLER, strmm_ounncopy_STEAMROLLER, strmm_outucopy_STEAMROLLER, strmm_outncopy_STEAMROLLER,
  strmm_olnucopy_STEAMROLLER, strmm_olnncopy_STEAMROLLER, strmm_oltucopy_STEAMROLLER, strmm_oltncopy_STEAMROLLER,
#endif
  strmm_ounucopy_STEAMROLLER, strmm_ounncopy_STEAMROLLER, strmm_outucopy_STEAMROLLER, strmm_outncopy_STEAMROLLER,
  strmm_olnucopy_STEAMROLLER, strmm_olnncopy_STEAMROLLER, strmm_oltucopy_STEAMROLLER, strmm_oltncopy_STEAMROLLER,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_STEAMROLLER, ssymm_iltcopy_STEAMROLLER,
#else
  ssymm_outcopy_STEAMROLLER, ssymm_oltcopy_STEAMROLLER,
#endif
  ssymm_outcopy_STEAMROLLER, ssymm_oltcopy_STEAMROLLER,
#ifndef NO_LAPACK
  sneg_tcopy_STEAMROLLER, slaswp_ncopy_STEAMROLLER,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_STEAMROLLER,  damin_k_STEAMROLLER,  dmax_k_STEAMROLLER,  dmin_k_STEAMROLLER,
  idamax_k_STEAMROLLER, idamin_k_STEAMROLLER, idmax_k_STEAMROLLER, idmin_k_STEAMROLLER,
  dnrm2_k_STEAMROLLER, dasum_k_STEAMROLLER,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_STEAMROLLER,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_STEAMROLLER, ddot_k_STEAMROLLER,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_STEAMROLLER,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_STEAMROLLER,
  drotm_k_STEAMROLLER,
  daxpy_k_STEAMROLLER,
  dscal_k_STEAMROLLER, 
  dswap_k_STEAMROLLER,
  dgemv_n_STEAMROLLER,  dgemv_t_STEAMROLLER,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_STEAMROLLER,
  dsymv_L_STEAMROLLER,  dsymv_U_STEAMROLLER,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_STEAMROLLER, dgemm_beta_STEAMROLLER,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_STEAMROLLER, dgemm_itcopy_STEAMROLLER,
#else
  dgemm_oncopy_STEAMROLLER, dgemm_otcopy_STEAMROLLER,
#endif
  dgemm_oncopy_STEAMROLLER, dgemm_otcopy_STEAMROLLER,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_STEAMROLLER,
  dgemm_small_kernel_nn_STEAMROLLER, dgemm_small_kernel_nt_STEAMROLLER, dgemm_small_kernel_tn_STEAMROLLER, dgemm_small_kernel_tt_STEAMROLLER,
  dgemm_small_kernel_b0_nn_STEAMROLLER, dgemm_small_kernel_b0_nt_STEAMROLLER, dgemm_small_kernel_b0_tn_STEAMROLLER, dgemm_small_kernel_b0_tt_STEAMROLLER,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_STEAMROLLER, dtrsm_kernel_LT_STEAMROLLER, dtrsm_kernel_RN_STEAMROLLER, dtrsm_kernel_RT_STEAMROLLER,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_STEAMROLLER, dtrsm_iunncopy_STEAMROLLER, dtrsm_iutucopy_STEAMROLLER, dtrsm_iutncopy_STEAMROLLER,
  dtrsm_ilnucopy_STEAMROLLER, dtrsm_ilnncopy_STEAMROLLER, dtrsm_iltucopy_STEAMROLLER, dtrsm_iltncopy_STEAMROLLER,
#else
  dtrsm_ounucopy_STEAMROLLER, dtrsm_ounncopy_STEAMROLLER, dtrsm_outucopy_STEAMROLLER, dtrsm_outncopy_STEAMROLLER,
  dtrsm_olnucopy_STEAMROLLER, dtrsm_olnncopy_STEAMROLLER, dtrsm_oltucopy_STEAMROLLER, dtrsm_oltncopy_STEAMROLLER,
#endif
  dtrsm_ounucopy_STEAMROLLER, dtrsm_ounncopy_STEAMROLLER, dtrsm_outucopy_STEAMROLLER, dtrsm_outncopy_STEAMROLLER,
  dtrsm_olnucopy_STEAMROLLER, dtrsm_olnncopy_STEAMROLLER, dtrsm_oltucopy_STEAMROLLER, dtrsm_oltncopy_STEAMROLLER,
  dtrmm_kernel_RN_STEAMROLLER, dtrmm_kernel_RT_STEAMROLLER, dtrmm_kernel_LN_STEAMROLLER, dtrmm_kernel_LT_STEAMROLLER,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_STEAMROLLER, dtrmm_iunncopy_STEAMROLLER, dtrmm_iutucopy_STEAMROLLER, dtrmm_iutncopy_STEAMROLLER,
  dtrmm_ilnucopy_STEAMROLLER, dtrmm_ilnncopy_STEAMROLLER, dtrmm_iltucopy_STEAMROLLER, dtrmm_iltncopy_STEAMROLLER,
#else
  dtrmm_ounucopy_STEAMROLLER, dtrmm_ounncopy_STEAMROLLER, dtrmm_outucopy_STEAMROLLER, dtrmm_outncopy_STEAMROLLER,
  dtrmm_olnucopy_STEAMROLLER, dtrmm_olnncopy_STEAMROLLER, dtrmm_oltucopy_STEAMROLLER, dtrmm_oltncopy_STEAMROLLER,
#endif
  dtrmm_ounucopy_STEAMROLLER, dtrmm_ounncopy_STEAMROLLER, dtrmm_outucopy_STEAMROLLER, dtrmm_outncopy_STEAMROLLER,
  dtrmm_olnucopy_STEAMROLLER, dtrmm_olnncopy_STEAMROLLER, dtrmm_oltucopy_STEAMROLLER, dtrmm_oltncopy_STEAMROLLER,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_STEAMROLLER, dsymm_iltcopy_STEAMROLLER,
#else
  dsymm_outcopy_STEAMROLLER, dsymm_oltcopy_STEAMROLLER,
#endif
  dsymm_outcopy_STEAMROLLER, dsymm_oltcopy_STEAMROLLER,

#ifndef NO_LAPACK
  dneg_tcopy_STEAMROLLER, dlaswp_ncopy_STEAMROLLER,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_STEAMROLLER,  qamin_k_STEAMROLLER,  qmax_k_STEAMROLLER,  qmin_k_STEAMROLLER,
  iqamax_k_STEAMROLLER, iqamin_k_STEAMROLLER, iqmax_k_STEAMROLLER, iqmin_k_STEAMROLLER,
  qnrm2_k_STEAMROLLER,  qasum_k_STEAMROLLER,  qsum_k_STEAMROLLER, qcopy_k_STEAMROLLER, qdot_k_STEAMROLLER,
  qrot_k_STEAMROLLER,   qrotm_k_STEAMROLLER,  qaxpy_k_STEAMROLLER,  qscal_k_STEAMROLLER, qswap_k_STEAMROLLER,
  qgemv_n_STEAMROLLER,  qgemv_t_STEAMROLLER,  qger_k_STEAMROLLER,
  qsymv_L_STEAMROLLER,  qsymv_U_STEAMROLLER,
  qgemm_kernel_STEAMROLLER, qgemm_beta_STEAMROLLER,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_STEAMROLLER, qgemm_itcopy_STEAMROLLER,
#else
  qgemm_oncopy_STEAMROLLER, qgemm_otcopy_STEAMROLLER,
#endif
  qgemm_oncopy_STEAMROLLER, qgemm_otcopy_STEAMROLLER,
  qtrsm_kernel_LN_STEAMROLLER, qtrsm_kernel_LT_STEAMROLLER, qtrsm_kernel_RN_STEAMROLLER, qtrsm_kernel_RT_STEAMROLLER,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_STEAMROLLER, qtrsm_iunncopy_STEAMROLLER, qtrsm_iutucopy_STEAMROLLER, qtrsm_iutncopy_STEAMROLLER,
  qtrsm_ilnucopy_STEAMROLLER, qtrsm_ilnncopy_STEAMROLLER, qtrsm_iltucopy_STEAMROLLER, qtrsm_iltncopy_STEAMROLLER,
#else
  qtrsm_ounucopy_STEAMROLLER, qtrsm_ounncopy_STEAMROLLER, qtrsm_outucopy_STEAMROLLER, qtrsm_outncopy_STEAMROLLER,
  qtrsm_olnucopy_STEAMROLLER, qtrsm_olnncopy_STEAMROLLER, qtrsm_oltucopy_STEAMROLLER, qtrsm_oltncopy_STEAMROLLER,
#endif
  qtrsm_ounucopy_STEAMROLLER, qtrsm_ounncopy_STEAMROLLER, qtrsm_outucopy_STEAMROLLER, qtrsm_outncopy_STEAMROLLER,
  qtrsm_olnucopy_STEAMROLLER, qtrsm_olnncopy_STEAMROLLER, qtrsm_oltucopy_STEAMROLLER, qtrsm_oltncopy_STEAMROLLER,
  qtrmm_kernel_RN_STEAMROLLER, qtrmm_kernel_RT_STEAMROLLER, qtrmm_kernel_LN_STEAMROLLER, qtrmm_kernel_LT_STEAMROLLER,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_STEAMROLLER, qtrmm_iunncopy_STEAMROLLER, qtrmm_iutucopy_STEAMROLLER, qtrmm_iutncopy_STEAMROLLER,
  qtrmm_ilnucopy_STEAMROLLER, qtrmm_ilnncopy_STEAMROLLER, qtrmm_iltucopy_STEAMROLLER, qtrmm_iltncopy_STEAMROLLER,
#else
  qtrmm_ounucopy_STEAMROLLER, qtrmm_ounncopy_STEAMROLLER, qtrmm_outucopy_STEAMROLLER, qtrmm_outncopy_STEAMROLLER,
  qtrmm_olnucopy_STEAMROLLER, qtrmm_olnncopy_STEAMROLLER, qtrmm_oltucopy_STEAMROLLER, qtrmm_oltncopy_STEAMROLLER,
#endif
  qtrmm_ounucopy_STEAMROLLER, qtrmm_ounncopy_STEAMROLLER, qtrmm_outucopy_STEAMROLLER, qtrmm_outncopy_STEAMROLLER,
  qtrmm_olnucopy_STEAMROLLER, qtrmm_olnncopy_STEAMROLLER, qtrmm_oltucopy_STEAMROLLER, qtrmm_oltncopy_STEAMROLLER,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_STEAMROLLER, qsymm_iltcopy_STEAMROLLER,
#else
  qsymm_outcopy_STEAMROLLER, qsymm_oltcopy_STEAMROLLER,
#endif
  qsymm_outcopy_STEAMROLLER, qsymm_oltcopy_STEAMROLLER,

#ifndef NO_LAPACK
  qneg_tcopy_STEAMROLLER, qlaswp_ncopy_STEAMROLLER,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_STEAMROLLER, camin_k_STEAMROLLER,
#endif
#if (BUILD_COMPLEX)
  icamax_k_STEAMROLLER, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_STEAMROLLER,
  cnrm2_k_STEAMROLLER, casum_k_STEAMROLLER, csum_k_STEAMROLLER,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_STEAMROLLER, cdotu_k_STEAMROLLER, cdotc_k_STEAMROLLER,
#endif
#if (BUILD_COMPLEX)
 csrot_k_STEAMROLLER,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_STEAMROLLER,
  caxpyc_k_STEAMROLLER, 
  cscal_k_STEAMROLLER, 
  cswap_k_STEAMROLLER,

  cgemv_n_STEAMROLLER, cgemv_t_STEAMROLLER, cgemv_r_STEAMROLLER, cgemv_c_STEAMROLLER,
  cgemv_o_STEAMROLLER, cgemv_u_STEAMROLLER, cgemv_s_STEAMROLLER, cgemv_d_STEAMROLLER,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_STEAMROLLER, cgerc_k_STEAMROLLER, cgerv_k_STEAMROLLER, cgerd_k_STEAMROLLER,
  csymv_L_STEAMROLLER, csymv_U_STEAMROLLER,
  chemv_L_STEAMROLLER, chemv_U_STEAMROLLER, chemv_M_STEAMROLLER, chemv_V_STEAMROLLER,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_STEAMROLLER, cgemm_kernel_l_STEAMROLLER, cgemm_kernel_r_STEAMROLLER, cgemm_kernel_b_STEAMROLLER,
  cgemm_beta_STEAMROLLER,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_STEAMROLLER, cgemm_itcopy_STEAMROLLER,
#else
  cgemm_oncopy_STEAMROLLER, cgemm_otcopy_STEAMROLLER,
#endif
  cgemm_oncopy_STEAMROLLER, cgemm_otcopy_STEAMROLLER,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_STEAMROLLER,
  cgemm_small_kernel_nn_STEAMROLLER, cgemm_small_kernel_nt_STEAMROLLER, cgemm_small_kernel_nr_STEAMROLLER, cgemm_small_kernel_nc_STEAMROLLER,
  cgemm_small_kernel_tn_STEAMROLLER, cgemm_small_kernel_tt_STEAMROLLER, cgemm_small_kernel_tr_STEAMROLLER, cgemm_small_kernel_tc_STEAMROLLER,
  cgemm_small_kernel_rn_STEAMROLLER, cgemm_small_kernel_rt_STEAMROLLER, cgemm_small_kernel_rr_STEAMROLLER, cgemm_small_kernel_rc_STEAMROLLER,
  cgemm_small_kernel_cn_STEAMROLLER, cgemm_small_kernel_ct_STEAMROLLER, cgemm_small_kernel_cr_STEAMROLLER, cgemm_small_kernel_cc_STEAMROLLER,
  cgemm_small_kernel_b0_nn_STEAMROLLER, cgemm_small_kernel_b0_nt_STEAMROLLER, cgemm_small_kernel_b0_nr_STEAMROLLER, cgemm_small_kernel_b0_nc_STEAMROLLER,
  cgemm_small_kernel_b0_tn_STEAMROLLER, cgemm_small_kernel_b0_tt_STEAMROLLER, cgemm_small_kernel_b0_tr_STEAMROLLER, cgemm_small_kernel_b0_tc_STEAMROLLER,
  cgemm_small_kernel_b0_rn_STEAMROLLER, cgemm_small_kernel_b0_rt_STEAMROLLER, cgemm_small_kernel_b0_rr_STEAMROLLER, cgemm_small_kernel_b0_rc_STEAMROLLER,
  cgemm_small_kernel_b0_cn_STEAMROLLER, cgemm_small_kernel_b0_ct_STEAMROLLER, cgemm_small_kernel_b0_cr_STEAMROLLER, cgemm_small_kernel_b0_cc_STEAMROLLER,
#endif

  ctrsm_kernel_LN_STEAMROLLER, ctrsm_kernel_LT_STEAMROLLER, ctrsm_kernel_LR_STEAMROLLER, ctrsm_kernel_LC_STEAMROLLER,
  ctrsm_kernel_RN_STEAMROLLER, ctrsm_kernel_RT_STEAMROLLER, ctrsm_kernel_RR_STEAMROLLER, ctrsm_kernel_RC_STEAMROLLER,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_STEAMROLLER,  ctrsm_iunncopy_STEAMROLLER,  ctrsm_iutucopy_STEAMROLLER,  ctrsm_iutncopy_STEAMROLLER,
  ctrsm_ilnucopy_STEAMROLLER,  ctrsm_ilnncopy_STEAMROLLER,  ctrsm_iltucopy_STEAMROLLER,  ctrsm_iltncopy_STEAMROLLER,
#else
  ctrsm_ounucopy_STEAMROLLER,  ctrsm_ounncopy_STEAMROLLER,  ctrsm_outucopy_STEAMROLLER,  ctrsm_outncopy_STEAMROLLER,
  ctrsm_olnucopy_STEAMROLLER,  ctrsm_olnncopy_STEAMROLLER,  ctrsm_oltucopy_STEAMROLLER,  ctrsm_oltncopy_STEAMROLLER,
#endif
  ctrsm_ounucopy_STEAMROLLER,  ctrsm_ounncopy_STEAMROLLER,  ctrsm_outucopy_STEAMROLLER,  ctrsm_outncopy_STEAMROLLER,
  ctrsm_olnucopy_STEAMROLLER,  ctrsm_olnncopy_STEAMROLLER,  ctrsm_oltucopy_STEAMROLLER,  ctrsm_oltncopy_STEAMROLLER,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_STEAMROLLER,  ctrmm_kernel_RT_STEAMROLLER,  ctrmm_kernel_RR_STEAMROLLER,  ctrmm_kernel_RC_STEAMROLLER,
  ctrmm_kernel_LN_STEAMROLLER,  ctrmm_kernel_LT_STEAMROLLER,  ctrmm_kernel_LR_STEAMROLLER,  ctrmm_kernel_LC_STEAMROLLER,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_STEAMROLLER,  ctrmm_iunncopy_STEAMROLLER,  ctrmm_iutucopy_STEAMROLLER,  ctrmm_iutncopy_STEAMROLLER,
  ctrmm_ilnucopy_STEAMROLLER,  ctrmm_ilnncopy_STEAMROLLER,  ctrmm_iltucopy_STEAMROLLER,  ctrmm_iltncopy_STEAMROLLER,
#else
  ctrmm_ounucopy_STEAMROLLER,  ctrmm_ounncopy_STEAMROLLER,  ctrmm_outucopy_STEAMROLLER,  ctrmm_outncopy_STEAMROLLER,
  ctrmm_olnucopy_STEAMROLLER,  ctrmm_olnncopy_STEAMROLLER,  ctrmm_oltucopy_STEAMROLLER,  ctrmm_oltncopy_STEAMROLLER,
#endif
  ctrmm_ounucopy_STEAMROLLER,  ctrmm_ounncopy_STEAMROLLER,  ctrmm_outucopy_STEAMROLLER,  ctrmm_outncopy_STEAMROLLER,
  ctrmm_olnucopy_STEAMROLLER,  ctrmm_olnncopy_STEAMROLLER,  ctrmm_oltucopy_STEAMROLLER,  ctrmm_oltncopy_STEAMROLLER,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_STEAMROLLER,  csymm_iltcopy_STEAMROLLER,
#else
  csymm_outcopy_STEAMROLLER,  csymm_oltcopy_STEAMROLLER,
#endif
  csymm_outcopy_STEAMROLLER,  csymm_oltcopy_STEAMROLLER,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_STEAMROLLER,  chemm_iltcopy_STEAMROLLER,
#else
  chemm_outcopy_STEAMROLLER,  chemm_oltcopy_STEAMROLLER,
#endif
  chemm_outcopy_STEAMROLLER,  chemm_oltcopy_STEAMROLLER,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_STEAMROLLER,

  cgemm3m_incopyb_STEAMROLLER,  cgemm3m_incopyr_STEAMROLLER,
  cgemm3m_incopyi_STEAMROLLER,  cgemm3m_itcopyb_STEAMROLLER,
  cgemm3m_itcopyr_STEAMROLLER,  cgemm3m_itcopyi_STEAMROLLER,
  cgemm3m_oncopyb_STEAMROLLER,  cgemm3m_oncopyr_STEAMROLLER,
  cgemm3m_oncopyi_STEAMROLLER,  cgemm3m_otcopyb_STEAMROLLER,
  cgemm3m_otcopyr_STEAMROLLER,  cgemm3m_otcopyi_STEAMROLLER,

  csymm3m_iucopyb_STEAMROLLER,  csymm3m_ilcopyb_STEAMROLLER,
  csymm3m_iucopyr_STEAMROLLER,  csymm3m_ilcopyr_STEAMROLLER,
  csymm3m_iucopyi_STEAMROLLER,  csymm3m_ilcopyi_STEAMROLLER,
  csymm3m_oucopyb_STEAMROLLER,  csymm3m_olcopyb_STEAMROLLER,
  csymm3m_oucopyr_STEAMROLLER,  csymm3m_olcopyr_STEAMROLLER,
  csymm3m_oucopyi_STEAMROLLER,  csymm3m_olcopyi_STEAMROLLER,

  chemm3m_iucopyb_STEAMROLLER,  chemm3m_ilcopyb_STEAMROLLER,
  chemm3m_iucopyr_STEAMROLLER,  chemm3m_ilcopyr_STEAMROLLER,
  chemm3m_iucopyi_STEAMROLLER,  chemm3m_ilcopyi_STEAMROLLER,

  chemm3m_oucopyb_STEAMROLLER,  chemm3m_olcopyb_STEAMROLLER,
  chemm3m_oucopyr_STEAMROLLER,  chemm3m_olcopyr_STEAMROLLER,
  chemm3m_oucopyi_STEAMROLLER,  chemm3m_olcopyi_STEAMROLLER,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_STEAMROLLER,
  
   claswp_ncopy_STEAMROLLER,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_STEAMROLLER, zamin_k_STEAMROLLER, izamax_k_STEAMROLLER, izamin_k_STEAMROLLER,
  znrm2_k_STEAMROLLER, zasum_k_STEAMROLLER, zsum_k_STEAMROLLER, zcopy_k_STEAMROLLER,
  zdotu_k_STEAMROLLER, zdotc_k_STEAMROLLER, zdrot_k_STEAMROLLER,
  zaxpy_k_STEAMROLLER, zaxpyc_k_STEAMROLLER, zscal_k_STEAMROLLER, zswap_k_STEAMROLLER,

  zgemv_n_STEAMROLLER, zgemv_t_STEAMROLLER, zgemv_r_STEAMROLLER, zgemv_c_STEAMROLLER,
  zgemv_o_STEAMROLLER, zgemv_u_STEAMROLLER, zgemv_s_STEAMROLLER, zgemv_d_STEAMROLLER,
  zgeru_k_STEAMROLLER, zgerc_k_STEAMROLLER, zgerv_k_STEAMROLLER, zgerd_k_STEAMROLLER,
  zsymv_L_STEAMROLLER, zsymv_U_STEAMROLLER,
  zhemv_L_STEAMROLLER, zhemv_U_STEAMROLLER, zhemv_M_STEAMROLLER, zhemv_V_STEAMROLLER,

  zgemm_kernel_n_STEAMROLLER, zgemm_kernel_l_STEAMROLLER, zgemm_kernel_r_STEAMROLLER, zgemm_kernel_b_STEAMROLLER,
  zgemm_beta_STEAMROLLER,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_STEAMROLLER, zgemm_itcopy_STEAMROLLER,
#else
  zgemm_oncopy_STEAMROLLER, zgemm_otcopy_STEAMROLLER,
#endif
  zgemm_oncopy_STEAMROLLER, zgemm_otcopy_STEAMROLLER,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_STEAMROLLER,
  zgemm_small_kernel_nn_STEAMROLLER, zgemm_small_kernel_nt_STEAMROLLER, zgemm_small_kernel_nr_STEAMROLLER, zgemm_small_kernel_nc_STEAMROLLER,
  zgemm_small_kernel_tn_STEAMROLLER, zgemm_small_kernel_tt_STEAMROLLER, zgemm_small_kernel_tr_STEAMROLLER, zgemm_small_kernel_tc_STEAMROLLER,
  zgemm_small_kernel_rn_STEAMROLLER, zgemm_small_kernel_rt_STEAMROLLER, zgemm_small_kernel_rr_STEAMROLLER, zgemm_small_kernel_rc_STEAMROLLER,
  zgemm_small_kernel_cn_STEAMROLLER, zgemm_small_kernel_ct_STEAMROLLER, zgemm_small_kernel_cr_STEAMROLLER, zgemm_small_kernel_cc_STEAMROLLER,
  zgemm_small_kernel_b0_nn_STEAMROLLER, zgemm_small_kernel_b0_nt_STEAMROLLER, zgemm_small_kernel_b0_nr_STEAMROLLER, zgemm_small_kernel_b0_nc_STEAMROLLER,
  zgemm_small_kernel_b0_tn_STEAMROLLER, zgemm_small_kernel_b0_tt_STEAMROLLER, zgemm_small_kernel_b0_tr_STEAMROLLER, zgemm_small_kernel_b0_tc_STEAMROLLER,
  zgemm_small_kernel_b0_rn_STEAMROLLER, zgemm_small_kernel_b0_rt_STEAMROLLER, zgemm_small_kernel_b0_rr_STEAMROLLER, zgemm_small_kernel_b0_rc_STEAMROLLER,
  zgemm_small_kernel_b0_cn_STEAMROLLER, zgemm_small_kernel_b0_ct_STEAMROLLER, zgemm_small_kernel_b0_cr_STEAMROLLER, zgemm_small_kernel_b0_cc_STEAMROLLER,
#endif

  ztrsm_kernel_LN_STEAMROLLER, ztrsm_kernel_LT_STEAMROLLER, ztrsm_kernel_LR_STEAMROLLER, ztrsm_kernel_LC_STEAMROLLER,
  ztrsm_kernel_RN_STEAMROLLER, ztrsm_kernel_RT_STEAMROLLER, ztrsm_kernel_RR_STEAMROLLER, ztrsm_kernel_RC_STEAMROLLER,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_STEAMROLLER,  ztrsm_iunncopy_STEAMROLLER,  ztrsm_iutucopy_STEAMROLLER,  ztrsm_iutncopy_STEAMROLLER,
  ztrsm_ilnucopy_STEAMROLLER,  ztrsm_ilnncopy_STEAMROLLER,  ztrsm_iltucopy_STEAMROLLER,  ztrsm_iltncopy_STEAMROLLER,
#else
  ztrsm_ounucopy_STEAMROLLER,  ztrsm_ounncopy_STEAMROLLER,  ztrsm_outucopy_STEAMROLLER,  ztrsm_outncopy_STEAMROLLER,
  ztrsm_olnucopy_STEAMROLLER,  ztrsm_olnncopy_STEAMROLLER,  ztrsm_oltucopy_STEAMROLLER,  ztrsm_oltncopy_STEAMROLLER,
#endif
  ztrsm_ounucopy_STEAMROLLER,  ztrsm_ounncopy_STEAMROLLER,  ztrsm_outucopy_STEAMROLLER,  ztrsm_outncopy_STEAMROLLER,
  ztrsm_olnucopy_STEAMROLLER,  ztrsm_olnncopy_STEAMROLLER,  ztrsm_oltucopy_STEAMROLLER,  ztrsm_oltncopy_STEAMROLLER,

  ztrmm_kernel_RN_STEAMROLLER,  ztrmm_kernel_RT_STEAMROLLER,  ztrmm_kernel_RR_STEAMROLLER,  ztrmm_kernel_RC_STEAMROLLER,
  ztrmm_kernel_LN_STEAMROLLER,  ztrmm_kernel_LT_STEAMROLLER,  ztrmm_kernel_LR_STEAMROLLER,  ztrmm_kernel_LC_STEAMROLLER,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_STEAMROLLER,  ztrmm_iunncopy_STEAMROLLER,  ztrmm_iutucopy_STEAMROLLER,  ztrmm_iutncopy_STEAMROLLER,
  ztrmm_ilnucopy_STEAMROLLER,  ztrmm_ilnncopy_STEAMROLLER,  ztrmm_iltucopy_STEAMROLLER,  ztrmm_iltncopy_STEAMROLLER,
#else
  ztrmm_ounucopy_STEAMROLLER,  ztrmm_ounncopy_STEAMROLLER,  ztrmm_outucopy_STEAMROLLER,  ztrmm_outncopy_STEAMROLLER,
  ztrmm_olnucopy_STEAMROLLER,  ztrmm_olnncopy_STEAMROLLER,  ztrmm_oltucopy_STEAMROLLER,  ztrmm_oltncopy_STEAMROLLER,
#endif
  ztrmm_ounucopy_STEAMROLLER,  ztrmm_ounncopy_STEAMROLLER,  ztrmm_outucopy_STEAMROLLER,  ztrmm_outncopy_STEAMROLLER,
  ztrmm_olnucopy_STEAMROLLER,  ztrmm_olnncopy_STEAMROLLER,  ztrmm_oltucopy_STEAMROLLER,  ztrmm_oltncopy_STEAMROLLER,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_STEAMROLLER,  zsymm_iltcopy_STEAMROLLER,
#else
  zsymm_outcopy_STEAMROLLER,  zsymm_oltcopy_STEAMROLLER,
#endif
  zsymm_outcopy_STEAMROLLER,  zsymm_oltcopy_STEAMROLLER,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_STEAMROLLER,  zhemm_iltcopy_STEAMROLLER,
#else
  zhemm_outcopy_STEAMROLLER,  zhemm_oltcopy_STEAMROLLER,
#endif
  zhemm_outcopy_STEAMROLLER,  zhemm_oltcopy_STEAMROLLER,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_STEAMROLLER,

  zgemm3m_incopyb_STEAMROLLER,  zgemm3m_incopyr_STEAMROLLER,
  zgemm3m_incopyi_STEAMROLLER,  zgemm3m_itcopyb_STEAMROLLER,
  zgemm3m_itcopyr_STEAMROLLER,  zgemm3m_itcopyi_STEAMROLLER,
  zgemm3m_oncopyb_STEAMROLLER,  zgemm3m_oncopyr_STEAMROLLER,
  zgemm3m_oncopyi_STEAMROLLER,  zgemm3m_otcopyb_STEAMROLLER,
  zgemm3m_otcopyr_STEAMROLLER,  zgemm3m_otcopyi_STEAMROLLER,

  zsymm3m_iucopyb_STEAMROLLER,  zsymm3m_ilcopyb_STEAMROLLER,
  zsymm3m_iucopyr_STEAMROLLER,  zsymm3m_ilcopyr_STEAMROLLER,
  zsymm3m_iucopyi_STEAMROLLER,  zsymm3m_ilcopyi_STEAMROLLER,
  zsymm3m_oucopyb_STEAMROLLER,  zsymm3m_olcopyb_STEAMROLLER,
  zsymm3m_oucopyr_STEAMROLLER,  zsymm3m_olcopyr_STEAMROLLER,
  zsymm3m_oucopyi_STEAMROLLER,  zsymm3m_olcopyi_STEAMROLLER,

  zhemm3m_iucopyb_STEAMROLLER,  zhemm3m_ilcopyb_STEAMROLLER,
  zhemm3m_iucopyr_STEAMROLLER,  zhemm3m_ilcopyr_STEAMROLLER,
  zhemm3m_iucopyi_STEAMROLLER,  zhemm3m_ilcopyi_STEAMROLLER,

  zhemm3m_oucopyb_STEAMROLLER,  zhemm3m_olcopyb_STEAMROLLER,
  zhemm3m_oucopyr_STEAMROLLER,  zhemm3m_olcopyr_STEAMROLLER,
  zhemm3m_oucopyi_STEAMROLLER,  zhemm3m_olcopyi_STEAMROLLER,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_STEAMROLLER, zlaswp_ncopy_STEAMROLLER,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_STEAMROLLER, xamin_k_STEAMROLLER, ixamax_k_STEAMROLLER, ixamin_k_STEAMROLLER,
  xnrm2_k_STEAMROLLER, xasum_k_STEAMROLLER, xsum_k_STEAMROLLER, xcopy_k_STEAMROLLER,
  xdotu_k_STEAMROLLER, xdotc_k_STEAMROLLER, xqrot_k_STEAMROLLER,
  xaxpy_k_STEAMROLLER, xaxpyc_k_STEAMROLLER, xscal_k_STEAMROLLER, xswap_k_STEAMROLLER,

  xgemv_n_STEAMROLLER, xgemv_t_STEAMROLLER, xgemv_r_STEAMROLLER, xgemv_c_STEAMROLLER,
  xgemv_o_STEAMROLLER, xgemv_u_STEAMROLLER, xgemv_s_STEAMROLLER, xgemv_d_STEAMROLLER,
  xgeru_k_STEAMROLLER, xgerc_k_STEAMROLLER, xgerv_k_STEAMROLLER, xgerd_k_STEAMROLLER,
  xsymv_L_STEAMROLLER, xsymv_U_STEAMROLLER,
  xhemv_L_STEAMROLLER, xhemv_U_STEAMROLLER, xhemv_M_STEAMROLLER, xhemv_V_STEAMROLLER,

  xgemm_kernel_n_STEAMROLLER, xgemm_kernel_l_STEAMROLLER, xgemm_kernel_r_STEAMROLLER, xgemm_kernel_b_STEAMROLLER,
  xgemm_beta_STEAMROLLER,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_STEAMROLLER, xgemm_itcopy_STEAMROLLER,
#else
  xgemm_oncopy_STEAMROLLER, xgemm_otcopy_STEAMROLLER,
#endif
  xgemm_oncopy_STEAMROLLER, xgemm_otcopy_STEAMROLLER,

  xtrsm_kernel_LN_STEAMROLLER, xtrsm_kernel_LT_STEAMROLLER, xtrsm_kernel_LR_STEAMROLLER, xtrsm_kernel_LC_STEAMROLLER,
  xtrsm_kernel_RN_STEAMROLLER, xtrsm_kernel_RT_STEAMROLLER, xtrsm_kernel_RR_STEAMROLLER, xtrsm_kernel_RC_STEAMROLLER,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_STEAMROLLER,  xtrsm_iunncopy_STEAMROLLER,  xtrsm_iutucopy_STEAMROLLER,  xtrsm_iutncopy_STEAMROLLER,
  xtrsm_ilnucopy_STEAMROLLER,  xtrsm_ilnncopy_STEAMROLLER,  xtrsm_iltucopy_STEAMROLLER,  xtrsm_iltncopy_STEAMROLLER,
#else
  xtrsm_ounucopy_STEAMROLLER,  xtrsm_ounncopy_STEAMROLLER,  xtrsm_outucopy_STEAMROLLER,  xtrsm_outncopy_STEAMROLLER,
  xtrsm_olnucopy_STEAMROLLER,  xtrsm_olnncopy_STEAMROLLER,  xtrsm_oltucopy_STEAMROLLER,  xtrsm_oltncopy_STEAMROLLER,
#endif
  xtrsm_ounucopy_STEAMROLLER,  xtrsm_ounncopy_STEAMROLLER,  xtrsm_outucopy_STEAMROLLER,  xtrsm_outncopy_STEAMROLLER,
  xtrsm_olnucopy_STEAMROLLER,  xtrsm_olnncopy_STEAMROLLER,  xtrsm_oltucopy_STEAMROLLER,  xtrsm_oltncopy_STEAMROLLER,

  xtrmm_kernel_RN_STEAMROLLER,  xtrmm_kernel_RT_STEAMROLLER,  xtrmm_kernel_RR_STEAMROLLER,  xtrmm_kernel_RC_STEAMROLLER,
  xtrmm_kernel_LN_STEAMROLLER,  xtrmm_kernel_LT_STEAMROLLER,  xtrmm_kernel_LR_STEAMROLLER,  xtrmm_kernel_LC_STEAMROLLER,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_STEAMROLLER,  xtrmm_iunncopy_STEAMROLLER,  xtrmm_iutucopy_STEAMROLLER,  xtrmm_iutncopy_STEAMROLLER,
  xtrmm_ilnucopy_STEAMROLLER,  xtrmm_ilnncopy_STEAMROLLER,  xtrmm_iltucopy_STEAMROLLER,  xtrmm_iltncopy_STEAMROLLER,
#else
  xtrmm_ounucopy_STEAMROLLER,  xtrmm_ounncopy_STEAMROLLER,  xtrmm_outucopy_STEAMROLLER,  xtrmm_outncopy_STEAMROLLER,
  xtrmm_olnucopy_STEAMROLLER,  xtrmm_olnncopy_STEAMROLLER,  xtrmm_oltucopy_STEAMROLLER,  xtrmm_oltncopy_STEAMROLLER,
#endif
  xtrmm_ounucopy_STEAMROLLER,  xtrmm_ounncopy_STEAMROLLER,  xtrmm_outucopy_STEAMROLLER,  xtrmm_outncopy_STEAMROLLER,
  xtrmm_olnucopy_STEAMROLLER,  xtrmm_olnncopy_STEAMROLLER,  xtrmm_oltucopy_STEAMROLLER,  xtrmm_oltncopy_STEAMROLLER,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_STEAMROLLER,  xsymm_iltcopy_STEAMROLLER,
#else
  xsymm_outcopy_STEAMROLLER,  xsymm_oltcopy_STEAMROLLER,
#endif
  xsymm_outcopy_STEAMROLLER,  xsymm_oltcopy_STEAMROLLER,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_STEAMROLLER,  xhemm_iltcopy_STEAMROLLER,
#else
  xhemm_outcopy_STEAMROLLER,  xhemm_oltcopy_STEAMROLLER,
#endif
  xhemm_outcopy_STEAMROLLER,  xhemm_oltcopy_STEAMROLLER,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_STEAMROLLER,

  xgemm3m_incopyb_STEAMROLLER,  xgemm3m_incopyr_STEAMROLLER,
  xgemm3m_incopyi_STEAMROLLER,  xgemm3m_itcopyb_STEAMROLLER,
  xgemm3m_itcopyr_STEAMROLLER,  xgemm3m_itcopyi_STEAMROLLER,
  xgemm3m_oncopyb_STEAMROLLER,  xgemm3m_oncopyr_STEAMROLLER,
  xgemm3m_oncopyi_STEAMROLLER,  xgemm3m_otcopyb_STEAMROLLER,
  xgemm3m_otcopyr_STEAMROLLER,  xgemm3m_otcopyi_STEAMROLLER,

  xsymm3m_iucopyb_STEAMROLLER,  xsymm3m_ilcopyb_STEAMROLLER,
  xsymm3m_iucopyr_STEAMROLLER,  xsymm3m_ilcopyr_STEAMROLLER,
  xsymm3m_iucopyi_STEAMROLLER,  xsymm3m_ilcopyi_STEAMROLLER,
  xsymm3m_oucopyb_STEAMROLLER,  xsymm3m_olcopyb_STEAMROLLER,
  xsymm3m_oucopyr_STEAMROLLER,  xsymm3m_olcopyr_STEAMROLLER,
  xsymm3m_oucopyi_STEAMROLLER,  xsymm3m_olcopyi_STEAMROLLER,

  xhemm3m_iucopyb_STEAMROLLER,  xhemm3m_ilcopyb_STEAMROLLER,
  xhemm3m_iucopyr_STEAMROLLER,  xhemm3m_ilcopyr_STEAMROLLER,
  xhemm3m_iucopyi_STEAMROLLER,  xhemm3m_ilcopyi_STEAMROLLER,

  xhemm3m_oucopyb_STEAMROLLER,  xhemm3m_olcopyb_STEAMROLLER,
  xhemm3m_oucopyr_STEAMROLLER,  xhemm3m_olcopyr_STEAMROLLER,
  xhemm3m_oucopyi_STEAMROLLER,  xhemm3m_olcopyi_STEAMROLLER,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_STEAMROLLER, xlaswp_ncopy_STEAMROLLER,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_STEAMROLLER,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_STEAMROLLER,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_STEAMROLLER,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_STEAMROLLER,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_STEAMROLLER, somatcopy_k_ct_STEAMROLLER, somatcopy_k_rn_STEAMROLLER, somatcopy_k_rt_STEAMROLLER,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_STEAMROLLER, domatcopy_k_ct_STEAMROLLER, domatcopy_k_rn_STEAMROLLER, domatcopy_k_rt_STEAMROLLER,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_STEAMROLLER, comatcopy_k_ct_STEAMROLLER, comatcopy_k_rn_STEAMROLLER, comatcopy_k_rt_STEAMROLLER,
  comatcopy_k_cnc_STEAMROLLER, comatcopy_k_ctc_STEAMROLLER, comatcopy_k_rnc_STEAMROLLER, comatcopy_k_rtc_STEAMROLLER,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_STEAMROLLER, zomatcopy_k_ct_STEAMROLLER, zomatcopy_k_rn_STEAMROLLER, zomatcopy_k_rt_STEAMROLLER,
  zomatcopy_k_cnc_STEAMROLLER, zomatcopy_k_ctc_STEAMROLLER, zomatcopy_k_rnc_STEAMROLLER, zomatcopy_k_rtc_STEAMROLLER,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_STEAMROLLER, simatcopy_k_ct_STEAMROLLER, simatcopy_k_rn_STEAMROLLER, simatcopy_k_rt_STEAMROLLER,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_STEAMROLLER, dimatcopy_k_ct_STEAMROLLER, dimatcopy_k_rn_STEAMROLLER, dimatcopy_k_rt_STEAMROLLER,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_STEAMROLLER, cimatcopy_k_ct_STEAMROLLER, cimatcopy_k_rn_STEAMROLLER, cimatcopy_k_rt_STEAMROLLER,
  cimatcopy_k_cnc_STEAMROLLER, cimatcopy_k_ctc_STEAMROLLER, cimatcopy_k_rnc_STEAMROLLER, cimatcopy_k_rtc_STEAMROLLER,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_STEAMROLLER, zimatcopy_k_ct_STEAMROLLER, zimatcopy_k_rn_STEAMROLLER, zimatcopy_k_rt_STEAMROLLER,
  zimatcopy_k_cnc_STEAMROLLER, zimatcopy_k_ctc_STEAMROLLER, zimatcopy_k_rnc_STEAMROLLER, zimatcopy_k_rtc_STEAMROLLER,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_STEAMROLLER,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_STEAMROLLER,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_STEAMROLLER,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_STEAMROLLER,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
