# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Linear model tests."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _LinearModelTest
else:
    import _LinearModelTest

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector

def LinearModelFisher(*args):
    r"""
    Test the nullity of the linear regression model coefficients.

    **Available usages**:

        LinearModelTest.LinearModelFisher(*firstSample, secondSample*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelFisher(*firstSample, secondSample, linearModelResult, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelFisher test checks the nullity of the regression linear model
    coefficients (Fisher distribution is used).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelFisher(firstSample, secondSample)
    >>> print(test_result.getPValue())
    5.1...e-12

    """
    return _LinearModelTest.LinearModelFisher(*args)

def LinearModelResidualMean(*args):
    r"""
    Test zero mean value of the residual of the linear regression model.

    **Available usages**:

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelResidualMean(*firstSample, secondSample, linearModelResult, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelFisher
    openturns.LinearModelTest.LinearModelHarrisonMcCabe

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    The LinearModelResidualMean Test checks, under the hypothesis of a gaussian
    sample, if the mean of the residual is equal to zero. It is based on the Student
    test (equality of mean for two gaussian samples).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelResidualMean(firstSample, secondSample)

    """
    return _LinearModelTest.LinearModelResidualMean(*args)

def LinearModelHarrisonMcCabe(*args):
    r"""
    Test the homoskedasticity of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, level, breakPoint, simulationSize*)

        LinearModelTest.LinearModelHarrisonMcCabe(*firstSample, secondSample, linearModelResult, level, breakPoint, simulationSize*)

    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.
    breakPoint : positive float :math:`< 1`
        Percentage of data to be taken as breakPoint in the variances. It must be
        :math:`< 1`, equal to 0.5 by default.
    simulationSize : positive int
        Size of the sample used to compute the p-value. Default is 1000.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelBreuschPagan
    openturns.LinearModelTest.LinearModelResidualMean
    openturns.LinearModelTest.LinearModelDurbinWatson

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual.

    The Harrison-McCabe test checks the heteroskedasticity of the residuals. The
    breakpoint in the variances is set by default to the half of the sample. The
    p-value is estimed using simulation. If the binary quality measure is false, then
    the homoskedasticity hypothesis can be rejected with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelHarrisonMcCabe(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=HarrisonMcCabe binaryQualityMeasure=true p-value threshold=0.05 p-value=0.142 statistic=0.373225 description=[]

    """
    return _LinearModelTest.LinearModelHarrisonMcCabe(*args)

def LinearModelBreuschPagan(*args):
    r"""
    Test the homoskedasticity of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, level*)

        LinearModelTest.LinearModelBreuschPagan(*firstSample, secondSample, linearModelResult, level*)

    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension 1.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelHarrisonMcCabe
    openturns.LinearModelTest.LinearModelResidualMean,
    openturns.LinearModelTest.LinearModelDurbinWatson

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual.

    The Breusch-Pagan test checks the heteroskedasticity of the residuals. A linear
    regression model is fitted on the squared residuals. The statistic is computed
    using the Studendized version with the chi-squared distribution. If the binary
    quality measure is false, then the homoskedasticity hypothesis can be rejected
    with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelBreuschPagan(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=BreuschPagan binaryQualityMeasure=true p-value threshold=0.05 p-value=0.700772 statistic=0.14767 description=[]

    """
    return _LinearModelTest.LinearModelBreuschPagan(*args)

def LinearModelDurbinWatson(*args):
    r"""
    Test the autocorrelation of the linear regression model residuals.

    **Available usages**:

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, hypothesis, level*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModelResult*)

        LinearModelTest.LinearModelDurbinWatson(*firstSample, secondSample, linearModelResult, hypothesis, level*)

    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1. This sample should be ordered in increasing order.
    linearModelResult : :class:`~openturns.LinearModelResult`
        A linear model. If not provided, it is built using the given samples.
    hypothesis : str
        Hypothesis H0 for the residuals. It can be : 'Equal' to 0, 'Less' than 0 or
        'Greater' than 0.

        Default value is set to 'Equal' to 0.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.

    Returns
    -------
    testResult : :class:`~openturns.TestResult`
        Structure containing the result of the test.

    See Also
    --------
    openturns.LinearModelTest.LinearModelBreuschPagan
    openturns.LinearModelTest.LinearModelHarrisonMcCabe
    openturns.LinearModelTest.LinearModelResidualMean

    Notes
    -----
    The LinearModelTest class is used through its static methods in order to evaluate
    the quality of the linear regression model between two samples.
    The linear regression model between the
    scalar variable :math:`Y` and the :math:`n`-dimensional one
    :math:`\vect{X} = (X_i)_{i \leq n}` is as follows:

    .. math::

        \tilde{Y} = a_0 + \sum_{i=1}^n a_i X_i + \epsilon

    where :math:`\epsilon` is the residual.

    The Durbin-Watson test checks the autocorrelation of the residuals. It is possible
    to test is the autocorrelation is equal to 0.
    The p-value is computed using a normal approximation based on the mean and variance of the
    Durbin-Watson test statistic. If the binary quality measure is false, then the
    given autocorrelation hypothesis can be rejected with respect to the given level.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction('x', '2 * x + 1')
    >>> firstSample = sample
    >>> secondSample = func(sample) + ot.Normal().getSample(30)
    >>> test_result = ot.LinearModelTest.LinearModelDurbinWatson(firstSample, secondSample)
    >>> print(test_result)
    class=TestResult name=Unnamed type=DurbinWatson binaryQualityMeasure=true p-value threshold=0.05 p-value=0.653603 statistic=0.448763 description=[H0: auto.cor=0]

    """
    return _LinearModelTest.LinearModelDurbinWatson(*args)

def PartialRegression(firstSample, secondSample, selection, level=0.05):
    r"""
    Test a linear correlation between two samples.

    **Available usages**:

        LinearModelTest.PartialRegression(*firstSample, secondSample, selection*)

        LinearModelTest.PartialRegression(*firstSample, secondSample, selection, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension :math:`p \geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    selection : sequence of int, maximum integer value :math:`< n`
        List of indices selecting which subsets of the first sample will successively
        be tested with the second sample through the regression test.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.

    Returns
    -------
    testResults : Collection of :class:`~openturns.TestResult`
        Results for each component of the linear model including intercept.

    See Also
    --------
    openturns.LinearModelTest.FullRegression
    openturns.LinearModelTest.LinearModelFisher

    Notes
    -----
    The PartialRegression method fits a linear model between :math:`Y` with respect to the selected components of :math:`(X_1, \dots, X_p)` from a sample of :math:`(X_1, \dots, X_p)` (called *firstSample*) and a sample of :math:`Y` (called *secondSample*):

    .. math::
       Y = a_0 + \sum_{k \in I}X_k

    where :math:`I` is the set of selected indices.

    The method returns a collection of :class:`~openturns.TestResult` that tests the null hypothesis:
    *The coefficient is null* for each coefficient of the linear relation: :math:`(a_k)_{k=0, \in I}`.
    The statistics used is detailed in :class:`~openturns.LinearModelAnalysis` and is based on the
    evaluation of the :math:`t_{score}`: see :meth:`~openturns.LinearModelAnalysis.getCoefficientsTScores`
    and :meth:`~openturns.LinearModelAnalysis.getCoefficientsPValues`.

    If the result of the test is *True*, then the coefficient is assumed to be null: there is no linear
    relation between the tested components. If the result of the test is *False*, then the coefficient is
    assumed to be significantly different from 0: there is a linear relation between the tested components.
    The Partial Regression Test is used to assess the linearity between a subset of
    components of *firstSample* and *secondSample*.
    The parameter *selection* enables to select specific subsets of the
    *firstSample* to be tested.

    Examples
    --------
    We create a sample generated by a Gaussian vector :math:`(X_1, X_2, X_3)` with zero mean, unit
    variance and which components :math:`(X_1, X_3)` are correlated.

    We fit the linear model: :math:`X_3 = a_0 + a_1X_1` and we test if each coefficient is
    significantly different from 0.
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> S = ot.CorrelationMatrix(3)
    >>> distribution = ot.Normal([0]*3, [1]*3, S)
    >>> sample = distribution.getSample(30)
    >>> firstSample = sample.getMarginal([0,1])
    >>> secondSample = sample.getMarginal(2)
    >>> selection = [1]
    >>> test_result = ot.LinearModelTest.PartialRegression(firstSample, secondSample, selection)
    >>> print(test_result[1])
    class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.172847 statistic=1.39882 description=[]

    """
    return _LinearModelTest.PartialRegression(firstSample, secondSample, selection, level)

def FullRegression(firstSample, secondSample, level=0.05):
    r"""
    Test a linear correlation between two samples.

    **Available usages**:

        LinearModelTest.FullRegression(*firstSample, secondSample*)

        LinearModelTest.FullRegression(*firstSample, secondSample, level*)


    Parameters
    ----------
    firstSample : 2-d sequence of float
        First tested sample, of dimension :math:`p \geq 1`.
    secondSample : 2-d sequence of float
        Second tested sample, of dimension 1.
    level : positive float :math:`< 1`
        Threshold p-value of the test (error Type I).

        Default value is 0.05.

    Returns
    -------
    testResults : Collection of :class:`~openturns.TestResult`
        Results for each component of the linear model including intercept.

    See Also
    --------
    openturns.LinearModelTest.PartialRegression
    openturns.LinearModelTest.LinearModelFisher

    Notes
    -----
    The FullRegression method fits a linear model between :math:`Y` with respect to :math:`(X_1, \dots, X_p)` from a sample of :math:`(X_1, \dots, X_p)` (called *firstSample*) and a sample of :math:`Y` (called *secondSample*):

    .. math::
       Y = a_0 + \sum_{k=1}^{p}X_k

    The method returns a collection of :class:`~openturns.TestResult` that tests the null hypothesis:
    *The coefficient is null* for each coefficient of the linear relation: :math:`(a_0, \dots, a_p)`.
    The statistics used is detailed in :class:`~openturns.LinearModelAnalysis` and is based on the
    evaluation of the :math:`t_{score}`: see :meth:`~openturns.LinearModelAnalysis.getCoefficientsTScores`
    and :meth:`~openturns.LinearModelAnalysis.getCoefficientsPValues`.

    If the result of the test is *True*, then the coefficient is assumed to be null: there is no linear
    relation between the tested components. If the result of the test is *False*, then the coefficient is
    assumed to be significantly different from 0: there is a linear relation between the tested components.

    Examples
    --------
    We create a sample generated by a Gaussian vector :math:`(X_1, X_2, X_3)` with zero mean, unit
    variance and which components :math:`(X_1, X_3)` are correlated.

    We fit the linear model: :math:`X_3 = a_0 + a_1X_1 + a_2X_2` and we test if each coefficient is significantly different from 0.
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> S = ot.CorrelationMatrix(3)
    >>> distribution = ot.Normal([0]*3, [1]*3, S)
    >>> sample = distribution.getSample(100)
    >>> firstSample = sample.getMarginal([0,1])
    >>> secondSample = sample.getMarginal(2)
    >>> test_result = ot.LinearModelTest.FullRegression(firstSample, secondSample)
    >>> for i in range(3):
    ...     print('Test for a' + str(i) + ' :' , test_result[i])
    Test for a0 : class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.82575 statistic=-0.220751 description=[]
    Test for a1 : class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.242986 statistic=1.17471 description=[]
    Test for a2 : class=TestResult name=Unnamed type=Regression binaryQualityMeasure=true p-value threshold=0.05 p-value=0.363986 statistic=0.912083 description=[]

    """
    return _LinearModelTest.FullRegression(firstSample, secondSample, level)

