// This code was autogenerated with `dbus-codegen-rust -d org.bluez.obex -p /org/bluez/obex -o Projects/test/obex/src/obex.rs`, see https://github.com/diwic/dbus-rs
use dbus::{self as dbus};
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait OrgFreedesktopDBusIntrospectable {
    fn introspect(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusIntrospectable for blocking::Proxy<'a, C> {

    fn introspect(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Introspectable", "Introspect", ()).map(|r: (String, )| r.0)
    }
}

pub trait ObexAgentManager1 {
    fn register_agent(&self, agent: dbus::Path) -> Result<(), dbus::Error>;
    fn unregister_agent(&self, agent: dbus::Path) -> Result<(), dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ObexAgentManager1 for blocking::Proxy<'a, C> {

    fn register_agent(&self, agent: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.bluez.obex.AgentManager1", "RegisterAgent", (agent, ))
    }

    fn unregister_agent(&self, agent: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.bluez.obex.AgentManager1", "UnregisterAgent", (agent, ))
    }
}

pub trait ObexClient1 {
    fn create_session(&self, destination: &str, args: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error>;
    fn remove_session(&self, session: dbus::Path) -> Result<(), dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ObexClient1 for blocking::Proxy<'a, C> {

    fn create_session(&self, destination: &str, args: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.bluez.obex.Client1", "CreateSession", (destination, args, )).map(|r: (dbus::Path<'static>, )| r.0)
    }

    fn remove_session(&self, session: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.bluez.obex.Client1", "RemoveSession", (session, ))
    }
}

pub trait ObexSession1 {
    fn get_capabilities(&self) -> Result<String, dbus::Error>;
    fn source(&self) -> Result<String, dbus::Error>;
    fn destination(&self) -> Result<String, dbus::Error>;
    fn target(&self) -> Result<String, dbus::Error>;
    fn root(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ObexSession1 for blocking::Proxy<'a, C> {

    fn get_capabilities(&self) -> Result<String, dbus::Error> {
        self.method_call("org.bluez.obex.Session1", "GetCapabilities", ()).map(|r: (String, )| r.0)
    }

    fn source(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Session1", "Source")
    }

    fn destination(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Session1", "Destination")
    }

    fn target(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Session1", "Target")
    }

    fn root(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Session1", "Root")
    }
}

pub trait ObexTransfer1 {
    fn cancel(&self) -> Result<(), dbus::Error>;
    fn status(&self) -> Result<String, dbus::Error>;
    fn session(&self) -> Result<dbus::Path<'static>, dbus::Error>;
    fn name(&self) -> Result<String, dbus::Error>;
    fn type_(&self) -> Result<String, dbus::Error>;
    fn size(&self) -> Result<u64, dbus::Error>;
    fn time(&self) -> Result<u64, dbus::Error>;
    fn filename(&self) -> Result<String, dbus::Error>;
    fn transferred(&self) -> Result<u64, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ObexTransfer1 for blocking::Proxy<'a, C> {

    fn cancel(&self) -> Result<(), dbus::Error> {
        self.method_call("org.bluez.obex.Transfer1", "Cancel", ())
    }

    fn status(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Status")
    }

    fn session(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Session")
    }

    fn name(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Name")
    }

    fn type_(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Type")
    }

    fn size(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Size")
    }

    fn time(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Time")
    }

    fn filename(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Filename")
    }

    fn transferred(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(self, "org.bluez.obex.Transfer1", "Transferred")
    }
}

pub trait ObexObjectPush1 {
    fn send_file(&self, sourcefile: &str) -> Result<(dbus::Path<'static>, arg::PropMap), dbus::Error>;
    fn pull_business_card(&self, targetfile: &str) -> Result<(dbus::Path<'static>, arg::PropMap), dbus::Error>;
    fn exchange_business_cards(&self, clientfile: &str, targetfile: &str) -> Result<(dbus::Path<'static>, arg::PropMap), dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ObexObjectPush1 for blocking::Proxy<'a, C> {

    fn send_file(&self, sourcefile: &str) -> Result<(dbus::Path<'static>, arg::PropMap), dbus::Error> {
        self.method_call("org.bluez.obex.ObjectPush1", "SendFile", (sourcefile, ))
    }

    fn pull_business_card(&self, targetfile: &str) -> Result<(dbus::Path<'static>, arg::PropMap), dbus::Error> {
        self.method_call("org.bluez.obex.ObjectPush1", "PullBusinessCard", (targetfile, ))
    }

    fn exchange_business_cards(&self, clientfile: &str, targetfile: &str) -> Result<(dbus::Path<'static>, arg::PropMap), dbus::Error> {
        self.method_call("org.bluez.obex.ObjectPush1", "ExchangeBusinessCards", (clientfile, targetfile, ))
    }
}