/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.exc.NcMismatchException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

class NcArrayLonLatUgridUtils {
    static boolean hasUgridAttributes(NcDataset ncd, VariableDS varDS, String location) {
        Logger logger = NcArrayLonLatUgridUtils.getClassLogger();
        String conventionStr = ncd.getGlobalAttributeString("Conventions");
        logger.trace("-- dataset conventions, '{}'", (Object)conventionStr);
        if (conventionStr == null) {
            return false;
        }
        if (!conventionStr.contains("UGRID-1.0")) {
            return false;
        }
        String meshStr = NcArrayLonLatUgridUtils.getMeshName(varDS);
        if (meshStr == null) {
            return false;
        }
        String locStr = NcArrayLonLatUgridUtils.getMeshLocation(varDS);
        logger.trace("-- location attribute, '{}'", (Object)locStr);
        if (locStr == null) {
            return false;
        }
        if (!locStr.equals(location)) {
            return false;
        }
        VariableDS meshVar = ncd.getVariableDS(meshStr);
        logger.trace("-- meshVar present, {}", (Object)(meshVar != null ? 1 : 0));
        return true;
    }

    static String getMeshName(VariableDS varDS) {
        String meshStr = NcUtils.getAttributeStringIgnoreCase(varDS, "mesh");
        return meshStr;
    }

    static String getMeshLocation(VariableDS varDS) {
        String locStr = NcUtils.getAttributeStringIgnoreCase(varDS, "location");
        return locStr;
    }

    static VariableDS[] getCoordinateVars(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatUgridUtils.getCoordinateVars(ncd, varDS);
    }

    static VariableDS[] getCoordinateVars(NcDataset ncd, VariableDS varDS) {
        VariableDS[] vars = NcArrayLonLatUgridUtils.getCoordinateVarsCS(ncd, varDS);
        if (vars != null) {
            NcArrayLonLatUgridUtils.getClassLogger().trace("getCoordinateVarsCS apparently successful");
            return vars;
        }
        if ("face".equals(NcArrayLonLatUgridUtils.getMeshLocation(varDS))) {
            vars = NcArrayLonLatUgridUtils.getFaceCoordinateVars(ncd, varDS);
        }
        if (vars != null) {
            NcArrayLonLatUgridUtils.getClassLogger().trace("getFaceCoordinateVars apparently successful");
            return vars;
        }
        return null;
    }

    static VariableDS[] getCoordinateVarsCS(NcDataset ncd, VariableDS varDS) {
        Logger logger = NcArrayLonLatUgridUtils.getClassLogger();
        List csList = varDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            logger.trace("No/empty csList");
            return null;
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        if (cs == null) {
            logger.trace("CS 0 is null");
            return null;
        }
        logger.trace("Found a coordinate system to work with");
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null && latax == null) {
            logger.trace("Did not find lon var or lat var or both");
            return null;
        }
        logger.trace("lon {}, lat {}", (Object)lonax.getShortName(), (Object)latax.getShortName());
        return new VariableDS[]{lonax, latax};
    }

    static VariableDS[] getFaceCoordinateVars(NcDataset ncd, VariableDS varDS) {
        Logger logger = NcArrayLonLatUgridUtils.getClassLogger();
        String meshStr = NcArrayLonLatUgridUtils.getMeshName(varDS);
        VariableDS lonvarDS = ncd.getVariableDS(meshStr + "_face_x");
        VariableDS latvarDS = ncd.getVariableDS(meshStr + "_face_y");
        if (lonvarDS == null) {
            logger.trace("Did not find a face longitude coordinate variable");
            return null;
        }
        if (latvarDS == null) {
            logger.trace("Did not find a face latitude coordinate variable");
            return null;
        }
        return new VariableDS[]{lonvarDS, latvarDS};
    }

    static VariableDS[] getNodeCoordinateVars(NcDataset ncd, VariableDS varDS) {
        Logger logger = NcArrayLonLatUgridUtils.getClassLogger();
        String meshStr = NcArrayLonLatUgridUtils.getMeshName(varDS);
        VariableDS lonvarDS = ncd.getVariableDS(meshStr + "_node_x");
        VariableDS latvarDS = ncd.getVariableDS(meshStr + "_node_y");
        if (lonvarDS == null) {
            logger.trace("Did not find a node longitude coordinate variable");
            return null;
        }
        if (latvarDS == null) {
            logger.trace("Did not find a node latitude coordinate variable");
            return null;
        }
        return new VariableDS[]{lonvarDS, latvarDS};
    }

    static VariableDS getEdgeFacesVar(NcDataset ncd, VariableDS edgeVarDS) {
        String meshStr = NcArrayLonLatUgridUtils.getMeshName(edgeVarDS);
        Logger logger = NcArrayLonLatUgridUtils.getClassLogger();
        logger.trace("Looking for {}_edge_faces", (Object)meshStr);
        return ncd.getVariableDS(meshStr + "_edge_faces");
    }

    static VariableDS getEdgeNodesVar(NcDataset ncd, VariableDS edgeVarDS) {
        String meshStr = NcArrayLonLatUgridUtils.getMeshName(edgeVarDS);
        return ncd.getVariableDS(meshStr + "_edge_nodes");
    }

    static ArrayInt.D2 getArrayInt2D(VariableDS varDS, int length2) {
        String varName = varDS.getShortName();
        Logger logger = NcArrayLonLatUgridUtils.getClassLogger();
        Array array = null;
        try {
            array = varDS.read();
        }
        catch (Exception exc) {
            logger.trace("Exception reading Array from var {}, {}", (Object)varName, (Object)exc.getMessage());
            throw new NcException("Failed to read variable " + varName + " Array.");
        }
        logger.trace("{} Array is type {}", (Object)varName, (Object)array.getElementType());
        logger.trace("{} Array is class {}", (Object)varName, (Object)array.getClass());
        if (!(array instanceof ArrayInt.D2)) {
            logger.trace("{} Array is not ArrayInt.D2");
            throw new NcMismatchException(varName + " Array is not ArrayInt.D2");
        }
        int[] ashape = array.getShape();
        if (ashape.length != 2) {
            logger.trace("{} Array has rank {} != 2", (Object)varName, (Object)ashape.length);
            throw new NcMismatchException("Array not D2.");
        }
        if (length2 > 0 && ashape[1] != length2) {
            logger.trace("ashape[1] is {} != {}", (Object)ashape[1], (Object)length2);
            throw new NcMismatchException("ArrayInt.D2 does not have second dimension length " + length2);
        }
        try {
            return (ArrayInt.D2)array;
        }
        catch (Exception exc) {
            throw new NcMismatchException("Could not cast Array to Int.D2");
        }
    }

    private static Logger getClassLogger() {
        return LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    private NcArrayLonLatUgridUtils() {
    }
}

