/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.img.PsDocument;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.lang.invoke.MethodHandles;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsGraphics2D
extends Graphics2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final NumberFormat DFORMAT = NumberFormat.getNumberInstance();
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    public static int AFM_DIVISOR = 1000;
    private PsDocument document_;
    private boolean textAsCurves_;
    private float width_;
    private float height_;
    private BasicStroke strokeOne_ = new BasicStroke(1.0f);
    private Stroke stroke_;
    private Stroke originalStroke_;
    private Stroke oldStroke_;
    private Font font_;
    private AffineTransform transform_;
    private Paint paint_;
    private Paint paintFill_;
    private Paint paintStroke_;
    private Color background_;
    private Area clip_;
    private final RenderingHints rhints_ = new RenderingHints(null);
    private boolean disposeCalled_;
    private ArrayList<PsGraphics2D> children_;
    private boolean child_;
    private final Graphics dummyGfx_ = new BufferedImage(2, 2, 1).getGraphics();
    private MediaTracker mediaTracker_;
    private boolean underline_;
    private int fillGState_ = 255;
    private int strokeGState_ = 255;

    private PsGraphics2D() {
    }

    public PsGraphics2D(PsDocument document, float width, float height, boolean textAsCurves) {
        this.document_ = document;
        this.width_ = width;
        this.height_ = height;
        this.textAsCurves_ = textAsCurves;
        this.transform_ = new AffineTransform();
        this.children_ = new ArrayList();
        this.paint_ = Color.BLACK;
        this.background_ = Color.WHITE;
        this.setFont(new Font("sanserif", 0, 12));
        this.clip_ = new Area(new Rectangle2D.Float(0.0f, 0.0f, this.width_, this.height_));
        this.clip(this.clip_);
        this.originalStroke_ = this.strokeOne_;
        this.stroke_ = this.strokeOne_;
        this.oldStroke_ = this.strokeOne_;
        this.setStrokeDiff(this.stroke_, null);
    }

    @Override
    public void draw(Shape s) {
        this.psDrawPath(s, 2);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.drawImage(op.filter(img, null), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform oldAT = this.getTransform();
        this.transform(xform);
        boolean result = this.drawImage(img, 0, 0, obs);
        this.setTransform(oldAT);
        return result;
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage image = null;
        if (img instanceof BufferedImage) {
            image = (BufferedImage)img;
        } else {
            ColorModel cm = img.getColorModel();
            int w = img.getWidth();
            int h = img.getHeight();
            WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = img.getPropertyNames();
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    properties.put(keys[i], img.getProperty(keys[i]));
                }
            }
            BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
            img.copyData(raster);
            image = result;
        }
        this.drawImage(image, xform, null);
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.drawString(s, (float)x, (float)y);
    }

    public static double asPoints(double d, int i) {
        return d * (double)i / (double)AFM_DIVISOR;
    }

    protected void doAttributes(AttributedCharacterIterator iter) {
        this.underline_ = false;
        Map<AttributedCharacterIterator.Attribute, Object> map = iter.getAttributes();
        Set<AttributedCharacterIterator.Attribute> set = map.keySet();
        for (AttributedCharacterIterator.Attribute textattribute : set) {
            Font font1;
            Object obj;
            LOGGER.trace("{}", (Object)textattribute);
            if (textattribute.equals(TextAttribute.FONT)) {
                obj = iter.getAttributes().get(textattribute);
                if (obj instanceof Font) {
                    font1 = (Font)obj;
                    LOGGER.trace("Font {}", (Object)font1.getName());
                    this.setFont(font1);
                    continue;
                }
                if (obj == null) {
                    LOGGER.warn("Font attribute is null!");
                    continue;
                }
                if (obj instanceof String) {
                    LOGGER.warn("Font attribute is a String with value '{}'", (Object)obj.toString());
                    continue;
                }
                LOGGER.warn("Font attribute is not a Font.");
                continue;
            }
            if (textattribute.equals(TextAttribute.FAMILY)) {
                obj = iter.getAttributes().get(textattribute);
                if (obj instanceof Font) {
                    font1 = (Font)obj;
                    LOGGER.trace("Font {}", (Object)font1.getName());
                    this.setFont(font1);
                    continue;
                }
                if (obj == null) {
                    LOGGER.warn("Family attribute is null!");
                    continue;
                }
                if (obj instanceof String) {
                    String famName = (String)obj;
                    Font oldFont = this.getFont();
                    if (oldFont != null) {
                        try {
                            int oldStyle = oldFont.getStyle();
                            int oldSize = oldFont.getSize();
                            Font font12 = new Font(famName, oldStyle, oldSize);
                            this.setFont(font12);
                        }
                        catch (Exception exc) {
                            LOGGER.warn("Tried but failed to set Font from Family attribute {}", (Object)famName);
                        }
                        continue;
                    }
                    LOGGER.warn("Family attribute is a String with value '{}' but old Font is null", (Object)famName);
                    continue;
                }
                LOGGER.warn("Family attribute is not a Font: {}", (Object)obj.getClass().getSimpleName());
                continue;
            }
            if (textattribute.equals(TextAttribute.SUPERSCRIPT)) {
                LOGGER.trace("Unable to handle SUPERSCRIPT attribute.");
                continue;
            }
            if (textattribute.equals(TextAttribute.SIZE)) {
                obj = iter.getAttributes().get(textattribute);
                font1 = null;
                if (obj instanceof Integer) {
                    int i = (Integer)obj;
                    font1 = this.getFont().deriveFont(this.getFont().getStyle(), i);
                } else if (obj instanceof Float) {
                    float f = ((Float)obj).floatValue();
                    font1 = this.getFont().deriveFont(this.getFont().getStyle(), f);
                } else {
                    LOGGER.warn("Size attribute is not an Integer or Float.");
                    return;
                }
                this.setFont(font1);
                continue;
            }
            throw new RuntimeException("Attribute " + textattribute + " not supported");
        }
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (s == null || s.length() == 0) {
            return;
        }
        this.setFillPaint();
        if (this.textAsCurves_) {
            TextLayout tl = new TextLayout(s, this.getFont(), new FontRenderContext(new AffineTransform(), false, true));
            tl.draw(this, x, y);
        } else {
            Point2D.Float p1 = new Point2D.Float(x, y);
            Point2D.Float p2 = new Point2D.Float(0.0f, 0.0f);
            this.transform_.transform(p1, p2);
            StringBuilder sb = new StringBuilder(s);
            for (int i = sb.length() - 1; i >= 0; --i) {
                if (sb.charAt(i) != '\\' && sb.charAt(i) != '(' && sb.charAt(i) != ')' && sb.charAt(i) != '<' && sb.charAt(i) != '>' && sb.charAt(i) != '[' && sb.charAt(i) != ']' && sb.charAt(i) != '{' && sb.charAt(i) != '}' && sb.charAt(i) != '%') continue;
                sb.insert(i, '\\');
            }
            float scale = (float)Math.sqrt(Math.abs(this.transform_.getDeterminant()));
            this.psPrintln("/" + this.font_.getPSName() + " findfont");
            this.psPrintln(p2.x + " " + this.normalizeY(p2.y) + " moveto");
            this.psPrintln((float)this.font_.getSize() * scale + " scalefont setfont");
            this.psPrintln("(" + sb.toString() + ") show");
            if (this.underline_) {
                // empty if block
            }
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iter, float x, float y) {
        FontRenderContext frc = this.getFontRenderContext();
        TextLayout textLayout = new TextLayout(iter, frc);
        textLayout.draw(this, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape s = g.getOutline(x, y);
        this.fill(s);
    }

    @Override
    public void fill(Shape s) {
        this.psDrawPath(s, 1);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.stroke_.createStrokedShape(s);
        }
        s = this.transform_.createTransformedShape(s);
        Area area = new Area(s);
        if (this.clip_ != null) {
            area.intersect(this.clip_);
        }
        return area.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return ((Graphics2D)this.dummyGfx_).getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint_ = paint;
        if (paint instanceof Color) {
            this.psSetColor((Color)paint);
        }
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        float scale = (float)Math.sqrt(Math.abs(this.transform_.getDeterminant()));
        BasicStroke st = (BasicStroke)stroke;
        float[] dash = st.getDashArray();
        if (dash != null) {
            int k = 0;
            while (k < dash.length) {
                int n = k++;
                dash[n] = dash[n] * scale;
            }
        }
        return new BasicStroke(st.getLineWidth() * scale, st.getEndCap(), st.getLineJoin(), st.getMiterLimit(), dash, st.getDashPhase() * scale);
    }

    private void setStrokeDiff(Stroke newStroke, Stroke oldStroke) {
        if (newStroke == oldStroke) {
            return;
        }
        if (!(newStroke instanceof BasicStroke)) {
            return;
        }
        BasicStroke nStroke = (BasicStroke)newStroke;
        boolean oldOk = oldStroke instanceof BasicStroke;
        BasicStroke oStroke = null;
        if (oldOk) {
            oStroke = (BasicStroke)oldStroke;
        }
        if (!oldOk || nStroke.getLineWidth() != oStroke.getLineWidth()) {
            this.psPrintln(nStroke.getLineWidth() + " setlinewidth");
        }
        if (!oldOk || nStroke.getEndCap() != oStroke.getEndCap()) {
            switch (nStroke.getEndCap()) {
                case 0: {
                    this.psPrintln("0 setlinecap");
                    break;
                }
                case 2: {
                    this.psPrintln("2 setlinecap");
                    break;
                }
                default: {
                    this.psPrintln("1 setlinecap");
                }
            }
        }
        if (!oldOk || nStroke.getLineJoin() != oStroke.getLineJoin()) {
            switch (nStroke.getLineJoin()) {
                case 0: {
                    this.psPrintln("0 setlinejoin");
                    break;
                }
                case 2: {
                    this.psPrintln("2 setlinejoin");
                    break;
                }
                default: {
                    this.psPrintln("1 setlinejoin");
                }
            }
        }
        if (!oldOk || nStroke.getMiterLimit() != oStroke.getMiterLimit()) {
            this.psPrintln(nStroke.getMiterLimit() + " setmiterlimit");
        }
        boolean makeDash = oldOk ? (nStroke.getDashArray() != null ? (nStroke.getDashPhase() != oStroke.getDashPhase() ? true : !Arrays.equals(nStroke.getDashArray(), oStroke.getDashArray())) : oStroke.getDashArray() != null) : true;
        if (makeDash) {
            float[] pattern = nStroke.getDashArray();
            if (pattern == null) {
                this.psPrintln("[] 0 setdash");
            } else {
                StringBuffer dashes = new StringBuffer();
                for (float ff : pattern) {
                    dashes.append(ff).append(' ');
                }
                this.psPrintln("[" + dashes.toString() + "]" + nStroke.getDashPhase() + " setdash");
            }
        }
    }

    @Override
    public void setStroke(Stroke s) {
        this.originalStroke_ = s;
        this.stroke_ = this.transformStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        try {
            this.rhints_.put(arg0, arg1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key arg0) {
        return this.rhints_.get(arg0);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.rhints_.clear();
        this.rhints_.putAll(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.rhints_.putAll(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.rhints_;
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform_.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.transform_.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform_.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform_.scale(sx, sy);
        this.stroke_ = this.transformStroke(this.originalStroke_);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform_.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform tx) {
        this.transform_.concatenate(tx);
        this.stroke_ = this.transformStroke(this.originalStroke_);
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.transform_ = new AffineTransform(t);
        this.stroke_ = this.transformStroke(this.originalStroke_);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform_);
    }

    @Override
    public Paint getPaint() {
        return this.paint_;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
        this.background_ = color;
    }

    @Override
    public Color getBackground() {
        return this.background_;
    }

    @Override
    public Stroke getStroke() {
        return this.originalStroke_;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graphics create() {
        PsGraphics2D g2 = new PsGraphics2D();
        g2.document_ = this.document_;
        g2.textAsCurves_ = this.textAsCurves_;
        g2.transform_ = new AffineTransform(this.transform_);
        g2.children_ = this.children_;
        g2.paint_ = this.paint_;
        g2.background_ = this.background_;
        g2.mediaTracker_ = this.mediaTracker_;
        g2.setFont(this.font_);
        g2.width_ = this.width_;
        g2.height_ = this.height_;
        g2.psDrawPath(new Area(new Rectangle2D.Float(0.0f, 0.0f, this.width_, this.height_)), 3);
        if (this.clip_ != null) {
            g2.clip_ = new Area(this.clip_);
        }
        g2.stroke_ = this.stroke_;
        g2.originalStroke_ = this.originalStroke_;
        g2.strokeOne_ = (BasicStroke)g2.transformStroke(g2.strokeOne_);
        g2.oldStroke_ = g2.strokeOne_;
        g2.setStrokeDiff(g2.oldStroke_, null);
        if (this.clip_ != null) {
            g2.psDrawPath(g2.clip_, 3);
        }
        g2.child_ = true;
        ArrayList<PsGraphics2D> arrayList = this.children_;
        synchronized (arrayList) {
            this.children_.add(g2);
        }
        return g2;
    }

    @Override
    public Color getColor() {
        if (this.paint_ instanceof Color) {
            return (Color)this.paint_;
        }
        return Color.BLACK;
    }

    @Override
    public void setColor(Color color) {
        this.setPaint(color);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public Font getFont() {
        return this.font_;
    }

    @Override
    public void setFont(Font f) {
        this.font_ = f == null ? Font.decode(null) : f;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.dummyGfx_.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip_ == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Shape getClip() {
        try {
            return this.transform_.createInverse().createTransformedShape(this.clip_);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        this.setClip(rect);
    }

    @Override
    public void setClip(Shape s) {
        if (s != null) {
            s = this.transform_.createTransformedShape(s);
        }
        if (s == null) {
            this.clip_ = null;
        } else {
            this.clip_ = new Area(s);
            this.psDrawPath(s, 3);
        }
        this.paintFill_ = null;
        this.paintStroke_ = null;
        this.fillGState_ = 255;
        this.strokeGState_ = 255;
        this.oldStroke_ = this.strokeOne_;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        this.clip(rect);
    }

    @Override
    public final void clip(Shape s) {
        if (s != null) {
            s = this.transform_.createTransformedShape(s);
        }
        if (this.clip_ == null) {
            this.clip_ = new Area(s);
        } else {
            this.clip_.intersect(new Area(s));
        }
        this.psDrawPath(s, 3);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.draw(line);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint temp = this.paint_;
        this.setPaint(this.background_);
        this.fillRect(x, y, width, height);
        this.setPaint(temp);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void drawPolyline(int[] x, int[] y, int nPoints) {
        Line2D.Double line = new Line2D.Double(x[0], y[0], x[0], y[0]);
        for (int i = 1; i < nPoints; ++i) {
            ((Line2D)line).setLine(((Line2D)line).getX2(), ((Line2D)line).getY2(), x[i], y[i]);
            this.draw(line);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon poly = new Polygon();
        for (int i = 0; i < nPoints; ++i) {
            poly.addPoint(xPoints[i], yPoints[i]);
        }
        this.draw(poly);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon poly = new Polygon();
        for (int i = 0; i < nPoints; ++i) {
            poly.addPoint(xPoints[i], yPoints[i]);
        }
        this.fill(poly);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver obs) {
        return this.drawImage(img, x, y, null, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver obs) {
        return this.drawImage(img, x, y, w, h, null, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver obs) {
        this.waitForImage(img);
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), bgcolor, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver obs) {
        this.waitForImage(img);
        return this.drawImage(img, x, y, x + w, y + h, 0, 0, w, h, bgcolor, obs);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver obs) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, obs);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver obs) {
        if (dx1 >= dx2) {
            throw new IllegalArgumentException("dx1 >= dx2");
        }
        if (sx1 >= sx2) {
            throw new IllegalArgumentException("sx1 >= sx2");
        }
        if (dy1 >= dy2) {
            throw new IllegalArgumentException("dy1 >= dy2");
        }
        if (sy1 >= sy2) {
            throw new IllegalArgumentException("sy1 >= sy2");
        }
        this.waitForImage(img);
        double dw = dx2 - dx1;
        double dh = dy2 - dy1;
        double sw = sx2 - sx1;
        double sh = sy2 - sy1;
        if (dw == 0.0 || dh == 0.0 || sw == 0.0 || sh == 0.0) {
            return true;
        }
        this.psPrintln("gsave");
        this.psPrint(sw);
        this.psPrint(" ");
        this.psPrint(sh);
        this.psPrintln(" 8");
        AffineTransform xform = new AffineTransform(this.transform_);
        xform.translate(dx1, dy1);
        xform.scale(dw / sw, dh / sh);
        double matrixTransX = -xform.getTranslateX();
        double matrixTransY = this.normalizeY(xform.getTranslateY());
        double matrixScaleX = 1.0 / xform.getScaleX();
        double matrixScaleY = 1.0 / xform.getScaleY();
        this.psPrint("[");
        this.psPrint(matrixScaleX);
        this.psPrint(" ");
        this.psPrint(0.0);
        this.psPrint(" ");
        this.psPrint(0.0);
        this.psPrint(" ");
        this.psPrint(-matrixScaleY);
        this.psPrint(" ");
        this.psPrint(matrixTransX * matrixScaleX);
        this.psPrint(" ");
        this.psPrint(matrixTransY * matrixScaleY);
        this.psPrintln("]");
        this.psPrint("{currentfile 3 ");
        this.psPrint(sw);
        this.psPrintln(" mul string readhexstring pop} bind false 3 colorimage");
        try {
            int w = img.getWidth(obs);
            int h = img.getHeight(obs);
            int[] srcPixels = new int[w * h];
            PixelGrabber grabber = new PixelGrabber(img, 0, 0, w, h, srcPixels, 0, w);
            try {
                grabber.grabPixels();
            }
            catch (Exception exc) {
                LOGGER.warn("Exception grabbing pixels: { } " + exc.toString());
                return false;
            }
            int offset = 0;
            int rowOffset = 0;
            for (int j = sy1; j < sy2; ++j) {
                rowOffset = j * w;
                for (int i = sx1; i < sx2; ++i) {
                    offset = rowOffset + i;
                    int rgb = srcPixels[offset];
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    this.psPrint(this.toHexString(red));
                    this.psPrint(this.toHexString(green));
                    this.psPrint(this.toHexString(blue));
                    if ((offset + 1) % 12 != 0) continue;
                    this.psPrintln("");
                }
            }
            this.psPrintln("");
        }
        catch (Exception exc) {
            LOGGER.error("{}", (Object)exc.toString());
            return false;
        }
        this.psPrintln("grestore");
        return true;
    }

    @Override
    public void dispose() {
        if (this.child_) {
            return;
        }
        if (!this.disposeCalled_) {
            this.disposeCalled_ = true;
            for (int k = 0; k < this.children_.size(); ++k) {
                PsGraphics2D g2 = this.children_.get(k);
                g2.dispose();
            }
        }
    }

    private void psDrawPath(Shape s, int drawType) {
        if (s == null) {
            return;
        }
        if (drawType == 3) {
            return;
        }
        if (drawType == 2 && !(this.stroke_ instanceof BasicStroke)) {
            s = this.stroke_.createStrokedShape(s);
            this.psDrawPath(s, 1);
            return;
        }
        if (drawType == 2) {
            this.setStrokeDiff(this.stroke_, this.oldStroke_);
            this.oldStroke_ = this.stroke_;
            this.setStrokePaint();
        } else if (drawType == 1) {
            // empty if block
        }
        PathIterator points = s.getPathIterator(this.transform_);
        float[] coords = new float[6];
        int traces = 0;
        Point2D.Float lastPt = new Point2D.Float(0.0f, 0.0f);
        while (!points.isDone()) {
            ++traces;
            int segtype = points.currentSegment(coords);
            this.normalizeY(coords);
            switch (segtype) {
                case 4: {
                    this.psPrintln("closepath");
                    break;
                }
                case 3: {
                    this.psPrint(coords[0]);
                    this.psPrint(" ");
                    this.psPrint(coords[1]);
                    this.psPrint(" ");
                    this.psPrint(coords[2]);
                    this.psPrint(" ");
                    this.psPrint(coords[3]);
                    this.psPrint(" ");
                    this.psPrint(coords[4]);
                    this.psPrint(" ");
                    this.psPrint(coords[5]);
                    this.psPrintln(" curveto");
                    lastPt.x = coords[4];
                    lastPt.y = coords[5];
                    break;
                }
                case 1: {
                    this.psPrint(coords[0]);
                    this.psPrint(" ");
                    this.psPrint(coords[1]);
                    this.psPrintln(" lineto");
                    lastPt.x = coords[0];
                    lastPt.y = coords[1];
                    break;
                }
                case 0: {
                    this.psPrint(coords[0]);
                    this.psPrint(" ");
                    this.psPrint(coords[1]);
                    this.psPrintln(" moveto");
                    lastPt.x = coords[0];
                    lastPt.y = coords[1];
                    break;
                }
                case 2: {
                    float cubicC1x = lastPt.x + 0.6666667f * (coords[0] - lastPt.x);
                    float cubicC1y = lastPt.y + 0.6666667f * (coords[1] - lastPt.y);
                    float cubicC2x = cubicC1x + 0.33333334f * (coords[2] - lastPt.x);
                    float cubicC2y = cubicC1y + 0.33333334f * (coords[3] - lastPt.y);
                    this.psPrint(cubicC1x);
                    this.psPrint(" ");
                    this.psPrint(cubicC1y);
                    this.psPrint(" ");
                    this.psPrint(cubicC2x);
                    this.psPrint(" ");
                    this.psPrint(cubicC2y);
                    this.psPrint(" ");
                    this.psPrint(coords[2]);
                    this.psPrint(" ");
                    this.psPrint(coords[3]);
                    this.psPrintln("  curveto");
                    lastPt.x = coords[2];
                    lastPt.y = coords[3];
                }
            }
            points.next();
        }
        switch (drawType) {
            case 1: {
                if (traces <= 0) break;
                if (points.getWindingRule() == 0) {
                    this.psPrintln("eofill");
                    break;
                }
                this.psPrintln("fill");
                break;
            }
            case 2: {
                if (traces <= 0) break;
                this.psPrintln("stroke");
                break;
            }
            default: {
                if (points.getWindingRule() == 0) {
                    this.psPrintln("eoclip");
                } else {
                    this.psPrintln("clip");
                }
                this.psPrintln("newpath");
            }
        }
    }

    private float normalizeY(float y) {
        return this.height_ - y;
    }

    private float normalizeY(double y) {
        return (float)((double)this.height_ - y);
    }

    private void normalizeY(float[] coords) {
        coords[1] = this.normalizeY(coords[1]);
        coords[3] = this.normalizeY(coords[3]);
        coords[5] = this.normalizeY(coords[5]);
    }

    private boolean checkNewPaint(Paint oldPaint) {
        if (this.paint_ == oldPaint) {
            return false;
        }
        return !(this.paint_ instanceof Color) || !this.paint_.equals(oldPaint);
    }

    private void setFillPaint() {
        if (this.checkNewPaint(this.paintFill_)) {
            this.paintFill_ = this.paint_;
            this.setPaint(false, 0.0, 0.0, true);
        }
    }

    private void setStrokePaint() {
        if (this.checkNewPaint(this.paintStroke_)) {
            this.paintStroke_ = this.paint_;
            this.setPaint(false, 0.0, 0.0, false);
        }
    }

    private void setPaint(boolean invert, double xoffset, double yoffset, boolean fill) {
        if (this.paint_ instanceof Color) {
            Color color = (Color)this.paint_;
            int alpha = color.getAlpha();
            if (fill) {
                if (alpha != this.fillGState_) {
                    // empty if block
                }
                this.psSetColor(color);
            } else {
                if (alpha != this.strokeGState_) {
                    // empty if block
                }
                this.psSetColor(color);
            }
        } else if (this.paint_ instanceof GradientPaint || this.paint_ instanceof TexturePaint) {
            // empty if block
        }
    }

    private synchronized void waitForImage(Image image) {
        if (this.mediaTracker_ == null) {
            this.mediaTracker_ = new MediaTracker(new FakeComponent());
        }
        this.mediaTracker_.addImage(image, 0);
        try {
            this.mediaTracker_.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mediaTracker_.removeImage(image);
    }

    private String toHexString(int i) {
        StringBuilder sb = new StringBuilder().append(Integer.toString(i, 16));
        while (sb.length() < 2) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    private void psSetColor(Color c) {
        this.psPrint((double)c.getRed() / 255.0);
        this.psPrint(" ");
        this.psPrint((double)c.getGreen() / 255.0);
        this.psPrint(" ");
        this.psPrint((double)c.getBlue() / 255.0);
        this.psPrintln(" setrgbcolor");
    }

    private void psPrint(float f) {
        this.psPrint((double)f);
    }

    private void psPrint(double d) {
        this.document_.psPrint(DFORMAT.format(d));
    }

    private void psPrint(int i) {
        this.document_.psPrint(Integer.toString(i));
    }

    private void psPrint(String s) {
        if (this.document_ != null) {
            this.document_.psPrint(s);
        }
    }

    private void psPrintln(String s) {
        if (this.document_ != null) {
            this.document_.psPrintln(s);
        }
    }

    static {
        DFORMAT.setMinimumFractionDigits(0);
        DFORMAT.setMaximumFractionDigits(5);
        DFORMAT.setGroupingUsed(false);
    }

    private static class FakeComponent
    extends Component {
        private FakeComponent() {
        }
    }
}

