/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cabot
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Cabot";
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 2.356194490192345;
    private ProjListParameter variantParam_;
    private Variant variant_ = Variant.ONE_27;
    private double cx_;
    private double twoOver3RS_;
    private double threeOverCxRS_;

    public Cabot(int width, int height) {
        this(width, height, 0, 0);
    }

    public Cabot(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 2.356194490192345);
        this.variantParam_ = new ProjListParameter("Aspect Ratio", "Aspect Ratio", Variant.class, 0);
        this.addParameter(this.variantParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.variantParam_)) {
            int varIndex = this.variantParam_.getIndex();
            this.variant_ = Variant.values()[varIndex];
            LOGGER.trace("variant {}", (Object)this.variant_);
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.cx_ = this.variant_.getRatio() * 0.75;
        this.setMaxXYOverRS(this.cx_ * Math.PI, 2.356194490192345);
    }

    @Override
    protected final void finishScaling() {
        this.twoOver3RS_ = 2.0 * this.invRS_ / 3.0;
        this.threeOverCxRS_ = 3.0 * this.invRS_ / this.cx_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double lambdaRadOver3 = lambdaRad / 3.0;
        double twoPhiOverPi = phiRad / 1.5707963267948966;
        double y = 1.5 * phiRad;
        double x = this.cx_ * lambdaRadOver3 * (1.0 + 2.0 * Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.twoOver3RS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double lambdaRad = this.threeOverCxRS_ * x / (1.0 + 2.0 * Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Cabot cabot = this;
        synchronized (cabot) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.twoOver3RS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double twoPhiOverPi = phiRad * 0.6366197723675814;
                double xFactor = this.threeOverCxRS_ / (1.0 + 2.0 * Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        double lambda = this.lonToLambda(lon);
        double absLambda = Math.abs(lambda);
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        Point2D.Double dotNP = maxLat > 89.99999 ? dotN : this.transformLL2XY(lon, 90.0);
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotSP = maxLat > 89.99999 ? dotS : this.transformLL2XY(lon, -90.0);
        double hw = Math.abs(dotEq.x - dotNP.x);
        double rectX = dotNP.x - hw;
        double rectW = 2.0 * hw;
        double rectH = dotSP.y - dotNP.y;
        if (lambda > 0.0) {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotS, dotN);
        } else {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotN, dotS);
        }
    }

    private static enum Variant implements ProjListEnum
    {
        ONE_27("1.27", 1.27),
        ONE_33("1.33", 1.33333),
        ONE_80("1.80", 1.8);

        private String text_;
        private double ratio_;

        private Variant(String text, double ratio) {
            this.text_ = text;
            this.ratio_ = ratio;
        }

        double getRatio() {
            return this.ratio_;
        }

        public String toString() {
            return this.text_;
        }

        @Override
        public boolean matches(String str) {
            return this.nameMatches(str) || this.textMatches(str);
        }

        public boolean nameMatches(String str) {
            return this.name().equalsIgnoreCase(str);
        }

        public boolean textMatches(String str) {
            return this.text_.equalsIgnoreCase(str);
        }
    }
}

