/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Healpix
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "HEALPix";
    public static final int PROPERTIES = 16785418;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.0;
    private static final double SIN_JOIN = 0.6666666666666666;
    private static final double JOIN_LAT_RAD = Math.asin(0.6666666666666666);
    private static final double JOIN_LAT = Math.toDegrees(JOIN_LAT_RAD);
    private int h_ = 4;
    private boolean rescaled_;
    private double yScaling_ = 1.0;
    private double fwidth_ = 90.0;
    private double fhwidth_ = 45.0;
    private double fhwidthRad_ = 1.0;
    private double piOverH_ = 1.0;
    private double twoPiOverH_ = 1.0;
    private double hOverPi_ = 1.0;
    private double hOver2Pi_ = 1.0;
    private double threePiOver2H_ = 1.0;
    private final ProjIntegerParameter hParam_ = new ProjIntegerParameter("H parameter", "H", "", 4, 1, 36);
    private final ProjBooleanParameter rescaleParam_ = new ProjBooleanParameter("Scale for better fit", "Rescale", false);

    public Healpix(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16785418, width, height, xmargin, ymargin, Math.PI, 1.0);
        this.addParameter(this.hParam_);
        this.addParameter(this.rescaleParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p = e == null ? null : (ProjExtraParameter)e.getSource();
        LOGGER.trace("param {}", (Object)p);
        if (p == null) {
            this.setH(this.hParam_.getValue());
            this.setRescale(this.rescaleParam_.isSelected());
        } else if (p.equals(this.hParam_)) {
            this.setH(this.hParam_.getValue());
        } else if (p.equals(this.rescaleParam_)) {
            this.setRescale(this.rescaleParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setH(int h) {
        this.h_ = h;
        double invH = 1.0 / (double)h;
        this.fwidth_ = 360.0 * invH;
        this.fhwidth_ = 0.5 * this.fwidth_;
        this.fhwidthRad_ = Math.toRadians(this.fhwidth_);
        this.piOverH_ = Math.PI * invH;
        this.twoPiOverH_ = 2.0 * this.piOverH_;
        this.hOverPi_ = (double)h * 0.3183098861837907;
        this.hOver2Pi_ = 0.5 * this.hOverPi_;
        this.threePiOver2H_ = 4.71238898038469 * invH;
        this.autoscale();
    }

    private void setRescale(boolean rescale) {
        this.rescaled_ = rescale;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        if (this.rescaled_) {
            this.yScaling_ = 0.25 * (double)this.h_;
            this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
        } else {
            this.yScaling_ = 1.0;
            this.setMaxXYOverRS(Math.PI, this.twoPiOverH_);
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double absLat = Math.abs(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        if (absLat <= JOIN_LAT) {
            x = this.lonToLambdaRad(lon);
            y = this.threePiOver2H_ * sinPhi;
        } else {
            double sigmaRad = Math.sqrt(3.0 * (1.0 - Math.abs(sinPhi)));
            y = Math.signum(lat) * this.piOverH_ * (2.0 - sigmaRad);
            double lambdaGRad = this.getGoreCenterLambdaRad(lambdaRad);
            x = lambdaGRad + (lambdaRad - lambdaGRad) * sigmaRad;
        }
        if (this.rescaled_) {
            y *= this.yScaling_;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double yyy = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absyyy = Math.abs(yyy);
        if (absx > (double)this.dxMax_ || absyyy > (double)this.dyMax_) {
            return null;
        }
        double y = this.rescaled_ ? yyy / this.yScaling_ : yyy;
        double absy = Math.abs(y);
        double xOverRS = x * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double sinPhi = absYOverRS / this.threePiOver2H_;
        if (sinPhi <= 0.6666666666666666) {
            phiRad = Math.asin(sinPhi);
            lambdaRad = xOverRS;
        } else {
            double sigmaRad = 2.0 - this.hOverPi_ * absYOverRS;
            sinPhi = 1.0 - sigmaRad * sigmaRad / 3.0;
            phiRad = Math.asin(sinPhi);
            double goreCRad = this.getGoreCenterLambdaRad(xOverRS);
            lambdaRad = goreCRad + (xOverRS - goreCRad) / sigmaRad;
            if (Math.abs(lambdaRad - goreCRad) > this.fhwidthRad_) {
                return null;
            }
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        try {
            return new PointLL(this.lambdaC_ + lambda, phi);
        }
        catch (Exception exc) {
            LOGGER.warn("exc for {}, {}", (Object)lambda, (Object)phi);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Healpix healpix = this;
        synchronized (healpix) {
            double sigmaRad = 1.0;
            double invSigmaRad = 1.0;
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double yOverRS;
                double sinPhi;
                double phiRad;
                double y = (double)iy + 0.5;
                if (this.rescaled_) {
                    y /= this.yScaling_;
                }
                double d = phiRad = (sinPhi = (yOverRS = y * this.invRS_) / this.threePiOver2H_) <= 0.6666666666666666 ? Math.asin(sinPhi) : 1.5707963267948966;
                if (phiRad > JOIN_LAT_RAD) {
                    sigmaRad = 2.0 - this.hOverPi_ * yOverRS;
                    invSigmaRad = 1.0 / sigmaRad;
                    sinPhi = 1.0 - sigmaRad * sigmaRad / 3.0;
                    phiRad = Math.asin(sinPhi);
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    double goreCRad;
                    if (phiRad > JOIN_LAT_RAD && Math.abs((lambdaRad = (goreCRad = this.getGoreCenterLambdaRad(lambdaRad)) + (lambdaRad - goreCRad) * invSigmaRad) - goreCRad) > this.fhwidthRad_) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double dlon;
        int i;
        Path2D.Double path = new Path2D.Double();
        Point2D.Double p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 179.99999, JOIN_LAT);
        path.moveTo(p2d.x, p2d.y);
        for (i = 0; i < this.h_; ++i) {
            dlon = -180.0 + (double)i * this.fwidth_ + this.fhwidth_;
            p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_ + dlon, 90.0);
            path.lineTo(p2d.x, p2d.y);
            dlon = -180.0 + (double)(i + 1) * this.fwidth_ - 1.0E-5;
            p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_ + dlon, JOIN_LAT);
            path.lineTo(p2d.x, p2d.y);
        }
        p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 179.99999, -JOIN_LAT);
        path.lineTo(p2d.x, p2d.y);
        for (i = 0; i < this.h_; ++i) {
            dlon = 180.0 - (double)i * this.fwidth_ - this.fhwidth_;
            p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_ + dlon, -90.0);
            path.lineTo(p2d.x, p2d.y);
            dlon = 180.0 - (double)(i + 1) * this.fwidth_ + 1.0E-5;
            p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_ + dlon, -JOIN_LAT);
            path.lineTo(p2d.x, p2d.y);
        }
        path.closePath();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        g2x.draw(path);
        g2x.dispose();
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) <= JOIN_LAT) {
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 179.99999, lat);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ + 179.99999, lat);
            GraphicUtils.drawLine(g2d, dot1, dot2);
            return;
        }
        for (int i = 0; i < this.h_; ++i) {
            double llon = this.lambdaC_ - 180.0 + (double)i * this.fwidth_ + 1.0E-5;
            double rlon = this.lambdaC_ + 180.0 + (double)(i + 1) * this.fwidth_ - 1.0E-5;
            Point2D.Double dot1 = this.transformLL2XY(llon, lat);
            Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
            GraphicUtils.drawLine(g2d, dot1, dot2);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot = this.transformLL2XY(lon, 0.0);
        if (dot == null) {
            return;
        }
        Path2D.Double path = new Path2D.Double();
        Point2D.Double p2d = this.transformLL2XYIgnoreMargins(lon, maxLat);
        path.moveTo(p2d.x, p2d.y);
        p2d = this.transformLL2XYIgnoreMargins(lon, JOIN_LAT);
        path.lineTo(p2d.x, p2d.y);
        p2d = this.transformLL2XYIgnoreMargins(lon, -JOIN_LAT);
        path.lineTo(p2d.x, p2d.y);
        p2d = this.transformLL2XYIgnoreMargins(lon, -maxLat);
        path.lineTo(p2d.x, p2d.y);
        g2d.draw(path);
    }

    private double getGoreCenterLambdaRad(double lambdaRad) {
        return -Math.PI + (2.0 * Math.floor((lambdaRad + Math.PI) * this.hOver2Pi_) + 1.0) * this.piOverH_;
    }
}

