/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ProjListEnum;

public enum Interruption implements ProjListEnum
{
    UNINT("Uninterrupted", -9999.0, new double[][][]{new double[][]{new double[0]}, new double[][]{new double[0]}}),
    CONTS("Interrupted: Continents (Goode)", 0.0, new double[][][]{new double[][]{{-180.0, -100.0, -40.0}, {-40.0, 30.0, 180.0}}, new double[][]{{-180.0, -160.0, -100.0}, {-100.0, -60.0, -20.0}, {-20.0, 20.0, 80.0}, {80.0, 140.0, 180.0}}}),
    MCBCONT("Interrupted: Continents (McBryde)", 0.0, new double[][][]{new double[][]{{-180.0, -100.0, -30.0}, {-30.0, 30.0, 180.0}}, new double[][]{{-180.0, -60.0, -30.0}, {-30.0, 30.0, 90.0}, {90.0, 140.0, 180.0}}}),
    BAKER("Interrupted: Continents (Baker)", 0.0, new double[][][]{new double[][]{{-180.0, -100.0, -30.0}, {-30.0, 30.0, 180.0}}, new double[][]{{-180.0, -90.0, -15.0}, {-15.0, 30.0, 75.0}, {75.0, 135.0, 180.0}}}),
    JACARANDA("Interrupted: Continents (Jacaranda)", 160.0, new double[][][]{new double[][]{{-20.0, 62.5, -170.0}, {-170.0, -90.0, -20.0}}, new double[][]{{-20.0, 20.0, 60.0}, {60.0, 140.0, -170.0}, {-170.0, -90.0, -20.0}}}),
    OCEANS("Interrupted: Oceans (Goode)", -160.0, new double[][][]{new double[][]{{20.0, 60.0, 110.0}, {110.0, -170.0, -100.0}, {-100.0, -30.0, 20.0}}, new double[][]{{20.0, 90.0, 140.0}, {140.0, -140.0, -70.0}, {-70.0, -20.0, 20.0}}}),
    MCBOCEAN("Interrupted: Oceans (McBryde)", -180.0, new double[][][]{new double[][]{{0.0, 40.0, 110.0}, {110.0, -160.0, -100.0}, {-100.0, -40.0, 0.0}}, new double[][]{{0.0, 80.0, 140.0}, {140.0, -160.0, -70.0}, {-70.0, -20.0, 0.0}}}),
    HEMIS("Interrupted: Hemispheres", -20.0, new double[][][]{new double[][]{{160.0, -110.0, -20.0}, {-20.0, 70.0, 160.0}}, new double[][]{{160.0, -110.0, -20.0}, {-20.0, 70.0, 160.0}}}),
    G120("Interrupted: 120\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(120.0), Interruption.simpleGores(120.0)}),
    G060("Interrupted: 60\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(60.0), Interruption.simpleGores(60.0)}),
    G040("Interrupted: 40\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(40.0), Interruption.simpleGores(40.0)}),
    G030("Interrupted: 30\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(30.0), Interruption.simpleGores(30.0)}),
    G020("Interrupted: 20\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(20.0), Interruption.simpleGores(20.0)}),
    G015("Interrupted: 15\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(15.0), Interruption.simpleGores(15.0)}),
    G010("Interrupted: 10\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(10.0), Interruption.simpleGores(10.0)});

    private final String description_;
    private final double[][][] gores_;
    private final double center_;

    private Interruption(String description, double center, double[][][] gores) {
        this.description_ = description;
        this.center_ = center;
        this.gores_ = gores;
    }

    static Interruption getInterruption(String str) {
        if (str == null) {
            return null;
        }
        for (Interruption item : Interruption.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String str) {
        return this.name().equalsIgnoreCase(str) || this.description_.equalsIgnoreCase(str);
    }

    double getCenterLongitude() {
        return this.center_;
    }

    double[][][] getGores() {
        return this.gores_;
    }

    private static double[][] simpleGores(double goreWidth) {
        int numGores = (int)(360.0 / goreWidth);
        double halfWidth = 0.5 * goreWidth;
        double[][] result = new double[numGores][3];
        for (int i = 0; i < numGores; ++i) {
            result[i][0] = -180.0 + goreWidth * (double)i;
            result[i][1] = -180.0 + goreWidth * (double)i + halfWidth;
            result[i][2] = -180.0 + goreWidth * (double)(i + 1);
        }
        return result;
    }
}

