/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobularProjection2H;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicolosiGlobular2H
extends GlobularProjection2H {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Nicolosi Globular (Two-Hemisphere)";
    public static final int PROPERTIES = 0x6000020;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public NicolosiGlobular2H(int width, int height) {
        this(width, height, 0, 0);
    }

    public NicolosiGlobular2H(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x6000020, width, height, xmargin, ymargin, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (absLambdaRad < 1.0E-5 || Math.abs(lat) == 90.0) {
            y = phiRad;
        } else if (lat == 0.0) {
            x = lambdaRad;
        } else if (absLambdaRad > 1.5707863267948965) {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            x = lambdaRad * cosPhi;
            y = Math.abs(lambdaRad) * sinPhi;
        } else {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double cossqPhi = cosPhi * cosPhi;
            double sinsqPhi = sinPhi * sinPhi;
            double f2 = phiRad * 0.6366197723675814;
            double f1 = (1.0 - f2 * f2) / (sinPhi - f2);
            double l1 = 1.5707963267948966 / lambdaRad - lambdaRad * 0.6366197723675814;
            double f1OverL1 = f1 / l1;
            double f1OverL1Sq = f1OverL1 * f1OverL1;
            double b = 1.0 / (1.0 + f1OverL1Sq);
            double c = 1.0 / (1.0 + 1.0 / f1OverL1Sq);
            double d = c * (l1 * sinPhi / f1 - 0.5 * l1);
            double e = b * (f1OverL1Sq * sinPhi + 0.5 * f1);
            double d2 = d * d;
            double e2 = e * e;
            double signLambda = lambdaRad / absLambdaRad;
            double signPhi = phiRad / absPhiRad;
            x = 1.5707963267948966 * (d + signLambda * Math.sqrt(d2 + c * cossqPhi));
            y = 1.5707963267948966 * (e - signPhi * Math.sqrt(e2 - b * (f1OverL1Sq * sinsqPhi + f1 * sinPhi - 1.0)));
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return null;
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double absXOverRS = Math.abs(xOverRS);
        double absYOverRS = Math.abs(yOverRS);
        if (absXOverRS > 1.5707963267948966 || absYOverRS > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = 0.0;
        double phiRad = 0.0;
        if (x == 0.0) {
            phiRad = yOverRS;
        } else if (y == 0.0) {
            lambdaRad = xOverRS;
        } else {
            double[] llRad = this.transformUnscaledXYtoLambdaPhiRad(absXOverRS, absYOverRS);
            if (llRad == null) {
                return null;
            }
            lambdaRad = llRad[0];
            phiRad = llRad[1];
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
            if (y < 0.0) {
                phiRad = -phiRad;
            }
        }
        double lambda = Math.toDegrees(lambdaRad) + (leftside ? 0.0 : 180.0);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        NicolosiGlobular2H nicolosiGlobular2H = this;
        synchronized (nicolosiGlobular2H) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double[] llRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_ && (llRad = this.transformUnscaledXYtoLambdaPhiRad(xOverRS = (x = (double)ix + 0.5) * this.invRS_, yOverRS)) != null; ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(llRad[0]), Math.toDegrees(llRad[1]));
                }
            }
        }
    }

    private final double[] transformUnscaledXYtoLambdaPhiRad(double x, double y) {
        double xSq = x * x;
        double ySq = y * y;
        double xSqPlusYSq = xSq + ySq;
        if (xSqPlusYSq > 2.4674011002723395) {
            return null;
        }
        if (x < 1.0E-10) {
            if (y > 1.5707963267948966) {
                return null;
            }
            return new double[]{x, y};
        }
        if (y < 1.0E-10) {
            return new double[]{0.0, y};
        }
        double x0 = 0.5 / x * (xSqPlusYSq - 2.4674011002723395);
        double rho0Sq = x0 * x0 + 2.4674011002723395;
        double rho0 = Math.sqrt(rho0Sq);
        double lambdaRad = x0 + rho0;
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = 0.9 * y;
        for (int i = 0; i < 33; ++i) {
            double thetaRad = phiRad;
            double dthetaDphi = 1.0;
            double cosTheta = Math.cos(thetaRad);
            double sinTheta = Math.sin(thetaRad);
            double xa = 1.5707963267948966 * cosTheta;
            double ya = 1.5707963267948966 * sinTheta;
            if (xa < x) {
                phiRad -= Math.toRadians(1.0);
                continue;
            }
            double aa = xa;
            double bb = ya - phiRad;
            double aSqPlusBSq = aa * aa + bb * bb;
            double invB = 1.0 / bb;
            double inv2B = 0.5 * invB;
            double rp = inv2B * aSqPlusBSq;
            double rpSqMinusXSq = rp * rp - xSq;
            double sqrtRp2MinusX2 = Math.sqrt(rpSqMinusXSq);
            double daDphi = -1.5707963267948966 * sinTheta * 1.0;
            double dbDphi = 1.5707963267948966 * cosTheta * 1.0 - 1.0;
            double drpDphi = inv2B * (2.0 * (aa * daDphi + bb * dbDphi) - invB * aSqPlusBSq * dbDphi);
            double func = phiRad + rp - sqrtRp2MinusX2 - y;
            double dfunc = 1.0 + (1.0 - 0.5 / sqrtRp2MinusX2 * (2.0 * rp)) * drpDphi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (Math.abs(absLambda - 90.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
        Point2D.Double dotEq = this.transformLL2XYIgnoreMargins(lon, 0.0);
        Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
        if (dotN == null || dotEq == null || dotS == null) {
            LOGGER.trace("lon {}: null on arc", (Object)lon);
        } else if (Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            GraphicUtils.drawCircularArc(g2d, dotN, dotEq, dotS);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lambdaCH = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            Point2D.Double west = this.transformLL2XYIgnoreMargins(lambdaCH - 89.99999, lat);
            Point2D.Double center = this.transformLL2XYIgnoreMargins(lambdaCH, lat);
            Point2D.Double east = this.transformLL2XYIgnoreMargins(lambdaCH + 89.99999, lat);
            GraphicUtils.drawCircularArc(g2d, west, center, east);
        }
    }
}

