/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sinucyli
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Sinucyli";
    private static final double DEFAULT_SINU_WGT = 0.5;
    private static final double DEFAULT_PHITS = 0.0;
    private static final double MAX_PHITS = 85.0;
    public static final int PROPERTIES = 8200;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private final ProjBooleanParameter reverseParam_;
    private final ProjDoubleParameter sinuParam_ = new ProjDoubleParameter("Weighting of sinusoidal projection", "Sinusoidal Wgt", "(0\u2264\u03b1\u22641)", 0.5, 0.0, 1.0, true, true);
    private final ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of CEA standard parallel", "CEA Std. Parallel", "\u00b0N", 0.0, 0.0, 85.0, true, false);
    private boolean reverse_;
    private double sinuWgt_;
    private double k_;
    private double k2_;
    private double phi1Rad_;
    private double cosPhi1_;
    private double secPhi1_;
    private double cx_;
    private double cy_;
    private double cyOverK_;
    private double kOverCy_;

    public Sinucyli(int width, int height) {
        this(width, height, 0, 0);
    }

    public Sinucyli(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8200, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.reverseParam_ = new ProjBooleanParameter("Reverse (sinusoidal->CEA) homotopy", "Reverse homotopy", false);
        this.addParameter(this.sinuParam_);
        this.addParameter(this.phi1Param_);
        this.addParameter(this.reverseParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.sinuParam_)) {
            this.setSinusoidalWeight(this.sinuParam_.getValue());
        }
        if (p == null || p.equals(this.phi1Param_)) {
            this.setStandardParallel(this.phi1Param_.getValue());
        }
        if (p == null || p.equals(this.reverseParam_)) {
            this.setReverseHomotopy(this.reverseParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setReverseHomotopy(boolean reverse) {
        this.reverse_ = reverse;
        this.autoscale();
    }

    private void setSinusoidalWeight(double sinuWgt) {
        if (sinuWgt < 0.0 || sinuWgt > 1.0) {
            throw new IllegalArgumentException("Sinusoidal weight must be in range [0,1].");
        }
        this.sinuWgt_ = sinuWgt;
        this.autoscale();
    }

    private void setStandardParallel(double lat) {
        if (Math.abs(lat) > 85.0) {
            throw new IllegalArgumentException("Lat must be in range [0,85.0].");
        }
        this.phi1Rad_ = Math.toRadians(Math.abs(lat));
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        this.k_ = this.reverse_ ? Math.sqrt(1.0 - this.sinuWgt_) : Math.sqrt(this.sinuWgt_);
        this.k2_ = this.k_ * this.k_;
        this.cosPhi1_ = Math.cos(this.phi1Rad_);
        this.secPhi1_ = 1.0 / this.cosPhi1_;
        this.cx_ = this.phi1Rad_ == 0.0 ? 1.0 : (this.reverse_ ? Math.sqrt((this.k_ + (1.0 - this.k_) * this.secPhi1_) / (this.k_ + (1.0 - this.k_) * this.cosPhi1_)) : Math.sqrt((this.k_ + (1.0 - this.k_) * this.cosPhi1_) / (this.k_ + (1.0 - this.k_) * this.secPhi1_)));
        this.cy_ = 1.0 / this.cx_;
        this.cyOverK_ = this.cy_ / this.k_;
        this.kOverCy_ = this.k_ / this.cy_;
        if (this.sinuWgt_ == 0.0) {
            this.setMaxXYOverRS(Math.PI * this.cosPhi1_, this.secPhi1_);
        } else if (this.sinuWgt_ == 1.0) {
            this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
        } else if (this.reverse_) {
            double maxX = Math.PI * this.cosPhi1_ * this.cx_;
            double maxY = Math.sin(this.k_ * 1.5707963267948966) * this.secPhi1_ * this.cyOverK_;
            this.setMaxXYOverRS(maxX, maxY);
        } else {
            double maxX = Math.PI * this.cx_;
            double maxY = Math.asin(this.k_) * this.cyOverK_;
            this.setMaxXYOverRS(maxX, maxY);
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double sinPhi = Math.sin(absPhiRad);
        double cosPhi = Math.cos(absPhiRad);
        if (this.sinuWgt_ == 0.0) {
            x = lambdaRad * this.cosPhi1_;
            y = sinPhi * this.secPhi1_;
        } else if (this.sinuWgt_ == 1.0) {
            x = lambdaRad * cosPhi;
            y = absPhiRad;
        } else if (this.reverse_) {
            x = lambdaRad * cosPhi * this.cosPhi1_ * this.cx_ / Math.cos(this.k_ * absPhiRad);
            y = Math.sin(this.k_ * absPhiRad) * this.secPhi1_ * this.cyOverK_;
        } else {
            x = lambdaRad * Math.sqrt(1.0 - this.k2_ * sinPhi * sinPhi) * this.cx_;
            y = Math.asin(this.k_ * sinPhi) * this.cyOverK_;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double cosPhi;
        double phiRad;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        if (absy > this.ymRS_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        if (this.sinuWgt_ == 0.0) {
            lambdaRad = absXOverRS * this.secPhi1_;
            phiRad = Math.asin(absYOverRS * this.cosPhi1_);
        } else if (this.sinuWgt_ == 1.0) {
            phiRad = absYOverRS;
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            cosPhi = Math.cos(phiRad);
            lambdaRad = cosPhi > 0.0 ? absXOverRS / cosPhi : 0.0;
        } else if (this.reverse_) {
            phiRad = Math.asin(absYOverRS * this.cosPhi1_ * this.kOverCy_) / this.k_;
            cosPhi = Math.cos(phiRad);
            double cosKPhi = Math.cos(this.k_ * phiRad);
            lambdaRad = absXOverRS * cosKPhi / (cosPhi * this.cosPhi1_ * this.cx_);
        } else {
            phiRad = Math.asin(Math.sin(absYOverRS * this.kOverCy_) / this.k_);
            double sinPhi = Math.sin(phiRad);
            lambdaRad = absXOverRS / (Math.sqrt(1.0 - this.k2_ * sinPhi * sinPhi) * this.cx_);
        }
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Sinucyli sinucyli = this;
        synchronized (sinucyli) {
            double y;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double lambdaRad;
                double cosPhi;
                double xFactor;
                double phiRad;
                if (this.sinuWgt_ == 0.0) {
                    phiRad = Math.asin(y * this.invRS_ * this.cosPhi1_);
                    xFactor = this.invRS_ * this.secPhi1_;
                } else if (this.sinuWgt_ == 1.0) {
                    phiRad = y * this.invRS_;
                    cosPhi = Math.cos(phiRad);
                    xFactor = cosPhi > 0.0 ? this.invRS_ / cosPhi : 0.0;
                } else if (this.reverse_) {
                    phiRad = Math.asin(y * this.invRS_ * this.cosPhi1_ * this.kOverCy_) / this.k_;
                    cosPhi = Math.cos(phiRad);
                    double cosKPhi = Math.cos(this.k_ * phiRad);
                    xFactor = this.invRS_ * cosKPhi / (cosPhi * this.cosPhi1_ * this.cx_);
                } else {
                    phiRad = Math.asin(Math.sin(y * this.invRS_ * this.kOverCy_) / this.k_);
                    double sinPhi = Math.sin(phiRad);
                    xFactor = this.invRS_ / (Math.sqrt(1.0 - this.k2_ * sinPhi * sinPhi) * this.cx_);
                }
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.sinuWgt_ > 0.0) {
            super.drawBorderLines(g2d);
        } else {
            ProjGraphicUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        if (this.sinuWgt_ > 0.0) {
            super.drawMeridianNoLabel(g2d, lon, maxLat);
        } else {
            Point2D.Double dot = this.transformLL2XY(lon, 0.0);
            if (dot == null) {
                return;
            }
            float top = this.outCenterY_ - this.dyMax_;
            float bottom = this.outCenterY_ + this.dyMax_;
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
        }
    }
}

