/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.lang.invoke.MethodHandles;
import java.text.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotLabel
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HAlignment hAlignment_ = HAlignment.LEFT;
    private VAlignment vAlignment_ = VAlignment.TOP;
    private String text_;
    protected AttributedString attribText_;

    public PanPlotLabel(PanPlotMeta pmeta) {
        this(pmeta, "");
    }

    public PanPlotLabel(PanPlotMeta pmeta, String text) {
        this(pmeta, text, HAlignment.CENTER, VAlignment.TOP);
    }

    public PanPlotLabel(PanPlotMeta pmeta, String text, HAlignment hAlignment) {
        this(pmeta, text, hAlignment, VAlignment.TOP);
    }

    public PanPlotLabel(PanPlotMeta pmeta, String text, HAlignment hAlignment, VAlignment vAlignment) {
        super(pmeta);
        this.setText(text);
        this.setHorizontalAlignment(hAlignment);
        this.setVerticalAlignment(vAlignment);
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    public final void setText(String text) {
        this.text_ = text;
    }

    public HAlignment getHorizontalAlignment() {
        return this.hAlignment_;
    }

    public final void setHorizontalAlignment(HAlignment alignment) {
        this.hAlignment_ = alignment;
    }

    public VAlignment getVerticalAlignment() {
        return this.vAlignment_;
    }

    public final void setVerticalAlignment(VAlignment alignment) {
        this.vAlignment_ = alignment;
    }

    public void setFontSize(float fh) {
        this.setFont(this.getFont().deriveFont(fh));
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        AttributedString att;
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(gx);
        PlotPieceMargins margins = this.getMargins();
        int width = this.getWidth();
        int height = this.getHeight();
        Font f = this.getFont();
        g2d.setFont(f);
        g2d.setColor(this.getForeground());
        FontMetrics fm = g2d.getFontMetrics(f);
        if (this.attribText_ == null) {
            att = new AttributedString(this.text_);
            Font font = this.getFont();
            att.addAttribute(TextAttribute.FAMILY, font.getFontName());
            att.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
        } else {
            att = this.attribText_;
        }
        AttributedString ttt = GraphicUtils.trimStringToFit(att, g2d, width);
        int tascent = fm.getAscent();
        int twidth = (int)GraphicUtils.stringWidth(ttt, g2d);
        int theight = fm.getHeight();
        float x = this.hAlignment_ == HAlignment.CENTER ? 0.5f * (float)(width - twidth) : (this.hAlignment_ == HAlignment.RIGHT ? (float)(width - margins.getRight() - twidth) : (float)margins.getLeft());
        float y = this.vAlignment_ == VAlignment.MIDDLE ? 0.5f * (float)(height - theight) : (this.vAlignment_ == VAlignment.BOTTOM ? (float)(height - margins.getBottom()) : (float)(margins.getTop() + tascent));
        GraphicUtils.drawString(g2d, (Object)ttt, x, y);
        g2d.dispose();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor")) {
            String fn = this.pmeta_.getString("labels.font");
            Font f = this.getFont();
            float fhgt = f != null ? f.getSize2D() : 9.0f;
            this.setFont(PanGraphicUtils.getFont(fn, fhgt));
        }
    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

