/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanZoomableAxisControls;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCommonYAxisControls
extends PanZoomableAxisControls {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static Hashtable<String, String> paramKeys_ = new Hashtable();

    public PanCommonYAxisControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("grid-yaxis-controls", pmeta, mbar);
        this.createLayout(paramKeys_);
    }

    @Override
    protected final boolean isHorizontal() {
        return false;
    }

    @Override
    protected NcAxisType getAxisType() {
        switch (this.ptype_) {
            case TIME_LAT: {
                return NcAxisType.LAT;
            }
            case LAT_VERT: 
            case LON_VERT: 
            case TIME_VERT: {
                LOGGER.trace("More detailed tests required to determine vertical axis type.");
                break;
            }
            case LAT_TIME: 
            case LON_TIME: {
                this.axisIsTime_ = true;
                return NcAxisType.TIME;
            }
            case GENERAL_CC: 
            case VERT_LINE: {
                LOGGER.trace("More detailed tests required to determine vertical axis type.");
                break;
            }
            case HORZ_LINE: 
            case LL_ZONAL: {
                throw new RuntimeException("Cannot create Y axis controls for horizontal line plot");
            }
            case LON_LAT: {
                throw new RuntimeException("Cannot create Y axis controls for a lon-lat plot.");
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.ptype_);
            }
        }
        try {
            if (this.data_ instanceof PanDataTime1D) {
                this.axisIsTime_ = true;
            } else if (this.data_ instanceof PanData1D) {
                PanData1D data1d = (PanData1D)this.data_;
                this.axisIsPressure_ = data1d.isAxisPressure();
                this.axisIsHeight_ = data1d.isAxisHeight();
            } else if (this.data_ instanceof PanDataGeneral2D) {
                PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                NcAxis ax = data2d.getYAxis();
                this.axisIsPressure_ = ax.isPressure();
                this.axisIsHeight_ = ax.isHeight();
                boolean bl = this.axisIsTime_ = ax instanceof NcTimeAxis && ((NcTimeAxis)ax).isUnixTime();
            }
            if (this.axisIsTime_) {
                LOGGER.trace("Axis is TIME.");
                return NcAxisType.TIME;
            }
            NcAxisType atype = this.ptype_.getAxes()[1];
            LOGGER.trace("Axis (atype) is {}.", (Object)atype);
            if (atype == NcAxisType.TIME) {
                this.axisIsTime_ = true;
            }
            return atype;
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot determine Y axis type.");
        }
    }

    @Override
    public void resetAxisBounds() {
        double val2;
        double val1;
        PanAxisMethod method = PanAxisMethod.matching(this.pmeta_.getString("yaxis.method"));
        PanPreferences prefs = PanPreferences.getSharedInstance();
        switch (this.ptype_) {
            case TIME_LAT: {
                val1 = MathUtils.constrain(-90.0, 90.0, prefs.getDouble("plot:timelat.yaxis.begin"));
                val2 = MathUtils.constrain(-90.0, 90.0, prefs.getDouble("plot:timelat.yaxis.end"));
                break;
            }
            case HORZ_LINE: {
                return;
            }
            case VERT_LINE: {
                double[] range = ((PanData1D)this.data_).getDefaultAxisRange(method);
                val1 = range[0];
                val2 = range[1];
                break;
            }
            case LAT_VERT: 
            case LON_VERT: 
            case LAT_TIME: 
            case LON_TIME: 
            case GENERAL_CC: {
                double[] range = ((PanDataGeneral2D)this.data_).getDefaultBottomAndTop(method);
                val1 = range[0];
                val2 = range[1];
                break;
            }
            default: {
                LOGGER.debug("Not coded to handle plot type {}", (Object)this.ptype_);
                return;
            }
        }
        this.setAxisBounds(val1, val2);
    }

    static {
        paramKeys_.put("axis.begin", "yaxis.begin");
        paramKeys_.put("axis.end", "yaxis.end");
        paramKeys_.put("axis.method", "yaxis.method");
        paramKeys_.put("axis.units", "yaxis.units");
        paramKeys_.put("axis.units.alt", "yaxis.units.alt");
        paramKeys_.put("axis.div.major", "yaxis.div.major");
        paramKeys_.put("axis.div.minor", "yaxis.div.minor");
        paramKeys_.put("axis.tick.format", "yaxis.tick.format");
        paramKeys_.put("axis.tick.size", "yaxis.tick.size");
        paramKeys_.put("axis.label.custom", "yaxis.label.custom");
        paramKeys_.put("axis.label.text", "yaxis.label.text");
        paramKeys_.put("axis.label.size", "yaxis.label.size");
        paramKeys_.put("swap-axis-bounds", "swap-ybounds");
    }
}

