/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGridLabelStepComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLLGridSpacingComboBox;
import gov.nasa.giss.panoply.ui.PanLinkButton;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import java.awt.Color;
import java.awt.Font;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGridControlsLL
extends PanControlsPanel
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanLLGridSpacingComboBox lonSpacingCombo_;
    private PanLLGridSpacingComboBox latSpacingCombo_;
    private PanLinkButton linkButton_;
    private boolean linkedSpacing_;
    private PanCheckBox latOffsetCB_;
    private PanCheckBox lonPrunedCB_;
    private DescribedEnumComboBox styleCombo_;
    private ColorComboBox colorCombo_;
    private PanIntSpinner weightSpinner_;
    private PanGridLabelStepComboBox labelStepCombo_;
    private FloatComboBox labelSizeCombo_;
    private boolean refreshing_;

    public PanGridControlsLL(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("grid-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createLayout() {
        JLabel label11 = new JLabel("Spacing:\u2009");
        JLabel label12 = new JLabel("E-W");
        JLabel label13 = new JLabel("\u2009\u00d7\u2009");
        JLabel label14 = new JLabel("N-S");
        JLabel label15 = new JLabel("  ");
        this.lonSpacingCombo_ = PanLLGridSpacingComboBox.create("grid.spacing.lon");
        this.latSpacingCombo_ = PanLLGridSpacingComboBox.create("grid.spacing.lat");
        this.lonSpacingCombo_.setSpacing(this.pmeta_.getFloat("grid.spacing.lon"));
        this.latSpacingCombo_.setSpacing(this.pmeta_.getFloat("grid.spacing.lat"));
        this.linkedSpacing_ = this.lonSpacingCombo_.getSpacing() == this.latSpacingCombo_.getSpacing();
        this.linkButton_ = new PanLinkButton(null);
        this.linkButton_.setButtonSize(16);
        this.linkButton_.setLinked(this.linkedSpacing_);
        QuickBox line1 = QuickBox.createLeftBox(label11, this.lonSpacingCombo_, label12, label13, this.latSpacingCombo_, label14, label15, this.linkButton_, Box.createHorizontalStrut(12));
        JLabel label1a1 = new JLabel(" ");
        this.latOffsetCB_ = PanCheckBox.create("grid.offset.lat", "Offset parallels from Equator", this.pmeta_.getBoolean("grid.offset.lat"));
        QuickBox line1a = QuickBox.createLeftBox(label1a1, this.latOffsetCB_);
        JLabel label1b1 = new JLabel(" ");
        this.lonPrunedCB_ = PanCheckBox.create("grid.lon.pruned", "Prune meridians near poles", this.pmeta_.getBoolean("grid.lon.pruned"));
        QuickBox line1b = QuickBox.createLeftBox(label1b1, this.lonPrunedCB_);
        JLabel label21 = new JLabel("Stroke:\u2009");
        JLabel label22 = new JLabel("\u2014 Color:\u2009");
        JLabel label23 = new JLabel("\u2014 Weight:\u2009");
        JLabel label24 = new JLabel("%");
        this.styleCombo_ = new DescribedEnumComboBox(PanStrokePattern.class);
        this.styleCombo_.setName("grid.style");
        this.styleCombo_.setSelItemMatching(this.pmeta_.getString("grid.style"));
        this.colorCombo_ = new ColorComboBox();
        this.colorCombo_.setName("grid.color");
        this.colorCombo_.setSelectedColor(this.pmeta_.getColor("grid.color"));
        this.weightSpinner_ = PanIntSpinner.smallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 0, 200);
        QuickBox line2 = QuickBox.createHorizontalBox(label21, this.styleCombo_, label22, this.colorCombo_, label23, this.weightSpinner_, label24, Box.createHorizontalGlue());
        JLabel label31 = new JLabel("Labels:\u2009");
        JLabel label32 = new JLabel("\u2014 Size:\u2009");
        this.labelStepCombo_ = PanGridLabelStepComboBox.create("grid.label.step");
        this.labelStepCombo_.setStep(this.pmeta_.getInt("grid.label.step"));
        this.labelSizeCombo_ = FloatComboBox.create(5.0f, 15.0f);
        this.labelSizeCombo_.setName("grid.label.size");
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("grid.label.size"));
        QuickBox line3 = QuickBox.createHorizontalBox(label31, this.labelStepCombo_, label32, this.labelSizeCombo_, Box.createHorizontalGlue());
        MultiLineLabel noteLabel = new MultiLineLabel("Grid labels are only available for cylindric\nand pseudocylindric projections.", 0);
        Font xfont = noteLabel.getFont();
        xfont = xfont.deriveFont((float)xfont.getSize() * 0.9f);
        noteLabel.setFont(xfont);
        QuickBox line4 = QuickBox.createCenterBox(noteLabel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(line1);
        this.add(Box.createVerticalStrut(1));
        this.add(line1a);
        this.add(Box.createVerticalStrut(1));
        this.add(line1b);
        this.add(Box.createVerticalStrut(1));
        this.add(line2);
        this.add(Box.createVerticalStrut(1));
        this.add(line3);
        this.add(Box.createVerticalStrut(1));
        this.add(line4);
        this.add(Box.createVerticalStrut(3));
        GuiUtils.setSizeSmall(this);
        GuiUtils.matchLabelWidths(label11, label1a1, label1b1, label21, label31);
        this.lonSpacingCombo_.setMaximumSize(this.lonSpacingCombo_.getPreferredSize());
        this.latSpacingCombo_.setMaximumSize(this.latSpacingCombo_.getPreferredSize());
        this.styleCombo_.setMaximumSize(this.styleCombo_.getPreferredSize());
        this.weightSpinner_.setMaximumSize(this.weightSpinner_.getPreferredSize());
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        this.labelStepCombo_.setEnabled(proj.canLabelGrid());
        this.labelSizeCombo_.setEnabled(proj.canLabelGrid());
        float newLonSpacing = this.pmeta_.getFloat("grid.spacing.lon");
        float newLatSpacing = this.pmeta_.getFloat("grid.spacing.lat");
        if (newLonSpacing != this.lonSpacingCombo_.getSpacing()) {
            this.lonSpacingCombo_.setSpacing(newLonSpacing);
        }
        if (newLatSpacing != this.latSpacingCombo_.getSpacing()) {
            this.latSpacingCombo_.setSpacing(newLatSpacing);
        }
        this.linkedSpacing_ = this.lonSpacingCombo_.getSpacing() == this.latSpacingCombo_.getSpacing();
        this.linkButton_.setLinked(this.linkedSpacing_);
        this.lonPrunedCB_.setEnabled(proj.canPruneMeridians());
        this.styleCombo_.setSelItemMatching(this.pmeta_.getString("grid.style"));
        this.colorCombo_.setSelectedColor(this.pmeta_.getColor("grid.color"));
        this.weightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        this.labelStepCombo_.setStep(this.pmeta_.getInt("grid.label.step"));
        this.labelSizeCombo_.setValue(this.pmeta_.getFloat("grid.label.size"));
        this.refreshing_ = false;
        this.repaint();
    }

    private void attachListeners() {
        this.lonSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanGridControlsLL panGridControlsLL = this;
            synchronized (panGridControlsLL) {
                float spacing = this.lonSpacingCombo_.getSpacing();
                LOGGER.trace("lon spacing {}", (Object)Float.valueOf(spacing));
                if (this.linkedSpacing_) {
                    this.latSpacingCombo_.setSpacing(spacing);
                    this.pmeta_.setGroup({"grid.spacing.lon", Float.valueOf(spacing)}, {"grid.spacing.lat", Float.valueOf(spacing)});
                } else {
                    this.pmeta_.setFloat("grid.spacing.lon", spacing);
                }
            }
        });
        this.latSpacingCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            PanGridControlsLL panGridControlsLL = this;
            synchronized (panGridControlsLL) {
                float spacing = this.latSpacingCombo_.getSpacing();
                LOGGER.trace("lat spacing {}", (Object)Float.valueOf(spacing));
                this.pmeta_.setFloat("grid.spacing.lat", spacing);
                if (this.linkedSpacing_) {
                    this.lonSpacingCombo_.setSpacing(spacing);
                    this.pmeta_.setGroup({"grid.spacing.lon", Float.valueOf(spacing)}, {"grid.spacing.lat", Float.valueOf(spacing)});
                } else {
                    this.pmeta_.setFloat("grid.spacing.lat", spacing);
                }
            }
        });
        this.linkButton_.addActionListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.linkedSpacing_ = !this.linkedSpacing_;
            this.linkButton_.setLinked(this.linkedSpacing_);
            if (this.linkedSpacing_) {
                float spacing = this.lonSpacingCombo_.getSpacing();
                this.latSpacingCombo_.setSpacing(spacing);
            }
        });
        this.latOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("grid.offset.lat", e.getStateChange() == 1);
        });
        this.lonPrunedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setBoolean("grid.lon.pruned", e.getStateChange() == 1);
        });
        this.colorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.colorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("grid.color"))) {
                this.pmeta_.setColor("grid.color", cnew);
            }
        });
        this.styleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.styleCombo_.getEnumName());
        });
        this.weightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.weight", this.weightSpinner_.getIntValue());
        });
        this.labelStepCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.label.step", this.labelStepCombo_.getStep());
        });
        this.labelSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            this.pmeta_.setFloat("grid.label.size", value);
        });
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        float newSpacing;
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("grid.style")) {
            this.styleCombo_.setSelItemMatching(this.pmeta_.getString("grid.style"));
        }
        if (changeAll || pname.contains("grid.weight")) {
            this.weightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        }
        if (changeAll || pname.contains("proj.name")) {
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            AbstractProjection proj = projmeta.getProjection();
            this.labelStepCombo_.setEnabled(proj.canLabelGrid());
            this.labelSizeCombo_.setEnabled(proj.canLabelGrid());
            this.lonPrunedCB_.setEnabled(proj.canPruneMeridians());
        }
        if (!changeAll && !pname.contains("grid.spacing.lon") || !this.linkedSpacing_ || (newSpacing = this.pmeta_.getFloat("grid.spacing.lon")) != this.latSpacingCombo_.getSpacing()) {
            // empty if block
        }
        if (!changeAll && !pname.contains("grid.spacing.lat") || !this.linkedSpacing_ || (newSpacing = this.pmeta_.getFloat("grid.spacing.lat")) != this.lonSpacingCombo_.getSpacing()) {
            // empty if block
        }
        this.repaint();
    }
}

