/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PanPlotGlass
extends JComponent {
    private static final Color DRAG_FRAME_COLOR = Color.WHITE;
    private static final Color DRAG_BACK_COLOR = Color.WHITE;
    private static final Color DATA_FRAME_COLOR = Color.GRAY;
    private static final Color DATA_TEXT_COLOR = Color.BLACK;
    private static final Color DATA_BACK_COLOR = new Color(255, 255, 221);
    private static final BasicStroke DATA_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke DRAG_STROKE = GraphicUtils.buttMiterStroke(100.0f, new float[]{3.0f, 2.0f, 3.0f, 2.0f});
    private static final BasicStroke TARGET_STROKE = GraphicUtils.buttMiterStroke(100.0f, new float[]{3.0f, 2.0f, 3.0f, 2.0f});
    private static final AlphaComposite DRAG_ALPHA = AlphaComposite.getInstance(3, 0.25f);
    private static final int BOX_X_MARGIN = 5;
    private static final int BOX_Y_MARGIN = 3;
    private final PanPlotFrame parent_;
    private ContentType contentType_ = ContentType.NONE;
    private Rectangle rectangle_;
    private Point point_;
    private String text_;

    public PanPlotGlass(PanPlotFrame parent) {
        this.parent_ = parent;
        this.setOpaque(false);
        this.setFont(new Font("SansSerif", 0, 10));
    }

    public void clear() {
        this.setContentType(ContentType.NONE);
        this.text_ = null;
    }

    public void setContentType(ContentType ct) {
        this.contentType_ = ct;
        this.setVisible(ct != ContentType.NONE);
    }

    public void setPoint(Point point) {
        this.point_ = point;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle_ = rectangle;
    }

    public void setText(String text) {
        this.text_ = text;
    }

    @Override
    public void paintComponent(Graphics g) {
        switch (this.contentType_) {
            case CROSSHAIRS: {
                this.paintTarget(g);
                break;
            }
            case DRAG_FRAME: {
                this.paintDrag(g);
                break;
            }
            case TEXT_BOX: {
                this.paintText(g);
                break;
            }
        }
    }

    private void paintTarget(Graphics g) {
        if (this.point_.x == 0 || this.point_.y == 0) {
            return;
        }
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setPaintMode();
        g2d.setColor(Color.GRAY);
        g2d.setStroke(TARGET_STROKE);
        Rectangle phr = this.getPlotHolderBounds();
        GraphicUtils.drawLine(g2d, this.point_.x, phr.y, this.point_.x, phr.y + phr.height);
        GraphicUtils.drawLine(g2d, phr.x, this.point_.y, phr.x + phr.width, this.point_.y);
        g2d.dispose();
    }

    private void paintDrag(Graphics g) {
        if (this.rectangle_.width == 0 || this.rectangle_.height == 0) {
            return;
        }
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setPaintMode();
        g2d.setColor(DRAG_FRAME_COLOR);
        g2d.setStroke(DRAG_STROKE);
        GraphicUtils.drawRect(g2d, this.rectangle_.x, this.rectangle_.y, this.rectangle_.width, this.rectangle_.height);
        g2d.setComposite(DRAG_ALPHA);
        g2d.setColor(DRAG_BACK_COLOR);
        GraphicUtils.fillRect(g2d, this.rectangle_.x, this.rectangle_.y, this.rectangle_.width, this.rectangle_.height);
        g2d.dispose();
    }

    private void paintText(Graphics g) {
        if (this.point_ == null || this.text_ == null || this.text_.isEmpty()) {
            return;
        }
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        int x = this.point_.x;
        int y = this.point_.y;
        g2d.setColor(DATA_TEXT_COLOR);
        g2d.setStroke(DATA_STROKE);
        g2d.drawLine(x - 3, y, x + 3, y);
        g2d.drawLine(x, y - 3, x, y + 3);
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics(this.getFont());
        int lineHeight = fm.getHeight();
        int lineAscent = fm.getAscent();
        StringTokenizer t = new StringTokenizer(this.text_, "\n");
        int numLines = t.countTokens();
        String[] lines = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            lines[i] = t.nextToken();
        }
        int twidth = 0;
        for (String line : lines) {
            twidth = Math.max(twidth, (int)GraphicUtils.stringWidth(line, g2d));
        }
        int theight = numLines * lineHeight + 6;
        Rectangle phr = this.getPlotHolderBounds();
        x = x + 4 + (twidth += 10) <= phr.x + phr.width ? (x += 2) : (x -= 2 + twidth);
        int toomuchY = (y += 5) + theight - (phr.y + phr.height);
        if (toomuchY > 0) {
            y -= toomuchY;
        }
        g2d.setColor(DATA_BACK_COLOR);
        GraphicUtils.fillRect(g2d, x, y, twidth, theight);
        g2d.setColor(DATA_FRAME_COLOR);
        g2d.setStroke(DATA_STROKE);
        GraphicUtils.drawRect(g2d, x, y, twidth, theight);
        x += 5;
        y += 3 + lineAscent;
        g2d.setColor(DATA_TEXT_COLOR);
        int i = 0;
        while (i < numLines) {
            GraphicUtils.drawString(g2d, (Object)lines[i], x, y);
            ++i;
            y += lineHeight;
        }
        g2d.dispose();
    }

    private Rectangle getPlotHolderBounds() {
        PanPlotHolder ph = this.parent_.getPlotHolder();
        Rectangle rr = ph.getVisibleRect();
        return SwingUtilities.convertRectangle(ph, rr, this);
    }

    public static enum ContentType {
        NONE,
        CROSSHAIRS,
        DRAG_FRAME,
        TEXT_BOX;

    }
}

