/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.clut.ColorTableOutlierShape;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanColorbarTickLength;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorbarPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanColorTableComboBox clutCombo_;
    private PanCheckBox reversedCB_;
    private ColorComboBox invalidsCombo_;
    private DescribedEnumComboBox cbarLocCombo_;
    private PanIntSpinner cbarLengthSpinner_;
    private DescribedEnumComboBox outlierShapeCombo_;
    private DescribedEnumComboBox outlierSideCombo_;
    private DescribedEnumComboBox outlierGapCombo_;
    private PanIntSpinner borderWgtSpinner_;
    private DescribedEnumComboBox tickLengthCombo_;
    private FloatComboBox labelSizeCombo_;
    private DescribedEnumComboBox cbarLabelLocCombo_;
    private boolean refreshing_;

    public PanColorbarPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        LOGGER.trace("");
        this.setBorder(GuiUtils.createPaddedTitleBorder("Scale Colorbar"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a color contour plot, set\u2026");
        this.clutCombo_ = PanColorTableComboBox.create(true);
        this.clutCombo_.setToolTipText("Select a default color table to apply to new plots");
        Dimension d = this.clutCombo_.getPreferredSize();
        if (d.width > 320) {
            d.width = 320;
            this.clutCombo_.setPreferredSize(d);
            this.clutCombo_.setMaximumSize(d);
        }
        this.reversedCB_ = PanCheckBox.create("Reverse colors");
        this.invalidsCombo_ = new ColorComboBox(PaletteType.GRAYSCALE);
        this.cbarLocCombo_ = new DescribedEnumComboBox(PanColorbarLocation.class);
        this.cbarLengthSpinner_ = PanIntSpinner.create(60, 50, 100, 5);
        this.outlierShapeCombo_ = new DescribedEnumComboBox(ColorTableOutlierShape.class);
        this.outlierSideCombo_ = new DescribedEnumComboBox(PanColorbarOutlierSide.class);
        this.outlierGapCombo_ = new DescribedEnumComboBox(PanColorbarOutlierGap.class);
        this.borderWgtSpinner_ = PanIntSpinner.create(100, 0, 125, 1);
        this.tickLengthCombo_ = new DescribedEnumComboBox(PanColorbarTickLength.class);
        this.labelSizeCombo_ = FloatComboBox.create(5.0f, 32.0f);
        this.cbarLabelLocCombo_ = new DescribedEnumComboBox(PanColorbarLabelLocation.class);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 10, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add((Component)new JLabel("Color Table:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.clutCombo_, this.reversedCB_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Location:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.cbarLocCombo_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Fill Color:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.invalidsCombo_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Length:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.cbarLengthSpinner_, new JLabel("%")), new FGConstraint(1, row));
        this.add((Component)new JLabel("Border:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Weight:\u2009"), this.borderWgtSpinner_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Outliers:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("On:\u2009"), this.outlierSideCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Shape:\u2009"), this.outlierShapeCombo_, new JLabel(", Gap:\u2009"), this.outlierGapCombo_), new FGConstraint(1, ++row));
        this.add((Component)new JLabel("Major Ticks:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Length:\u2009"), this.tickLengthCombo_), new FGConstraint(1, row));
        this.add((Component)new JLabel("Caption:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Size:\u2009"), this.labelSizeCombo_, new JLabel(", Location:\u2009"), this.cbarLabelLocCombo_), new FGConstraint(1, row));
        this.cbarLengthSpinner_.setMaximumSize(this.cbarLengthSpinner_.getPreferredSize());
        this.outlierShapeCombo_.setMaximumSize(this.outlierShapeCombo_.getPreferredSize());
        this.outlierGapCombo_.setMaximumSize(this.outlierGapCombo_.getPreferredSize());
    }

    private void attachListeners() {
        LOGGER.trace("");
        this.clutCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setString("plot:colorbar.name", this.clutCombo_.getSelectedItem().toString());
        });
        this.reversedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:colorbar.reverse", this.reversedCB_.isSelected());
        });
        this.cbarLengthSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:colorbar.length", this.cbarLengthSpinner_.getIntValue());
        });
        this.cbarLocCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.location", this.cbarLocCombo_.getEnumName());
        });
        this.invalidsCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.invalids", this.invalidsCombo_.getSelectedColor());
        });
        this.outlierSideCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.outlier.side", this.outlierSideCombo_.getEnumName());
        });
        this.outlierShapeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.outlier.shape", this.outlierShapeCombo_.getEnumName());
        });
        this.outlierGapCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.outlier.gap", this.outlierGapCombo_.getEnumName());
        });
        this.borderWgtSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:colorbar.border.weight", this.borderWgtSpinner_.getIntValue());
        });
        this.tickLengthCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setString("plot:colorbar.tick.length", this.tickLengthCombo_.getEnumName());
        });
        this.labelSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.labelSizeCombo_.getValue();
            prefs_.setFloat("plot:scale.label.size", value);
        });
        this.cbarLabelLocCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:colorbar.label.location", this.cbarLabelLocCombo_.getEnumName());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        LOGGER.trace("");
        this.refreshing_ = true;
        this.clutCombo_.setSelectedItemByName(prefs_.getString("plot:colorbar.name"));
        this.cbarLocCombo_.setSelItemMatching(prefs_.getString("plot:colorbar.location"));
        this.reversedCB_.setSelected(prefs_.getBoolean("plot:colorbar.reverse"));
        this.cbarLengthSpinner_.setValue(prefs_.getInt("plot:colorbar.length"));
        this.borderWgtSpinner_.setValue(prefs_.getInt("plot:colorbar.border.weight"));
        this.invalidsCombo_.setSelectedColor(prefs_.getColor("plot:colorbar.invalids"));
        this.outlierShapeCombo_.setSelItemMatching(prefs_.getString("plot:colorbar.outlier.shape"));
        this.outlierSideCombo_.setSelItemMatching(prefs_.getString("plot:colorbar.outlier.side"));
        this.outlierGapCombo_.setSelItemMatching(prefs_.getString("plot:colorbar.outlier.gap"));
        this.tickLengthCombo_.setSelItemMatching(prefs_.getString("plot:colorbar.tick.length"));
        this.labelSizeCombo_.setSelectedItem(prefs_.getFloat("plot:scale.label.size"));
        this.cbarLabelLocCombo_.setSelItemMatching(prefs_.getString("plot:colorbar.label.location"));
        this.refreshing_ = false;
    }
}

