/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableHeaderListener;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableModel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import net.schmunk.ui.PlusMinus;

public abstract class PanCommonPrefsTablePanel
extends PanAbstractPrefsPanel {
    protected PanCommonPrefsTable table_;
    protected PanPrefsTableModel tmodel_;
    protected JScrollPane tspane_;
    protected PlusMinus pmwidget_;
    protected JButton checkMinBtn_;
    protected JButton checkAllBtn_;
    protected KeyStroke cutKS_;
    protected PanCheckBox autoimportCB_;
    protected Border focusedTableBorder_;
    protected Border unfocusedTableBorder_;

    public PanCommonPrefsTablePanel() {
        this.createLayout();
        this.attachListeners();
    }

    abstract void createLayout();

    private void attachListeners() {
        if (this.checkAllBtn_ != null) {
            this.checkAllBtn_.addActionListener(e -> this.tmodel_.checkUncheckAll(true));
            this.checkMinBtn_.addActionListener(e -> this.tmodel_.checkUncheckAll(false));
        }
        if (this.pmwidget_ != null) {
            this.pmwidget_.addActionListener(e -> {
                if (e.getID() == 2000) {
                    this.additionRequested();
                } else if (e.getID() == 2001) {
                    int row = this.table_.getSelectedRow();
                    this.deletionRequested(row);
                }
            });
        }
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanCommonPrefsTablePanel.this.refresh();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PanCommonPrefsTablePanel.this.refresh();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                Point p = e.getPoint();
                int row = PanCommonPrefsTablePanel.this.table_.rowAtPoint(p);
                PanCommonPrefsTablePanel.this.displaySelection(row);
            }
        });
        JTableHeader jth = this.table_.getTableHeader();
        jth.addMouseListener(new PanPrefsTableHeaderListener(this.table_));
        ActionMap am = this.table_.getActionMap();
        Object cutKey = GuiUtils.getCutKey(am);
        InputMap im = this.table_.getInputMap(1);
        this.cutKS_ = null;
        for (KeyStroke ks : im.allKeys()) {
            Object o = im.get(ks);
            if (!o.equals(cutKey)) continue;
            this.cutKS_ = ks;
            break;
        }
        this.table_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = PanCommonPrefsTablePanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (PanCommonPrefsTablePanel.this.cutKS_ != null && ks.equals(PanCommonPrefsTablePanel.this.cutKS_)) {
                    PanCommonPrefsTablePanel.this.deletionRequested(row);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = PanCommonPrefsTablePanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && e.getModifiersEx() == 0) {
                    PanCommonPrefsTablePanel.this.deletionRequested(row);
                } else if (PanCommonPrefsTablePanel.this.cutKS_ != null && ks.equals(PanCommonPrefsTablePanel.this.cutKS_)) {
                    PanCommonPrefsTablePanel.this.deletionRequested(row);
                }
            }
        });
    }

    abstract void displaySelection(int var1);

    abstract void additionRequested();

    abstract void deletionRequested(int var1);
}

