/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.StringComboBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLatVertPrefsPanel
extends PanAbstractPrefsPanel {
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private GTextField lvalTF_;
    private GTextField rvalTF_;
    private DescribedEnumComboBox yMethodCombo_;
    private StringComboBox yFormatCombo_;
    private boolean refreshing_;

    public PanLatVertPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lat-Vert Plots"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a lat-vert plot, set\u2026");
        this.lvalTF_ = GTextField.createDoubleField(-90.0);
        this.rvalTF_ = GTextField.createDoubleField(90.0);
        this.yMethodCombo_ = new DescribedEnumComboBox(PanAxisMethod.class);
        this.yFormatCombo_ = StringComboBox.createNumberPformat();
        GuiUtils.applyComboBoxUI(this.yFormatCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1));
        this.add((Component)new JLabel("Lat Axis Left:\u2009"), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.lvalTF_, new JLabel("\u00b0N, Right:\u2009"), this.rvalTF_, new JLabel("\u00b0N")), new FGConstraint(1, 2));
        this.add((Component)new JLabel("Vert Axis Units:\u2009"), new FGConstraint(0, 3, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.yMethodCombo_, new JLabel("\u2014 Format:\u2009"), this.yFormatCombo_), new FGConstraint(1, 3));
        this.yMethodCombo_.setMaximumSize(this.yMethodCombo_.getPreferredSize());
        this.yFormatCombo_.setMaximumSize(this.yFormatCombo_.getPreferredSize());
    }

    private void attachListeners() {
        FocusAdapter xRangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanLatVertPrefsPanel.this.handleXExtrema();
            }
        };
        this.lvalTF_.addFocusListener(xRangeFL);
        this.rvalTF_.addFocusListener(xRangeFL);
        this.lvalTF_.addActionListener(e -> this.handleXExtrema());
        this.rvalTF_.addActionListener(e -> this.handleXExtrema());
        this.yMethodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:latvert.yaxis.method", this.yMethodCombo_.getEnumName());
        });
        this.yFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:latvert.yaxis.tick.format", this.yFormatCombo_.getSelectedString());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.lvalTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:latvert.xaxis.begin")));
        this.rvalTF_.setText(PFORMAT_7G.sprintfx(prefs_.getDouble("plot:latvert.xaxis.end")));
        this.yMethodCombo_.setSelItemMatching(prefs_.getString("plot:latvert.yaxis.method"));
        this.yFormatCombo_.setSelectedItem(prefs_.getString("plot:latvert.yaxis.tick.format"));
        this.refreshing_ = false;
    }

    private void handleXExtrema() {
        double oldright;
        double oldleft;
        double left = oldleft = prefs_.getDouble("plot:latvert.xaxis.begin");
        try {
            left = StringUtils.parseDouble(this.lvalTF_.getText());
        }
        catch (Exception exc) {
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(oldleft));
            return;
        }
        if (left < -90.0) {
            left = -90.0;
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
        } else if (left >= 90.0) {
            left = 90.0;
            this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
        }
        double right = oldright = prefs_.getDouble("plot:latvert.xaxis.end");
        try {
            right = StringUtils.parseDouble(this.rvalTF_.getText());
        }
        catch (Exception exc) {
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(oldright));
            return;
        }
        if (right < -90.0) {
            right = -90.0;
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
        } else if (right >= 90.0) {
            right = 90.0;
            this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
        }
        if (left == right) {
            if (left == -90.0) {
                right = -89.999;
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
            } else if (left == 90.0) {
                left = 89.999;
                this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
            } else {
                right = left + 0.001;
                if (right >= 90.0) {
                    left = 89.999;
                    right = 90.0;
                }
                this.lvalTF_.setText(PFORMAT_7G.sprintfx(left));
                this.rvalTF_.setText(PFORMAT_7G.sprintfx(right));
            }
        }
        prefs_.setDouble("plot:latvert.xaxis.begin", left);
        prefs_.setDouble("plot:latvert.xaxis.end", right);
    }
}

