/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.ui.ProjListComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.ui.PanProjectionComboBox;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatProjectionPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_4G = new PrintfFormat("%.4g");
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private PanProjectionComboBox projCombo_;
    private JLabel centerLabel_;
    private GTextField copLonTF_;
    private GTextField copLatTF_;
    private QuickBox copLonBox_;
    private QuickBox copLatBox_;
    private QuickBox[] paramBoxes_;
    private boolean refreshing_;

    public PanLonLatProjectionPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel topText = new JLabel("When creating a map plot, set\u2026");
        this.setOpaque(false);
        this.projCombo_ = PanProjectionComboBox.create(null, true);
        this.centerLabel_ = new JLabel("Centered on:\u2009");
        JLabel lonLabel = new JLabel("Lon.\u2009");
        JLabel degELabel = new JLabel("\u00b0E");
        JLabel latLabel = new JLabel(", Lat.\u2009");
        JLabel degNLabel = new JLabel("\u00b0N");
        this.copLonTF_ = GTextField.createDoubleField(0.0, 6);
        this.copLatTF_ = GTextField.createDoubleField(0.0, 6);
        this.copLonTF_.setMaximumSize(this.copLonTF_.getPreferredSize());
        this.copLatTF_.setMaximumSize(this.copLatTF_.getPreferredSize());
        this.copLonBox_ = QuickBox.createLeftBox(lonLabel, this.copLonTF_, degELabel);
        this.copLatBox_ = QuickBox.createLeftBox(latLabel, this.copLatTF_, degNLabel);
        this.paramBoxes_ = new QuickBox[]{QuickBox.createHorizontalBox(new Component[0]), QuickBox.createHorizontalBox(new Component[0])};
        JLabel bottomText2 = new JLabel("See also the preferences for Map Overlay and Map Shading.");
        GuiUtils.setSizeSmall(bottomText2);
        this.projCombo_.setMaximumSize(this.projCombo_.getPreferredSize());
        FlexingGridLayout fgl = new FlexingGridLayout(3, 8, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Map Plot Projection"));
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        ++row;
        this.add((Component)new JLabel("Projection:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.projCombo_, new FGConstraint(1, row));
        this.add((Component)this.centerLabel_, new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.copLonBox_, this.copLatBox_), new FGConstraint(1, row));
        this.add((Component)this.paramBoxes_[0], new FGConstraint(1, ++row));
        this.add((Component)this.paramBoxes_[1], new FGConstraint(1, ++row));
        this.add((Component)bottomText2, new FGConstraint(1, ++row));
        this.invalidate();
    }

    private void attachListeners() {
        TFFocusListener tfFL = new TFFocusListener();
        this.copLonTF_.addFocusListener(tfFL);
        this.copLatTF_.addFocusListener(tfFL);
        this.copLonTF_.addActionListener(e -> this.handleTF());
        this.copLatTF_.addActionListener(e -> this.handleTF());
        this.projCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.projectionChanged();
        });
    }

    private void validateCOP() {
        try {
            double lon;
            if (lon < -180.0 || lon > 180.0) {
                for (lon = StringUtils.parseDouble(this.copLonTF_.getText()); lon > 180.0; lon -= 360.0) {
                }
                while (lon < -180.0) {
                    lon += 360.0;
                }
                this.copLonTF_.setText(PFORMAT_4G.sprintfx(lon));
            }
        }
        catch (Exception exc) {
            this.copLonTF_.setText(PFORMAT_4G.sprintfx(0.0));
        }
        try {
            double lat = StringUtils.parseDouble(this.copLatTF_.getText());
            if (Math.abs(lat) > 90.0) {
                lat = 90.0 * Math.signum(lat);
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            }
        }
        catch (Exception exc) {
            this.copLatTF_.setText(PFORMAT_4G.sprintfx(0.0));
        }
    }

    private void projectionChanged() {
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        String projname = this.projCombo_.getSelectedItem().toString();
        prefs_.set("plot:proj.name", projname);
        AbstractProjection proj = projname.equals("Equirectangular Regional") ? new EquirectangularRegional(20, 10) : ProjectionFactory.create(projname, 20, 10);
        try {
            proj.setCenter(prefs_.getDouble("plot:proj.lon0"), prefs_.getDouble("plot:proj.lat0"));
        }
        catch (Exception exc) {
            proj.setCenter(0.0, 0.0);
        }
        if (proj.hasProperty(0x1000000)) {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(false);
            double clon = proj.getCenter().getLon();
            prefs_.setDouble("plot:proj.lon0", clon);
            this.copLonTF_.setText(PFORMAT_4G.sprintfx(clon));
        } else {
            this.copLonTF_.setEnabled(proj.isRecenterableLon());
            this.copLatTF_.setEnabled(proj.isRecenterableLat());
        }
        this.centerLabel_.setVisible(true);
        this.copLonBox_.setVisible(true);
        this.copLatBox_.setVisible(true);
        this.paramBoxes_[0].removeAll();
        this.paramBoxes_[1].removeAll();
        int pcount = proj.getExtraParamCount();
        int pRow = 0;
        int pRowItem = 0;
        for (int i = 0; i < pcount; ++i) {
            if (pRowItem > 0) {
                this.paramBoxes_[pRow].add(new JLabel(",\u2009"));
            }
            ProjParamComponent pf = proj.getParamComponent(i);
            pf.setMaximumSize(pf.getPreferredSize());
            this.paramBoxes_[pRow].add(pf);
            int pid = i;
            pf.addChangeListener(e -> {
                pprefs.setParam(projname, pid, pf.getStringValue());
                if (proj.hasProperty(0x1000000)) {
                    this.copLonTF_.setEnabled(proj.isRecenterableLon());
                    double clon = proj.getCenter().getLon();
                    prefs_.setDouble("plot:proj.lon0", clon);
                    this.copLonTF_.setText(PFORMAT_4G.sprintfx(clon));
                }
            });
            if (pf instanceof ProjListComponent) {
                ++pRow;
                pRowItem = 0;
            } else if (++pRowItem > 1) {
                ++pRow;
                pRowItem = 0;
            }
            String sval = pprefs.getParam(projname, i);
            if (sval == null || sval.isEmpty()) continue;
            try {
                pf.setValue(sval);
                continue;
            }
            catch (Exception exc) {
                LOGGER.trace("exc = {}", (Object)exc.toString());
            }
        }
        if (this.paramBoxes_[0].getComponentCount() == 0) {
            JLabel noteLabel = new JLabel("Projection has no additional parameters");
            GuiUtils.setSizeSmall(noteLabel);
            this.paramBoxes_[0].add(noteLabel);
        }
        this.paramBoxes_[0].invalidate();
        this.paramBoxes_[1].invalidate();
        this.invalidate();
        JFrame jf = (JFrame)this.getTopLevelAncestor();
        if (jf != null) {
            this.invalidate();
            jf.validate();
            jf.pack();
        }
        if (jf instanceof PanPreferencesFrame) {
            ((PanPreferencesFrame)jf).refresh();
        }
        this.repaint();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.refreshProjList();
        this.projCombo_.setSelectedItem(prefs_.getString("plot:proj.name"));
        this.projectionChanged();
        this.refreshing_ = false;
    }

    private void refreshProjList() {
        if (this.refreshing_) {
            return;
        }
        String oldName = this.projCombo_.getSelectedItem().toString();
        this.projCombo_.refresh();
        String newName = this.projCombo_.getSelectedItem().toString();
        if (!newName.equals(oldName)) {
            prefs_.set("plot:proj.name", newName);
        }
    }

    private void handleTF() {
        this.validateCOP();
        prefs_.setDouble("plot:proj.lon0", this.copLonTF_.getText());
        prefs_.setDouble("plot:proj.lat0", this.copLatTF_.getText());
    }

    class TFFocusListener
    extends FocusAdapter {
        TFFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            PanLonLatProjectionPrefsPanel.this.handleTF();
        }
    }
}

