/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefs.PanSavedSettings;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsHandler;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableModel;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanSavedSettingsTableModel
extends PanPrefsTableModel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSavedSettingsHandler sslist_ = PanSavedSettingsHandler.getSharedInstance();

    public PanSavedSettingsTableModel() {
        super(false);
        this.sslist_.addListDataListener(this);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.sslist_ == null) {
            return 0;
        }
        return this.sslist_.getChildCount();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            default: 
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Created";
            }
        }
        return "Error";
    }

    @Override
    public Object getValueAt(int row, int col) {
        PanSavedSettings pss = this.sslist_.get(row);
        switch (col) {
            case 0: {
                return pss.getPlotType().name();
            }
            case 1: {
                return pss.getName();
            }
            case 2: {
                return pss.getDateString(true);
            }
        }
        return "Error";
    }

    public int getColumnAlignment(int col) {
        switch (col) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
        }
        return 2;
    }

    public PanSavedSettings getSettings(int row) {
        if (row < 0 || row >= this.sslist_.getChildCount()) {
            return null;
        }
        return this.sslist_.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 1 || value == null) {
            return;
        }
        PanSavedSettings pss = this.sslist_.get(row);
        String name = value.toString();
        if (!name.isEmpty()) {
            pss.setName(value.toString());
        }
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        this.fireTableDataChanged();
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        LOGGER.trace("{}", (Object)index0);
        this.fireTableRowsInserted(index0, index1);
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        LOGGER.trace("{}", (Object)index0);
        this.fireTableRowsDeleted(index0, index1);
    }

    @Override
    void sortByColumn(int col) {
        LOGGER.trace("{}", (Object)col);
        switch (col) {
            case 0: {
                this.sslist_.sortByType();
                break;
            }
            case 1: {
                this.sslist_.sortByName();
                break;
            }
            case 2: {
                this.sslist_.sortByDate();
                break;
            }
        }
        this.fireTableDataChanged();
    }
}

