/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

public enum PanPlotSectionID {
    TITLES("include-titles", "include.title"),
    AXES("include-axes", "include.axes"),
    CBAR("include-colorbar", "include.colorbar"),
    STROKE_INFO("include-strokeinfo", "include.strokeinfo"),
    FOOTNOTES("include-footnotes", "include.footnotes"),
    MARGINS("include-margins", "include.margins");

    final String actionKey_;
    final String paramKey_;

    private PanPlotSectionID(String actionKey, String paramKey) {
        this.actionKey_ = actionKey;
        this.paramKey_ = paramKey;
    }

    public String getActionKey() {
        return this.actionKey_;
    }

    public String getParamKey() {
        return this.paramKey_;
    }

    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.actionKey_.equalsIgnoreCase(text) || this.paramKey_.equalsIgnoreCase(text);
    }

    public static PanPlotSectionID matching(String str) {
        for (PanPlotSectionID item : PanPlotSectionID.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

