/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorChooserPreview;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import gov.nasa.giss.ui.color.chooser.RgbSlider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.ColorSelectionModel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class RgbSliderPanel
extends ColorChooserPanel {
    private RgbTextField rField_;
    private RgbTextField gField_;
    private RgbTextField bField_;
    private JLabel hexLabel_;

    @Override
    void setComponent(ColorComponentID compID, int value) {
        Color c = this.getColorSelectionModel().getSelectedColor();
        try {
            switch (compID) {
                case RED: {
                    c = new Color(value, c.getGreen(), c.getBlue());
                    break;
                }
                case GREEN: {
                    c = new Color(c.getRed(), value, c.getBlue());
                    break;
                }
                case BLUE: {
                    c = new Color(c.getRed(), c.getGreen(), value);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColor(c);
    }

    @Override
    void setComponent(ColorComponentID compID, float value) {
        if (value < 0.0f || value > 1.0f) {
            return;
        }
        int val255 = (int)(value * 255.0f);
        this.setComponent(compID, val255);
    }

    @Override
    public void buildChooser() {
        ColorSelectionModel csmodel = this.getColorSelectionModel();
        ColorChooserPreview colorbox = new ColorChooserPreview(csmodel);
        JLabel rLabel = new JLabel("R", 4);
        JLabel gLabel = new JLabel("G", 4);
        JLabel bLabel = new JLabel("B", 4);
        rLabel.setFont(rLabel.getFont().deriveFont((float)((double)rLabel.getFont().getSize() - 3.0)));
        gLabel.setFont(rLabel.getFont());
        bLabel.setFont(rLabel.getFont());
        this.rField_ = new RgbTextField(ColorComponentID.RED);
        this.gField_ = new RgbTextField(ColorComponentID.GREEN);
        this.bField_ = new RgbTextField(ColorComponentID.BLUE);
        this.hexLabel_ = new JLabel("#FFFFFF", 0);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(8, 5), 2, 4);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(7, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)colorbox, new FGConstraint(1, 0, 1, 3, 0.5, 0.0));
        this.add((Component)rLabel, new FGConstraint(3, 0, 1, 1));
        this.add((Component)new RgbSlider(this, ColorComponentID.RED), new FGConstraint(4, 0, 1, 1));
        this.add((Component)this.rField_, new FGConstraint(5, 0, 1, 1));
        this.add((Component)gLabel, new FGConstraint(3, 1, 1, 1));
        this.add((Component)new RgbSlider(this, ColorComponentID.GREEN), new FGConstraint(4, 1, 1, 1));
        this.add((Component)this.gField_, new FGConstraint(5, 1, 1, 1));
        this.add((Component)bLabel, new FGConstraint(3, 2, 1, 1));
        this.add((Component)new RgbSlider(this, ColorComponentID.BLUE), new FGConstraint(4, 2, 1, 1));
        this.add((Component)this.bField_, new FGConstraint(5, 2, 1, 1));
        this.add((Component)this.hexLabel_, new FGConstraint(1, 3, 6, 1, 0.5, 0.5));
        this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(7, 4, 1, 1));
    }

    @Override
    public void updateChooser() {
        this.rField_.refresh();
        this.gField_.refresh();
        this.bField_.refresh();
        Color c = this.getColorSelectionModel().getSelectedColor();
        String hex = String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
        this.hexLabel_.setText(hex);
        this.repaint();
    }

    @Override
    public String getDisplayName() {
        return "RGB";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    private class RgbTextField
    extends JTextField {
        private final ColorComponentID compID_;

        RgbTextField(ColorComponentID compID) {
            super(4);
            this.setHorizontalAlignment(4);
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() - 2.0)));
            this.compID_ = compID;
            this.setText("255");
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    RgbTextField.this.respond();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.addActionListener(e -> this.respond());
        }

        private void refresh() {
            ColorSelectionModel csm = RgbSliderPanel.this.getColorSelectionModel();
            if (csm == null) {
                return;
            }
            Color c = csm.getSelectedColor();
            switch (this.compID_) {
                case RED: {
                    this.setText(Integer.toString(c.getRed()));
                    break;
                }
                case GREEN: {
                    this.setText(Integer.toString(c.getGreen()));
                    break;
                }
                case BLUE: {
                    this.setText(Integer.toString(c.getBlue()));
                    break;
                }
            }
        }

        private void respond() {
            try {
                RgbSliderPanel.this.setComponent(this.compID_, Integer.parseInt(this.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }
}

