/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.treetable.TreeTable;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final Color GRAY = new Color(152, 152, 152);
    protected static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    protected static final int TRI_SIZE = 18;
    private static final Path2D.Float COLLAPSED_TRIANGLE;
    private static final Path2D.Float EXPANDED_TRIANGLE;
    protected TreeTable ttable_;
    protected TreeTableNode node_;
    private NodeType nodeType_;
    protected boolean hasFocus_;
    protected boolean selected_;
    protected Icon closedIcon_;
    protected Icon leafIcon_;
    protected Icon openIcon_;
    protected int gap_;
    protected int halfGap_;
    protected int iconWidth_;
    protected int leftShift_;

    public TreeTableCellRenderer() {
        this.setHorizontalAlignment(2);
        this.leafIcon_ = UIManager.getIcon("Tree.leafIcon");
        this.closedIcon_ = UIManager.getIcon("Tree.closedIcon");
        this.openIcon_ = UIManager.getIcon("Tree.openIcon");
        this.calculateIconWidth();
        this.gap_ = this.getIconTextGap();
        this.halfGap_ = this.gap_ / 2;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        int textX = this.getTextX(this.ttable_, this.node_, null);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textLen = fm.stringWidth(this.getText());
        int h = super.getPreferredSize().height;
        return new Dimension(ins.left + textX + textLen + ins.right, h);
    }

    public Icon getOpenIcon() {
        return this.openIcon_;
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon_ = newIcon;
        this.calculateIconWidth();
    }

    public Icon getClosedIcon() {
        return this.closedIcon_;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon_ = newIcon;
        this.calculateIconWidth();
    }

    public Icon getLeafIcon() {
        return this.leafIcon_;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon_ = newIcon;
        this.calculateIconWidth();
    }

    private void calculateIconWidth() {
        int w1 = this.leafIcon_ != null ? this.leafIcon_.getIconWidth() : 0;
        int w2 = this.closedIcon_ != null ? this.leafIcon_.getIconWidth() : 0;
        int w3 = this.openIcon_ != null ? this.leafIcon_.getIconWidth() : 0;
        this.iconWidth_ = Math.max(Math.max(w1, w2), w3);
    }

    public void setLeftShift(int shift) {
        this.leftShift_ = shift;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
        this.ttable_ = (TreeTable)table;
        TreeTableModel tmodel = this.ttable_.getTreeTableModel();
        this.node_ = tmodel.getNodeForRow(row);
        String stringValue = this.node_.getName();
        this.setText(stringValue);
        if (this.node_.isLeaf() && !this.node_.getAllowsChildren()) {
            this.nodeType_ = NodeType.LEAF;
            this.setIcon(this.leafIcon_);
        } else {
            boolean isOpen = this.ttable_.isExpanded(row);
            if (isOpen) {
                this.nodeType_ = NodeType.OPEN;
                this.setIcon(this.openIcon_);
            } else {
                this.nodeType_ = NodeType.CLOSED;
                this.setIcon(this.closedIcon_);
            }
        }
        this.selected_ = selected;
        this.hasFocus_ = this.ttable_.hasFocus();
        this.setLeftShift(0);
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Color bgColor = this.getBackground();
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.setBackground(TRANSPARENT);
        super.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        if (icon == null) {
            super.paint(g);
            return;
        }
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.translate((double)(-this.leftShift_), 0.0);
        Insets ins = this.getInsets();
        int uheight = this.getHeight() - ins.top - ins.bottom;
        if (this.nodeType_ == NodeType.OPEN || this.nodeType_ == NodeType.CLOSED) {
            int triX = this.getDisclosureX(this.ttable_, this.node_, icon);
            int triY = (uheight - 18) / 2;
            if (this.selected_ && this.hasFocus_) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(GRAY);
            }
            g2d.translate(ins.left + triX, ins.top + triY);
            if (this.nodeType_ == NodeType.OPEN) {
                g2d.fill(EXPANDED_TRIANGLE);
            } else {
                g2d.fill(COLLAPSED_TRIANGLE);
            }
            g2d.translate(-(ins.left + triX), -(ins.top + triY));
        }
        int iconX = this.getIconX(this.ttable_, this.node_, icon);
        int iconY = (uheight - icon.getIconHeight()) / 2;
        int textX = this.getTextX(this.ttable_, this.node_, icon);
        icon.paintIcon(this, g2d, ins.left + iconX, ins.top + iconY);
        Border inner = BorderFactory.createEmptyBorder(0, textX, 0, 0);
        this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), inner));
        this.setIcon(null);
        super.setBackground(TRANSPARENT);
        super.paintComponent(g2d);
        g2d.dispose();
    }

    public int getDisclosureX(TreeTable ttable, TreeTableNode node, Icon icon) {
        int depth = node.getPath().length - 1;
        if (!ttable.isRootVisible()) {
            --depth;
        }
        if (depth == 0) {
            return 0;
        }
        return 18 + this.halfGap_ + (depth - 1) * (this.iconWidth_ + this.gap_);
    }

    public int getIconX(TreeTable ttable, TreeTableNode node, Icon icon) {
        return this.getDisclosureX(ttable, node, icon) + (18 + this.halfGap_);
    }

    public int getTextX(TreeTable ttable, TreeTableNode node, Icon icon) {
        return this.getIconX(ttable, node, icon) + (this.iconWidth_ + this.gap_);
    }

    static {
        float margin = 2.0f;
        COLLAPSED_TRIANGLE = new Path2D.Float();
        COLLAPSED_TRIANGLE.moveTo(4.0f, 3.0f);
        COLLAPSED_TRIANGLE.lineTo(12.75f, 7.5f);
        COLLAPSED_TRIANGLE.lineTo(4.0f, 12.0f);
        COLLAPSED_TRIANGLE.closePath();
        EXPANDED_TRIANGLE = new Path2D.Float();
        EXPANDED_TRIANGLE.moveTo(3.0f, 4.0f);
        EXPANDED_TRIANGLE.lineTo(12.0f, 4.0f);
        EXPANDED_TRIANGLE.lineTo(7.5f, 11.75f);
        EXPANDED_TRIANGLE.closePath();
    }

    private static enum NodeType {
        LEAF,
        OPEN,
        CLOSED;

    }
}

