/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.dex.writer.DexFileWriter;
import com.googlecode.d2j.jasmin.Jasmins;
import com.googlecode.d2j.map.AsmInheritanceClassVisitor;
import com.googlecode.d2j.map.AutoDetectSourceProcess;
import com.googlecode.d2j.map.DexInheritanceFileVisitor;
import com.googlecode.d2j.map.DexMappingAdapter;
import com.googlecode.d2j.map.InheritanceTree;
import com.googlecode.d2j.map.ProguardMappingParser;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.smali.Smali;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

@BaseCmd.Syntax(cmd="d2j-dex-mapping", syntax="[options] <dex>", desc="remap names in dex file")
public class DexRemapCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="o", longOpt="output", description="the name of the dex file that will be written. The default is out.dex", argName="FILE")
    private File output;
    @BaseCmd.Opt(opt="L", longOpt="library", description="libraries we want load ',' separated")
    private String library;
    @BaseCmd.Opt(opt="C", longOpt="config-file", description="the config file generated by proguard", argName="conf")
    private Path config;

    public static void main(String[] args) {
        new DexRemapCmd().doMain(args);
    }

    void V(String fmt, Object ... args) {
        System.err.println(String.format(fmt, args));
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            System.err.println("ERROR: no file to process");
            return;
        }
        if (this.config == null) {
            System.err.println("ERROR: please set the config file -L,--config-file");
            return;
        }
        if (this.output == null) {
            this.output = new File("out.dex");
        }
        InheritanceTree tree = this.buildRenameTree();
        DexFileWriter fw = new DexFileWriter();
        DexFileVisitor fv = new DexFileVisitor((DexFileVisitor)fw){

            public void visitEnd() {
            }
        };
        fv = new DexMappingAdapter(tree, fv);
        String[] stringArray = this.remainingArgs;
        int n = this.remainingArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.V(">> Remap %s -> %s", s, this.output);
            DexFileReader reader = new DexFileReader(ZipUtil.readDex((File)new File(s)));
            reader.accept(fv);
            ++n2;
        }
        fw.visitEnd();
        byte[] data = fw.toByteArray();
        Files.write(this.output.toPath(), data, new OpenOption[0]);
    }

    private InheritanceTree buildRenameTree() throws IOException {
        InheritanceTree tree = new InheritanceTree();
        AutoDetectSourceProcess processer = new AutoDetectSourceProcess(tree){
            DexInheritanceFileVisitor dfv;
            AsmInheritanceClassVisitor acv;
            {
                this.dfv = new DexInheritanceFileVisitor(inheritanceTree);
                this.acv = new AsmInheritanceClassVisitor(inheritanceTree);
            }

            @Override
            protected void onDex(Path file) throws IOException {
                DexFileReader r = new DexFileReader(ZipUtil.readDex((byte[])Files.readAllBytes(file)));
                r.accept((DexFileVisitor)this.dfv, 28);
            }

            @Override
            protected void onClass(Path file) throws IOException {
                ClassReader cr = new ClassReader(Files.readAllBytes(file));
                cr.accept((ClassVisitor)this.acv, 7);
            }

            @Override
            protected void onJasmin(Path file) throws IOException {
                ClassNode cn = Jasmins.parse((Path)file);
                cn.accept((ClassVisitor)this.acv);
            }

            @Override
            protected void onSmali(Path file) throws IOException {
                Smali smali = new Smali();
                smali.smaliFile(file, (DexFileVisitor)this.dfv);
            }
        };
        String[] stringArray = this.library.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            this.V("<< Load Lib %s", lib);
            tree.updateFrom(lib, true);
            processer.process(lib);
            ++n2;
        }
        stringArray = this.remainingArgs;
        n = this.remainingArgs.length;
        n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.V("<< Load App %s", s);
            tree.updateFrom(s, false);
            processer.process(s);
            ++n2;
        }
        this.V("<< Link for rename", new Object[0]);
        tree.link();
        this.V("<< Apply config file %s", this.config);
        Throwable throwable = null;
        Object var4_7 = null;
        try (BufferedReader configReadre = Files.newBufferedReader(this.config, StandardCharsets.UTF_8);){
            new ProguardMappingParser().parse(configReadre, tree);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tree;
    }
}

