/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.bittorrent.peer;

import java.util.BitSet;
import java.util.StringJoiner;
import lombok.Generated;

public final class PeerFlag {
    private final String ltStdString;
    private final BitSet peerFlags = new BitSet(21);
    private final BitSet peerSourceFlags = new BitSet(6);

    public PeerFlag(String flags) {
        this.parseLibTorrent(flags);
        this.ltStdString = this.toString();
    }

    public PeerFlag(boolean interesting, boolean choked, boolean remoteInterested, boolean remoteChoked, boolean supportsExtensions, boolean outgoingConnection, boolean localConnection, boolean handshake, boolean connecting, boolean onParole, boolean seed, boolean optimisticUnchoke, boolean snubbed, boolean uploadOnly, boolean endGameMode, boolean holePunched, boolean i2pSocket, boolean utpSocket, boolean sslSocket, boolean rc4Encrypted, boolean plainTextEncrypted, boolean fromTracker, boolean fromDHT, boolean fromPEX, boolean fromLSD, boolean fromResumeData, boolean fromIncoming) {
        this.peerFlags.set(0, interesting);
        this.peerFlags.set(1, choked);
        this.peerFlags.set(2, remoteInterested);
        this.peerFlags.set(3, remoteChoked);
        this.peerFlags.set(4, supportsExtensions);
        this.peerFlags.set(5, outgoingConnection);
        this.peerFlags.set(6, localConnection);
        this.peerFlags.set(7, handshake);
        this.peerFlags.set(8, connecting);
        this.peerFlags.set(9, onParole);
        this.peerFlags.set(10, seed);
        this.peerFlags.set(11, optimisticUnchoke);
        this.peerFlags.set(12, snubbed);
        this.peerFlags.set(13, uploadOnly);
        this.peerFlags.set(14, endGameMode);
        this.peerFlags.set(15, holePunched);
        this.peerFlags.set(16, i2pSocket);
        this.peerFlags.set(17, utpSocket);
        this.peerFlags.set(18, sslSocket);
        this.peerFlags.set(19, rc4Encrypted);
        this.peerFlags.set(20, plainTextEncrypted);
        this.peerSourceFlags.set(0, fromTracker);
        this.peerSourceFlags.set(1, fromDHT);
        this.peerSourceFlags.set(2, fromPEX);
        this.peerSourceFlags.set(3, fromLSD);
        this.peerSourceFlags.set(4, fromResumeData);
        this.peerSourceFlags.set(5, fromIncoming);
        this.ltStdString = this.toString();
    }

    public boolean isInteresting() {
        return this.peerFlags.get(0);
    }

    public boolean isChoked() {
        return this.peerFlags.get(1);
    }

    public boolean isRemoteInterested() {
        return this.peerFlags.get(2);
    }

    public boolean isRemoteChoked() {
        return this.peerFlags.get(3);
    }

    public boolean isSupportsExtensions() {
        return this.peerFlags.get(4);
    }

    public boolean isOutgoingConnection() {
        return this.peerFlags.get(5);
    }

    public boolean isLocalConnection() {
        return this.peerFlags.get(6);
    }

    public boolean isHandshake() {
        return this.peerFlags.get(7);
    }

    public boolean isConnecting() {
        return this.peerFlags.get(8);
    }

    public boolean isOnParole() {
        return this.peerFlags.get(9);
    }

    public boolean isSeed() {
        return this.peerFlags.get(10);
    }

    public boolean isOptimisticUnchoke() {
        return this.peerFlags.get(11);
    }

    public boolean isSnubbed() {
        return this.peerFlags.get(12);
    }

    public boolean isUploadOnly() {
        return this.peerFlags.get(13);
    }

    public boolean isEndGameMode() {
        return this.peerFlags.get(14);
    }

    public boolean isHolePunched() {
        return this.peerFlags.get(15);
    }

    public boolean isI2pSocket() {
        return this.peerFlags.get(16);
    }

    public boolean isUtpSocket() {
        return this.peerFlags.get(17);
    }

    public boolean isSslSocket() {
        return this.peerFlags.get(18);
    }

    public boolean isRc4Encrypted() {
        return this.peerFlags.get(19);
    }

    public boolean isPlainTextEncrypted() {
        return this.peerFlags.get(20);
    }

    public boolean isFromTracker() {
        return this.peerSourceFlags.get(0);
    }

    public boolean isFromDHT() {
        return this.peerSourceFlags.get(1);
    }

    public boolean isFromPEX() {
        return this.peerSourceFlags.get(2);
    }

    public boolean isFromLSD() {
        return this.peerSourceFlags.get(3);
    }

    public boolean isFromResumeData() {
        return this.peerSourceFlags.get(4);
    }

    public boolean isFromIncoming() {
        return this.peerSourceFlags.get(5);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(" ");
        if (this.isInteresting()) {
            if (this.isRemoteChoked()) {
                joiner.add("d");
            } else {
                joiner.add("D");
            }
        }
        if (this.isRemoteInterested()) {
            if (this.isChoked()) {
                joiner.add("u");
            } else {
                joiner.add("U");
            }
        }
        if (!this.isRemoteChoked() && !this.isInteresting()) {
            joiner.add("K");
        }
        if (!this.isChoked() && !this.isRemoteInterested()) {
            joiner.add("?");
        }
        if (this.isOptimisticUnchoke()) {
            joiner.add("O");
        }
        if (this.isSnubbed()) {
            joiner.add("S");
        }
        if (!this.isLocalConnection()) {
            joiner.add("I");
        }
        if (this.isFromDHT()) {
            joiner.add("H");
        }
        if (this.isFromPEX()) {
            joiner.add("X");
        }
        if (this.isFromLSD()) {
            joiner.add("L");
        }
        if (this.isRc4Encrypted()) {
            joiner.add("E");
        }
        if (this.isPlainTextEncrypted()) {
            joiner.add("e");
        }
        if (this.isUtpSocket()) {
            joiner.add("P");
        }
        return joiner.toString();
    }

    public void parseLibTorrent(String flags) {
        boolean interesting = false;
        boolean remoteChoked = true;
        boolean remoteInterested = false;
        boolean choked = true;
        boolean optimisticUnchoke = false;
        boolean snubbed = false;
        boolean localConnection = true;
        boolean fromDHT = false;
        boolean fromPEX = false;
        boolean fromLSD = false;
        boolean rc4Encrypted = false;
        boolean plainTextEncrypted = false;
        boolean utpSocket = false;
        block17: for (char c : flags.toCharArray()) {
            switch (c) {
                case 'd': {
                    interesting = true;
                    remoteChoked = true;
                    continue block17;
                }
                case 'D': {
                    interesting = true;
                    remoteChoked = false;
                    continue block17;
                }
                case 'u': {
                    remoteInterested = true;
                    choked = true;
                    continue block17;
                }
                case 'U': {
                    remoteInterested = true;
                    choked = false;
                    continue block17;
                }
                case 'K': {
                    remoteChoked = false;
                    interesting = false;
                    continue block17;
                }
                case '?': {
                    choked = false;
                    remoteInterested = false;
                    continue block17;
                }
                case 'O': {
                    optimisticUnchoke = true;
                    continue block17;
                }
                case 'S': {
                    snubbed = true;
                    continue block17;
                }
                case 'I': {
                    localConnection = false;
                    continue block17;
                }
                case 'H': {
                    fromDHT = true;
                    continue block17;
                }
                case 'X': {
                    fromPEX = true;
                    continue block17;
                }
                case 'L': {
                    fromLSD = true;
                    continue block17;
                }
                case 'E': {
                    rc4Encrypted = true;
                    continue block17;
                }
                case 'e': {
                    plainTextEncrypted = true;
                    continue block17;
                }
                case 'P': {
                    utpSocket = true;
                }
            }
        }
        this.peerFlags.set(0, interesting);
        this.peerFlags.set(1, choked);
        this.peerFlags.set(2, remoteInterested);
        this.peerFlags.set(3, remoteChoked);
        this.peerFlags.set(6, localConnection);
        this.peerFlags.set(11, optimisticUnchoke);
        this.peerFlags.set(12, snubbed);
        this.peerFlags.set(17, utpSocket);
        this.peerFlags.set(19, rc4Encrypted);
        this.peerFlags.set(20, plainTextEncrypted);
        this.peerSourceFlags.set(1, fromDHT);
        this.peerSourceFlags.set(2, fromPEX);
        this.peerSourceFlags.set(3, fromLSD);
    }

    @Generated
    public static PeerFlagBuilder builder() {
        return new PeerFlagBuilder();
    }

    @Generated
    public String getLtStdString() {
        return this.ltStdString;
    }

    @Generated
    public BitSet getPeerFlags() {
        return this.peerFlags;
    }

    @Generated
    public BitSet getPeerSourceFlags() {
        return this.peerSourceFlags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerFlag)) {
            return false;
        }
        PeerFlag other = (PeerFlag)o;
        String this$ltStdString = this.getLtStdString();
        String other$ltStdString = other.getLtStdString();
        if (this$ltStdString == null ? other$ltStdString != null : !this$ltStdString.equals(other$ltStdString)) {
            return false;
        }
        BitSet this$peerFlags = this.getPeerFlags();
        BitSet other$peerFlags = other.getPeerFlags();
        if (this$peerFlags == null ? other$peerFlags != null : !((Object)this$peerFlags).equals(other$peerFlags)) {
            return false;
        }
        BitSet this$peerSourceFlags = this.getPeerSourceFlags();
        BitSet other$peerSourceFlags = other.getPeerSourceFlags();
        return !(this$peerSourceFlags == null ? other$peerSourceFlags != null : !((Object)this$peerSourceFlags).equals(other$peerSourceFlags));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ltStdString = this.getLtStdString();
        result = result * 59 + ($ltStdString == null ? 43 : $ltStdString.hashCode());
        BitSet $peerFlags = this.getPeerFlags();
        result = result * 59 + ($peerFlags == null ? 43 : ((Object)$peerFlags).hashCode());
        BitSet $peerSourceFlags = this.getPeerSourceFlags();
        result = result * 59 + ($peerSourceFlags == null ? 43 : ((Object)$peerSourceFlags).hashCode());
        return result;
    }

    @Generated
    public static class PeerFlagBuilder {
        @Generated
        private boolean interesting;
        @Generated
        private boolean choked;
        @Generated
        private boolean remoteInterested;
        @Generated
        private boolean remoteChoked;
        @Generated
        private boolean supportsExtensions;
        @Generated
        private boolean outgoingConnection;
        @Generated
        private boolean localConnection;
        @Generated
        private boolean handshake;
        @Generated
        private boolean connecting;
        @Generated
        private boolean onParole;
        @Generated
        private boolean seed;
        @Generated
        private boolean optimisticUnchoke;
        @Generated
        private boolean snubbed;
        @Generated
        private boolean uploadOnly;
        @Generated
        private boolean endGameMode;
        @Generated
        private boolean holePunched;
        @Generated
        private boolean i2pSocket;
        @Generated
        private boolean utpSocket;
        @Generated
        private boolean sslSocket;
        @Generated
        private boolean rc4Encrypted;
        @Generated
        private boolean plainTextEncrypted;
        @Generated
        private boolean fromTracker;
        @Generated
        private boolean fromDHT;
        @Generated
        private boolean fromPEX;
        @Generated
        private boolean fromLSD;
        @Generated
        private boolean fromResumeData;
        @Generated
        private boolean fromIncoming;

        @Generated
        PeerFlagBuilder() {
        }

        @Generated
        public PeerFlagBuilder interesting(boolean interesting) {
            this.interesting = interesting;
            return this;
        }

        @Generated
        public PeerFlagBuilder choked(boolean choked) {
            this.choked = choked;
            return this;
        }

        @Generated
        public PeerFlagBuilder remoteInterested(boolean remoteInterested) {
            this.remoteInterested = remoteInterested;
            return this;
        }

        @Generated
        public PeerFlagBuilder remoteChoked(boolean remoteChoked) {
            this.remoteChoked = remoteChoked;
            return this;
        }

        @Generated
        public PeerFlagBuilder supportsExtensions(boolean supportsExtensions) {
            this.supportsExtensions = supportsExtensions;
            return this;
        }

        @Generated
        public PeerFlagBuilder outgoingConnection(boolean outgoingConnection) {
            this.outgoingConnection = outgoingConnection;
            return this;
        }

        @Generated
        public PeerFlagBuilder localConnection(boolean localConnection) {
            this.localConnection = localConnection;
            return this;
        }

        @Generated
        public PeerFlagBuilder handshake(boolean handshake) {
            this.handshake = handshake;
            return this;
        }

        @Generated
        public PeerFlagBuilder connecting(boolean connecting) {
            this.connecting = connecting;
            return this;
        }

        @Generated
        public PeerFlagBuilder onParole(boolean onParole) {
            this.onParole = onParole;
            return this;
        }

        @Generated
        public PeerFlagBuilder seed(boolean seed) {
            this.seed = seed;
            return this;
        }

        @Generated
        public PeerFlagBuilder optimisticUnchoke(boolean optimisticUnchoke) {
            this.optimisticUnchoke = optimisticUnchoke;
            return this;
        }

        @Generated
        public PeerFlagBuilder snubbed(boolean snubbed) {
            this.snubbed = snubbed;
            return this;
        }

        @Generated
        public PeerFlagBuilder uploadOnly(boolean uploadOnly) {
            this.uploadOnly = uploadOnly;
            return this;
        }

        @Generated
        public PeerFlagBuilder endGameMode(boolean endGameMode) {
            this.endGameMode = endGameMode;
            return this;
        }

        @Generated
        public PeerFlagBuilder holePunched(boolean holePunched) {
            this.holePunched = holePunched;
            return this;
        }

        @Generated
        public PeerFlagBuilder i2pSocket(boolean i2pSocket) {
            this.i2pSocket = i2pSocket;
            return this;
        }

        @Generated
        public PeerFlagBuilder utpSocket(boolean utpSocket) {
            this.utpSocket = utpSocket;
            return this;
        }

        @Generated
        public PeerFlagBuilder sslSocket(boolean sslSocket) {
            this.sslSocket = sslSocket;
            return this;
        }

        @Generated
        public PeerFlagBuilder rc4Encrypted(boolean rc4Encrypted) {
            this.rc4Encrypted = rc4Encrypted;
            return this;
        }

        @Generated
        public PeerFlagBuilder plainTextEncrypted(boolean plainTextEncrypted) {
            this.plainTextEncrypted = plainTextEncrypted;
            return this;
        }

        @Generated
        public PeerFlagBuilder fromTracker(boolean fromTracker) {
            this.fromTracker = fromTracker;
            return this;
        }

        @Generated
        public PeerFlagBuilder fromDHT(boolean fromDHT) {
            this.fromDHT = fromDHT;
            return this;
        }

        @Generated
        public PeerFlagBuilder fromPEX(boolean fromPEX) {
            this.fromPEX = fromPEX;
            return this;
        }

        @Generated
        public PeerFlagBuilder fromLSD(boolean fromLSD) {
            this.fromLSD = fromLSD;
            return this;
        }

        @Generated
        public PeerFlagBuilder fromResumeData(boolean fromResumeData) {
            this.fromResumeData = fromResumeData;
            return this;
        }

        @Generated
        public PeerFlagBuilder fromIncoming(boolean fromIncoming) {
            this.fromIncoming = fromIncoming;
            return this;
        }

        @Generated
        public PeerFlag build() {
            return new PeerFlag(this.interesting, this.choked, this.remoteInterested, this.remoteChoked, this.supportsExtensions, this.outgoingConnection, this.localConnection, this.handshake, this.connecting, this.onParole, this.seed, this.optimisticUnchoke, this.snubbed, this.uploadOnly, this.endGameMode, this.holePunched, this.i2pSocket, this.utpSocket, this.sslSocket, this.rc4Encrypted, this.plainTextEncrypted, this.fromTracker, this.fromDHT, this.fromPEX, this.fromLSD, this.fromResumeData, this.fromIncoming);
        }

        @Generated
        public String toString() {
            return "PeerFlag.PeerFlagBuilder(interesting=" + this.interesting + ", choked=" + this.choked + ", remoteInterested=" + this.remoteInterested + ", remoteChoked=" + this.remoteChoked + ", supportsExtensions=" + this.supportsExtensions + ", outgoingConnection=" + this.outgoingConnection + ", localConnection=" + this.localConnection + ", handshake=" + this.handshake + ", connecting=" + this.connecting + ", onParole=" + this.onParole + ", seed=" + this.seed + ", optimisticUnchoke=" + this.optimisticUnchoke + ", snubbed=" + this.snubbed + ", uploadOnly=" + this.uploadOnly + ", endGameMode=" + this.endGameMode + ", holePunched=" + this.holePunched + ", i2pSocket=" + this.i2pSocket + ", utpSocket=" + this.utpSocket + ", sslSocket=" + this.sslSocket + ", rc4Encrypted=" + this.rc4Encrypted + ", plainTextEncrypted=" + this.plainTextEncrypted + ", fromTracker=" + this.fromTracker + ", fromDHT=" + this.fromDHT + ", fromPEX=" + this.fromPEX + ", fromLSD=" + this.fromLSD + ", fromResumeData=" + this.fromResumeData + ", fromIncoming=" + this.fromIncoming + ")";
        }
    }
}

