/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.database.DatabaseHelper;
import com.ghostchu.peerbanhelper.database.TranslationComponentPersistener;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.lab.Experiments;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.jdbc.JdbcSingleConnectionSource;
import com.j256.ormlite.jdbc.db.SqliteDatabaseType;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Database {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final File sqliteDb;
    private final File dbMaintenanceFile;
    private final Laboratory laboratory;
    private JdbcSingleConnectionSource dataSource;
    private DatabaseHelper helper;

    public Database(Laboratory laboratory) throws SQLException {
        this.laboratory = laboratory;
        File databaseDirectory = new File(Main.getDataDirectory(), "persist");
        if (!databaseDirectory.exists()) {
            databaseDirectory.mkdirs();
        }
        this.sqliteDb = new File(databaseDirectory, "peerbanhelper.db");
        this.dbMaintenanceFile = new File(databaseDirectory, "peerbanhelper.db.maintenance");
        this.registerPersisters();
        this.setupDatabase(this.sqliteDb);
    }

    @Bean
    public ConnectionSource connectionSource() {
        return this.dataSource;
    }

    private void registerPersisters() {
        DataPersisterManager.registerDataPersisters((DataPersister[])new DataPersister[]{TranslationComponentPersistener.getSingleton()});
    }

    private long getLastMaintenanceTime() {
        if (!this.dbMaintenanceFile.exists()) {
            return 0L;
        }
        try {
            return Long.parseLong(Files.readString(this.dbMaintenanceFile.toPath()));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void setLastMaintenanceTime(long time) {
        try {
            Files.writeString(this.dbMaintenanceFile.toPath(), (CharSequence)String.valueOf(time), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupDatabase(File file) throws SQLException {
        Connection rawConnection;
        block20: {
            rawConnection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(file));
            if (ExternalSwitch.parse("pbh.database.disableSQLitePragmaSettings") == null) {
                try (Statement stmt = rawConnection.createStatement();){
                    stmt.executeUpdate("PRAGMA synchronous = NORMAL");
                    stmt.executeUpdate("PRAGMA journal_mode = WAL");
                    stmt.executeUpdate("PRAGMA mmap_size = 0");
                    stmt.executeUpdate("PRAGMA soft_heap_limit = " + ExternalSwitch.parseLong("pbh.database.sqliteSoftHeapLimitBytes", 0x2000000L));
                    stmt.executeUpdate("PRAGMA OPTIMIZE");
                    try {
                        if (System.currentTimeMillis() - this.getLastMaintenanceTime() < Duration.ofDays(Main.getMainConfig().getInt("persist.vacuum-interval-days")).toMillis() || ExternalSwitch.parse("pbh.database.disableSQLiteVacuum") != null || !this.laboratory.isExperimentActivated(Experiments.SQLITE_VACUUM.getExperiment())) break block20;
                        log.info(TextManager.tlUI(Lang.SQLITE_VACUUM_BACKUP, new Object[0]));
                        File outputBackup = new File(file.getParentFile(), file.getName() + ".bak.gz");
                        log.info(TextManager.tlUI(Lang.SQLITE_VACUUM_BACKUP_COMPLETED, new Object[0]));
                        for (int i = 0; i < 10; ++i) {
                            log.info(TextManager.tlUI(Lang.SQLITE_VACUUM_IN_PROGRESS, new Object[0]));
                        }
                        try {
                            this.backupDatabase(file, outputBackup);
                            long fileSize = file.length();
                            stmt.executeUpdate("VACUUM;");
                            long newFileSize = file.length();
                            log.info(TextManager.tlUI(Lang.SQLITE_VACUUM_SUCCESS, MsgUtil.humanReadableByteCountBin(fileSize), MsgUtil.humanReadableByteCountBin(newFileSize)));
                        }
                        catch (IOException e) {
                            log.warn(TextManager.tlUI(Lang.SQLITE_VACUUM_BACKUP_FAILED, new Object[0]), (Throwable)e);
                        }
                        finally {
                            outputBackup.delete();
                        }
                    }
                    catch (Exception e) {
                        log.warn(TextManager.tlUI(Lang.UNABLE_SET_SQLITE_OPTIMIZED_PRAGMA, new Object[0]), (Throwable)e);
                    }
                    finally {
                        this.setLastMaintenanceTime(System.currentTimeMillis());
                    }
                }
                catch (Exception e) {
                    log.warn(TextManager.tlUI(Lang.UNABLE_SET_SQLITE_OPTIMIZED_PRAGMA, new Object[0]), (Throwable)e);
                }
            }
        }
        this.dataSource = new JdbcSingleConnectionSource("jdbc:sqlite:" + String.valueOf(file), (DatabaseType)new SqliteDatabaseType(), rawConnection);
        this.helper = new DatabaseHelper(this);
    }

    private void backupDatabase(File input, File output) throws IOException {
        try (FileInputStream filein = new FileInputStream(input);
             FileOutputStream fileout = new FileOutputStream(output);){
            MiscUtil.gzip(filein, fileout);
        }
    }

    public void close() {
        this.dataSource.closeQuietly();
    }

    @Generated
    public File getSqliteDb() {
        return this.sqliteDb;
    }

    @Generated
    public File getDbMaintenanceFile() {
        return this.dbMaintenanceFile;
    }

    @Generated
    public Laboratory getLaboratory() {
        return this.laboratory;
    }

    @Generated
    public JdbcSingleConnectionSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public DatabaseHelper getHelper() {
        return this.helper;
    }
}

