/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsEntity;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsTrackEntity;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerConnectionMetricsDTO;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeerConnectionMetricDao
extends AbstractPBHDao<PeerConnectionMetricsEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionMetricDao.class);

    public PeerConnectionMetricDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, PeerConnectionMetricsEntity.class);
    }

    public long getGlobalTotalConnectionsCount(@NotNull Timestamp startAt, @NotNull Timestamp endAt) {
        long total = 0L;
        try {
            Where where = this.queryBuilder().where();
            where.between("timeframeAt", (Object)startAt, (Object)endAt);
            List entities = where.query();
            for (PeerConnectionMetricsEntity entity : entities) {
                total += entity.getTotalConnections();
            }
        }
        catch (Exception e) {
            log.error("Failed to query global total connections count between {} and {}", new Object[]{startAt, endAt, e});
        }
        return total;
    }

    public List<PeerConnectionMetricsDTO> getMetricsSince(@NotNull Timestamp sinceAt, @NotNull Timestamp untilAt, @Nullable String downloader) {
        ArrayList<PeerConnectionMetricsDTO> result = new ArrayList<PeerConnectionMetricsDTO>();
        try {
            Where where = this.queryBuilder().where();
            where.between("timeframeAt", (Object)sinceAt, (Object)untilAt);
            if (downloader != null && !downloader.isBlank()) {
                where.and().eq("downloader", (Object)downloader);
            }
            List entities = where.query();
            HashMap<Timestamp, PeerConnectionMetricsDTO> mergedMap = new HashMap<Timestamp, PeerConnectionMetricsDTO>();
            for (PeerConnectionMetricsEntity entity : entities) {
                Timestamp timeframe = entity.getTimeframeAt();
                PeerConnectionMetricsDTO dto = PeerConnectionMetricsDTO.from(entity);
                if (mergedMap.containsKey(timeframe)) {
                    PeerConnectionMetricsDTO existing = (PeerConnectionMetricsDTO)mergedMap.get(timeframe);
                    this.mergeMetricsDTO(existing, dto);
                    continue;
                }
                mergedMap.put(timeframe, dto);
            }
            result = new ArrayList(mergedMap.values());
            result.sort((a, b) -> Long.compare(b.getKey(), a.getKey()));
        }
        catch (SQLException e) {
            log.error("Failed to query peer connection metrics since {}", (Object)sinceAt, (Object)e);
        }
        return result;
    }

    private void mergeMetricsDTO(PeerConnectionMetricsDTO target, PeerConnectionMetricsDTO source) {
        target.setTotalConnections(target.getTotalConnections() + source.getTotalConnections());
        target.setIncomingConnections(target.getIncomingConnections() + source.getIncomingConnections());
        target.setRemoteRefuseTransferToClient(target.getRemoteRefuseTransferToClient() + source.getRemoteRefuseTransferToClient());
        target.setRemoteAcceptTransferToClient(target.getRemoteAcceptTransferToClient() + source.getRemoteAcceptTransferToClient());
        target.setLocalRefuseTransferToPeer(target.getLocalRefuseTransferToPeer() + source.getLocalRefuseTransferToPeer());
        target.setLocalAcceptTransferToPeer(target.getLocalAcceptTransferToPeer() + source.getLocalAcceptTransferToPeer());
        target.setLocalNotInterested(target.getLocalNotInterested() + source.getLocalNotInterested());
        target.setQuestionStatus(target.getQuestionStatus() + source.getQuestionStatus());
        target.setOptimisticUnchoke(target.getOptimisticUnchoke() + source.getOptimisticUnchoke());
        target.setFromDHT(target.getFromDHT() + source.getFromDHT());
        target.setFromPEX(target.getFromPEX() + source.getFromPEX());
        target.setFromLSD(target.getFromLSD() + source.getFromLSD());
        target.setFromTrackerOrOther(target.getFromTrackerOrOther() + source.getFromTrackerOrOther());
        target.setRc4Encrypted(target.getRc4Encrypted() + source.getRc4Encrypted());
        target.setPlainTextEncrypted(target.getPlainTextEncrypted() + source.getPlainTextEncrypted());
        target.setUtpSocket(target.getUtpSocket() + source.getUtpSocket());
        target.setTcpSocket(target.getTcpSocket() + source.getTcpSocket());
    }

    public synchronized void saveAggregating(List<PeerConnectionMetricsEntity> buffer, boolean overwrite) {
        for (PeerConnectionMetricsEntity peerConnectionMetricsEntity : buffer) {
            try {
                PeerConnectionMetricsEntity entityInDb = (PeerConnectionMetricsEntity)this.queryBuilder().where().eq("timeframeAt", (Object)peerConnectionMetricsEntity.getTimeframeAt()).and().eq("downloader", (Object)peerConnectionMetricsEntity.getDownloader()).queryForFirst();
                if (entityInDb != null) {
                    if (overwrite) {
                        peerConnectionMetricsEntity.setId(entityInDb.getId());
                    } else {
                        entityInDb.merge(peerConnectionMetricsEntity);
                    }
                } else {
                    entityInDb = peerConnectionMetricsEntity;
                }
                this.createOrUpdate(entityInDb);
            }
            catch (SQLException e) {
                log.error("Updating peer connection metrics failed for downloader {} at {}", new Object[]{peerConnectionMetricsEntity.getDownloader(), peerConnectionMetricsEntity.getTimeframeAt(), e});
            }
        }
    }

    public synchronized List<PeerConnectionMetricsEntity> aggregating(@NotNull List<PeerConnectionMetricsTrackEntity> fullPeerSessions) {
        ArrayList<PeerConnectionMetricsEntity> buffer = new ArrayList<PeerConnectionMetricsEntity>();
        for (PeerConnectionMetricsTrackEntity peerSessionEntity : fullPeerSessions) {
            PeerConnectionMetricsEntity entity = this.findOrCreateBuffer(buffer, peerSessionEntity.getTimeframeAt(), peerSessionEntity.getDownloader());
            entity.setTotalConnections(entity.getTotalConnections() + 1L);
            String flags = peerSessionEntity.getLastFlags();
            if (flags == null) continue;
            PeerFlag f = new PeerFlag(flags);
            if (!f.isLocalConnection()) {
                entity.setIncomingConnections(entity.getIncomingConnections() + 1L);
            }
            if (f.isInteresting() && f.isRemoteChoked()) {
                entity.setRemoteRefuseTransferToClient(entity.getRemoteRefuseTransferToClient() + 1L);
            }
            if (f.isInteresting() && !f.isRemoteChoked()) {
                entity.setRemoteAcceptTransferToClient(entity.getRemoteAcceptTransferToClient() + 1L);
            }
            if (f.isRemoteInterested() && f.isChoked()) {
                entity.setLocalRefuseTransferToPeer(entity.getLocalRefuseTransferToPeer() + 1L);
            }
            if (f.isRemoteInterested() && !f.isChoked()) {
                entity.setLocalAcceptTransferToPeer(entity.getLocalAcceptTransferToPeer() + 1L);
            }
            if (!f.isRemoteChoked() && !f.isInteresting()) {
                entity.setLocalNotInterested(entity.getLocalNotInterested() + 1L);
            }
            if (!f.isChoked() && !f.isRemoteInterested()) {
                entity.setQuestionStatus(entity.getQuestionStatus() + 1L);
            }
            if (f.isOptimisticUnchoke()) {
                entity.setOptimisticUnchoke(entity.getOptimisticUnchoke() + 1L);
            }
            if (f.isFromDHT()) {
                entity.setFromDHT(entity.getFromDHT() + 1L);
            } else if (f.isFromPEX()) {
                entity.setFromPEX(entity.getFromPEX() + 1L);
            } else if (f.isFromLSD()) {
                entity.setFromLSD(entity.getFromLSD() + 1L);
            } else {
                entity.setFromTrackerOrOther(entity.getFromTrackerOrOther() + 1L);
            }
            if (f.isRc4Encrypted()) {
                entity.setRc4Encrypted(entity.getRc4Encrypted() + 1L);
            }
            if (f.isPlainTextEncrypted()) {
                entity.setPlainTextEncrypted(entity.getPlainTextEncrypted() + 1L);
            }
            if (f.isUtpSocket()) {
                entity.setUtpSocket(entity.getUtpSocket() + 1L);
                continue;
            }
            entity.setTcpSocket(entity.getTcpSocket() + 1L);
        }
        return buffer;
    }

    @NotNull
    private PeerConnectionMetricsEntity findOrCreateBuffer(List<PeerConnectionMetricsEntity> buffer, Timestamp timestamp, String downloader) {
        for (PeerConnectionMetricsEntity peerConnectionMetricsEntity : buffer) {
            if (!peerConnectionMetricsEntity.getTimeframeAt().equals(timestamp) || !peerConnectionMetricsEntity.getDownloader().equals(downloader)) continue;
            return peerConnectionMetricsEntity;
        }
        PeerConnectionMetricsEntity entity = new PeerConnectionMetricsEntity();
        entity.setTimeframeAt(timestamp);
        entity.setDownloader(downloader);
        buffer.add(entity);
        return entity;
    }

    public void removeOutdatedData(@NotNull Timestamp beforeAt) {
        try {
            DeleteBuilder deleteBuilder = this.deleteBuilder();
            deleteBuilder.where().le("timeframeAt", (Object)beforeAt);
            int deleted = deleteBuilder.delete();
            log.debug("Removed {} outdated peer connection metrics data before {}", (Object)deleted, (Object)beforeAt);
        }
        catch (SQLException e) {
            log.error("Failed to remove outdated peer connection metrics data before {}", (Object)beforeAt, (Object)e);
        }
    }
}

