/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PushWrapperDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.push.PushManagerImpl;
import com.ghostchu.peerbanhelper.util.push.PushProvider;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHPushController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHPushController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private PushManagerImpl pushManager;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Push";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-push";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/push", this::handlePushProviderList, new RouteRole[]{Role.USER_READ})).put("/api/push", this::handlePushProviderPut, new RouteRole[]{Role.USER_WRITE})).patch("/api/push/{pushName}", ctx -> this.handlePushProviderPatch(ctx, ctx.pathParam("pushName")), new RouteRole[]{Role.USER_WRITE})).post("/api/push/test", this::handlePushProviderTest, new RouteRole[]{Role.USER_WRITE})).delete("/api/push/{pushName}", ctx -> this.handlePushProviderDelete(ctx, ctx.pathParam("pushName")), new RouteRole[]{Role.USER_WRITE});
    }

    private void handlePushProviderPut(Context ctx) {
        JsonObject draftPushProvider = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        String name = draftPushProvider.get("name").getAsString();
        if (name.contains(".")) {
            throw new IllegalArgumentException("Illegal character (.) in name: " + name);
        }
        JsonObject config = draftPushProvider.get("config").getAsJsonObject();
        PushProvider pushProvider = this.pushManager.createPushProvider(name, draftPushProvider.get("type").getAsString(), config);
        if (pushProvider == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_ADD_FAILURE, new Object[0]), null));
            return;
        }
        if (this.pushManager.addPushProvider(pushProvider)) {
            ctx.status(HttpStatus.CREATED);
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_CREATED, new Object[0]), null));
        } else {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_CREATION_FAILED_ALREADY_EXISTS, new Object[0]), null));
        }
        try {
            this.pushManager.savePushProviders();
        }
        catch (IOException e) {
            log.error("Internal server error, unable to create push provider due an I/O exception", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_CREATION_FAILED_IO_EXCEPTION, new Object[0]), null));
        }
    }

    private void handlePushProviderPatch(Context ctx, String pushProviderName) {
        JsonObject draftProvider = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        String name = draftProvider.get("name").getAsString();
        if (name.contains(".")) {
            throw new IllegalArgumentException("Illegal character (.) in name: " + name);
        }
        JsonObject config = draftProvider.get("config").getAsJsonObject();
        PushProvider pushProvider = this.pushManager.createPushProvider(name, draftProvider.get("type").getAsString(), config);
        if (pushProvider == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_UPDATE_FAILURE, new Object[0]), null));
            return;
        }
        List.copyOf(this.pushManager.getProviderList()).stream().filter(d -> d.getName().equals(pushProviderName)).forEach(d -> this.pushManager.removePushProvider((PushProvider)d));
        if (this.pushManager.addPushProvider(pushProvider)) {
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_UPDATED, new Object[0]), null));
        } else {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_UPDATE_FAILURE_ALREADY_EXISTS, new Object[0]), null));
        }
        try {
            this.pushManager.savePushProviders();
        }
        catch (IOException e) {
            log.error("Internal server error, unable to update push manager due an I/O exception", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_CREATION_FAILED_IO_EXCEPTION, new Object[0]), null));
        }
    }

    private void handlePushProviderTest(Context ctx) {
        JsonObject draftPushProvider = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        String name = draftPushProvider.get("name").getAsString();
        if (name.contains(".")) {
            throw new IllegalArgumentException("Illegal character (.) in name: " + name);
        }
        JsonObject config = draftPushProvider.get("config").getAsJsonObject();
        PushProvider pushProvider = this.pushManager.createPushProvider(name, draftPushProvider.get("type").getAsString(), config);
        if (pushProvider == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_ADD_FAILURE, new Object[0]), null));
            return;
        }
        try {
            boolean testResult = pushProvider.push(TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_TEST_TITLE, new Object[0]), TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_TEST_DESCRIPTION, name, pushProvider.getConfigType()));
            if (testResult) {
                ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_TEST_OK, new Object[0]), null));
            } else {
                ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_TEST_FAILED, name, pushProvider.getConfigType()), null));
            }
        }
        catch (Exception e) {
            log.error("Validate PushProvider failed", (Throwable)e);
            ctx.json((Object)new StdResp(false, e.getMessage(), null));
        }
    }

    private void handlePushProviderDelete(Context ctx, String pushProviderName) {
        Optional<PushProvider> selected = this.pushManager.getProviderList().stream().filter(d -> d.getName().equals(pushProviderName)).findFirst();
        if (selected.isEmpty()) {
            ctx.status(HttpStatus.NOT_FOUND);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_REMOVE_NOT_EXISTS, new Object[0]), null));
            return;
        }
        PushProvider pushProvider = selected.get();
        this.pushManager.removePushProvider(pushProvider);
        try {
            this.pushManager.savePushProviders();
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.PUSH_PROVIDER_API_REMOVE_SAVED, new Object[0]), null));
        }
        catch (IOException e) {
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, e.getClass().getName() + ": " + e.getMessage(), null));
        }
    }

    private void handlePushProviderList(@NotNull Context ctx) {
        List<PushWrapperDTO> pushProviders = this.pushManager.getProviderList().stream().map(d -> new PushWrapperDTO(d.getName(), d.getConfigType(), d.saveJson())).toList();
        ctx.json((Object)new StdResp(true, null, pushProviders));
    }

    @Override
    public void onDisable() {
    }
}

