/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform.win32.workingset.jna;

import com.ghostchu.peerbanhelper.platform.win32.workingset.jna.WindowsWorkingSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingSetManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(WorkingSetManagerFactory.class);
    private static volatile WindowsWorkingSetManager instance;
    private static final boolean isWindows;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WindowsWorkingSetManager getInstance() {
        if (!isWindows) {
            return null;
        }
        if (instance != null) return instance;
        Class<WorkingSetManagerFactory> clazz = WorkingSetManagerFactory.class;
        synchronized (WorkingSetManagerFactory.class) {
            if (instance != null) return instance;
            try {
                instance = new WindowsWorkingSetManager();
            }
            catch (Exception e) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            return instance;
        }
    }

    public static boolean isSupported() {
        return isWindows;
    }

    public static boolean trimMemory() {
        WindowsWorkingSetManager manager = WorkingSetManagerFactory.getInstance();
        if (manager != null) {
            return manager.trimMemory();
        }
        return false;
    }

    public static boolean compressMemory(long targetSizeBytes) {
        WindowsWorkingSetManager manager = WorkingSetManagerFactory.getInstance();
        if (manager != null) {
            return manager.compressMemory(targetSizeBytes);
        }
        return false;
    }

    public static boolean compressMemory() {
        return WorkingSetManagerFactory.compressMemory(0x800000L);
    }

    static {
        String osName = System.getProperty("os.name", "").toLowerCase();
        isWindows = osName.contains("windows");
    }
}

