/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.software.os.InternetProtocolStats;

@Component
public class DownloaderDiscovery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloaderDiscovery.class);
    private final OkHttpClient httpClient;
    private final SystemInfo systemInfo;

    public DownloaderDiscovery(HTTPUtil hTTPUtil, SystemInfo systemInfo) {
        this.systemInfo = systemInfo;
        this.httpClient = hTTPUtil.newBuilder().callTimeout(8L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("User-Agent", "PeerBanHelper-DownloaderDiscovery/1.0 " + Main.getUserAgent());
            return chain.proceed(requestBuilder.build());
        }).build();
    }

    public CompletableFuture<List<DiscoveredDownloader>> scan() {
        return CompletableFuture.supplyAsync(() -> {
            List found = Collections.synchronizedList(new ArrayList());
            List<InternetProtocolStats.IPConnection> listenConnections = this.systemInfo.getOperatingSystem().getInternetProtocolStats().getConnections().stream().filter(conn -> {
                String type = conn.getType();
                return type.startsWith("tcp");
            }).filter(conn -> conn.getState() == InternetProtocolStats.TcpState.LISTEN).toList();
            log.debug("Found {} listen connections: {}", (Object)listenConnections.size(), listenConnections);
            Semaphore semaphore = new Semaphore(64);
            try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                for (InternetProtocolStats.IPConnection listenConnection : listenConnections) {
                    executor.submit(() -> {
                        try {
                            semaphore.acquire();
                            String inetAddress = IPAddressUtil.adaptIP(listenConnection.getLocalAddress());
                            DiscoveredDownloader scanResult = this.checkDownloader(inetAddress, listenConnection.getLocalPort(), listenConnection.getowningProcessId());
                            if (scanResult != null) {
                                found.add(scanResult);
                            }
                        }
                        catch (Exception e) {
                            log.debug("Failed to get downloader information from {}:{}", new Object[]{listenConnection.getLocalAddress(), listenConnection.getLocalPort(), e});
                        }
                        finally {
                            semaphore.release();
                        }
                    });
                }
            }
            return found.stream().distinct().toList();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public DiscoveredDownloader checkDownloader(String host, int port, int pid) {
        Request request = new Request.Builder().url("http://" + host + ":" + port).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String auth;
            String server = response.header("Server");
            if (server != null) {
                if (server.contains("Transmission")) {
                    DiscoveredDownloader discoveredDownloader = new DiscoveredDownloader(host, port, "transmission", pid);
                    return discoveredDownloader;
                }
                if (server.contains("PeerBanHelper-BiglyBT-Adapter")) {
                    DiscoveredDownloader discoveredDownloader = new DiscoveredDownloader(host, port, "biglybt", pid);
                    return discoveredDownloader;
                }
            }
            if ((auth = response.header("WWW-Authenticate")) != null && auth.contains("BitComet Remote Login")) {
                DiscoveredDownloader discoveredDownloader = new DiscoveredDownloader(host, port, "bitcomet", pid);
                return discoveredDownloader;
            }
            String body = response.body().string();
            if (body.contains("BitComet Remote Access") || body.contains("BitComet WebUI")) {
                DiscoveredDownloader discoveredDownloader = new DiscoveredDownloader(host, port, "bitcomet", pid);
                return discoveredDownloader;
            }
            if (body.contains("qBittorrent WebUI")) {
                DiscoveredDownloader discoveredDownloader = new DiscoveredDownloader(host, port, "qbittorrent", pid);
                return discoveredDownloader;
            }
            DiscoveredDownloader discoveredDownloader = null;
            return discoveredDownloader;
        }
        catch (Exception e) {
            log.debug("Failed to check downloader at {}:{} -> {}", new Object[]{host, port, String.valueOf(e.getCause()) + ":" + e.getMessage()});
            return null;
        }
    }

    public static class DiscoveredDownloader {
        private String host;
        private int port;
        private String type;
        private int pid;

        @Generated
        public DiscoveredDownloader(String host, int port, String type, int pid) {
            this.host = host;
            this.port = port;
            this.type = type;
            this.pid = pid;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public int getPid() {
            return this.pid;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(int port) {
            this.port = port;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setPid(int pid) {
            this.pid = pid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscoveredDownloader)) {
                return false;
            }
            DiscoveredDownloader other = (DiscoveredDownloader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getPid() != other.getPid()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DiscoveredDownloader;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + this.getPid();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DownloaderDiscovery.DiscoveredDownloader(host=" + this.getHost() + ", port=" + this.getPort() + ", type=" + this.getType() + ", pid=" + this.getPid() + ")";
        }
    }
}

