/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.ResourceBundleHint;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.ResourcePatternHint;
import org.springframework.aot.hint.ResourcePatternHints;
import org.springframework.aot.hint.TypeReference;

class ResourceHintsAttributes {
    private static final Comparator<ResourcePatternHint> RESOURCE_PATTERN_HINT_COMPARATOR = Comparator.comparing(ResourcePatternHint::getPattern);
    private static final Comparator<ResourceBundleHint> RESOURCE_BUNDLE_HINT_COMPARATOR = Comparator.comparing(ResourceBundleHint::getBaseName);

    ResourceHintsAttributes() {
    }

    public List<Map<String, Object>> resources(ResourceHints hint) {
        return hint.resourcePatternHints().map(ResourcePatternHints::getIncludes).flatMap(Collection::stream).distinct().sorted(RESOURCE_PATTERN_HINT_COMPARATOR).map(this::toAttributes).toList();
    }

    public List<Map<String, Object>> resourceBundles(ResourceHints hint) {
        return hint.resourceBundleHints().sorted(RESOURCE_BUNDLE_HINT_COMPARATOR).map(this::toAttributes).toList();
    }

    private Map<String, Object> toAttributes(ResourceBundleHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("name", hint.getBaseName());
        return attributes;
    }

    private Map<String, Object> toAttributes(ResourcePatternHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("glob", hint.getPattern());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, ConditionalHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReached", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

