/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementAdapter;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotationSelectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.util.MultiValueMap;

public abstract class AnnotatedElementUtils {
    public static AnnotatedElement forAnnotations(Annotation ... annotations) {
        return AnnotatedElementAdapter.from(annotations);
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotatedElementUtils.getMetaAnnotationTypes(element, element.getAnnotation(annotationType));
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, String annotationName) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            return AnnotatedElementUtils.getMetaAnnotationTypes(element, annotation);
        }
        return Collections.emptySet();
    }

    private static Set<String> getMetaAnnotationTypes(AnnotatedElement element, @Nullable Annotation annotation) {
        if (annotation == null) {
            return Collections.emptySet();
        }
        return AnnotatedElementUtils.getAnnotations(annotation.annotationType()).stream().map(mergedAnnotation -> mergedAnnotation.getType().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotatedElementUtils.getAnnotations(element).stream(annotationType).anyMatch(MergedAnnotation::isMetaPresent);
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getAnnotations(element).stream(annotationName).anyMatch(MergedAnnotation::isMetaPresent);
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        if (AnnotationFilter.PLAIN.matches(annotationType) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(element)) {
            return element.isAnnotationPresent(annotationType);
        }
        return AnnotatedElementUtils.getAnnotations(element).isPresent(annotationType);
    }

    public static boolean isAnnotated(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getAnnotations(element).isPresent(annotationName);
    }

    public static @Nullable AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        MergedAnnotation<? extends Annotation> mergedAnnotation = AnnotatedElementUtils.getAnnotations(element).get(annotationType, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, false, false);
    }

    public static @Nullable AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName, false, false);
    }

    public static @Nullable AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        MergedAnnotation mergedAnnotation = AnnotatedElementUtils.getAnnotations(element).get(annotationName, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, classValuesAsString, nestedAnnotationsAsMap);
    }

    public static <A extends Annotation> @Nullable A getMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        if (AnnotationFilter.PLAIN.matches(annotationType) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(element)) {
            return element.getDeclaredAnnotation(annotationType);
        }
        return (A)((Annotation)AnnotatedElementUtils.getAnnotations(element).get(annotationType, null, MergedAnnotationSelectors.firstDirectlyDeclared()).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static <A extends Annotation> Set<A> getAllMergedAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotatedElementUtils.getAnnotations(element).stream(annotationType).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static Set<Annotation> getAllMergedAnnotations(AnnotatedElement element, Set<Class<? extends Annotation>> annotationTypes) {
        return AnnotatedElementUtils.getAnnotations(element).stream().filter(MergedAnnotationPredicates.typeIn(annotationTypes)).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotatedElementUtils.getMergedRepeatableAnnotations(element, annotationType, null);
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, @Nullable Class<? extends Annotation> containerType) {
        return AnnotatedElementUtils.getRepeatableAnnotations(element, annotationType, containerType).stream(annotationType).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static @Nullable MultiValueMap<String, @Nullable Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(element, annotationName, false, false);
    }

    public static @Nullable MultiValueMap<String, @Nullable Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        MergedAnnotation.Adapt[] adaptations = MergedAnnotation.Adapt.values(classValuesAsString, nestedAnnotationsAsMap);
        return AnnotatedElementUtils.getAnnotations(element).stream(annotationName).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toMultiValueMap(AnnotatedElementUtils::nullIfEmpty, adaptations));
    }

    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        if (AnnotationFilter.PLAIN.matches(annotationType) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(element)) {
            return element.isAnnotationPresent(annotationType);
        }
        return AnnotatedElementUtils.findAnnotations(element).isPresent(annotationType);
    }

    public static @Nullable AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        MergedAnnotation<? extends Annotation> mergedAnnotation = AnnotatedElementUtils.findAnnotations(element).get(annotationType, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, classValuesAsString, nestedAnnotationsAsMap);
    }

    public static @Nullable AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        MergedAnnotation mergedAnnotation = AnnotatedElementUtils.findAnnotations(element).get(annotationName, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, classValuesAsString, nestedAnnotationsAsMap);
    }

    public static <A extends Annotation> @Nullable A findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        if (AnnotationFilter.PLAIN.matches(annotationType) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(element)) {
            return element.getDeclaredAnnotation(annotationType);
        }
        return (A)((Annotation)AnnotatedElementUtils.findAnnotations(element).get(annotationType, null, MergedAnnotationSelectors.firstDirectlyDeclared()).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static <A extends Annotation> Set<A> findAllMergedAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotatedElementUtils.findAnnotations(element).stream(annotationType).sorted(AnnotatedElementUtils.highAggregateIndexesFirst()).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static Set<Annotation> findAllMergedAnnotations(AnnotatedElement element, Set<Class<? extends Annotation>> annotationTypes) {
        return AnnotatedElementUtils.findAnnotations(element).stream().filter(MergedAnnotationPredicates.typeIn(annotationTypes)).sorted(AnnotatedElementUtils.highAggregateIndexesFirst()).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static <A extends Annotation> Set<A> findMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotatedElementUtils.findMergedRepeatableAnnotations(element, annotationType, null);
    }

    public static <A extends Annotation> Set<A> findMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, @Nullable Class<? extends Annotation> containerType) {
        return AnnotatedElementUtils.findRepeatableAnnotations(element, annotationType, containerType).stream(annotationType).sorted(AnnotatedElementUtils.highAggregateIndexesFirst()).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    private static MergedAnnotations getAnnotations(AnnotatedElement element) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none());
    }

    private static MergedAnnotations getRepeatableAnnotations(AnnotatedElement element, Class<? extends Annotation> annotationType, @Nullable Class<? extends Annotation> containerType) {
        RepeatableContainers repeatableContainers;
        if (containerType == null) {
            RepeatableContainers.explicitRepeatable(annotationType, null);
            repeatableContainers = RepeatableContainers.standardRepeatables();
        } else {
            repeatableContainers = RepeatableContainers.explicitRepeatable(annotationType, containerType);
        }
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, repeatableContainers);
    }

    private static MergedAnnotations findAnnotations(AnnotatedElement element) {
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.none());
    }

    private static MergedAnnotations findRepeatableAnnotations(AnnotatedElement element, Class<? extends Annotation> annotationType, @Nullable Class<? extends Annotation> containerType) {
        RepeatableContainers repeatableContainers;
        if (containerType == null) {
            RepeatableContainers.explicitRepeatable(annotationType, null);
            repeatableContainers = RepeatableContainers.standardRepeatables();
        } else {
            repeatableContainers = RepeatableContainers.explicitRepeatable(annotationType, containerType);
        }
        return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, repeatableContainers);
    }

    private static @Nullable MultiValueMap<String, Object> nullIfEmpty(MultiValueMap<String, Object> map) {
        return map.isEmpty() ? null : map;
    }

    private static <A extends Annotation> Comparator<MergedAnnotation<A>> highAggregateIndexesFirst() {
        return Comparator.comparingInt(MergedAnnotation::getAggregateIndex).reversed();
    }

    private static @Nullable AnnotationAttributes getAnnotationAttributes(MergedAnnotation<?> annotation, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        if (!annotation.isPresent()) {
            return null;
        }
        return annotation.asAnnotationAttributes(MergedAnnotation.Adapt.values(classValuesAsString, nestedAnnotationsAsMap));
    }
}

