/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.Buffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class MultiBuffer
implements Buffer {
    static final int DEFAULT_CHUNK_SIZE = 0x7FFFFFF7;
    final ByteBuffer[] buffers;
    private final int chunkSize;
    private final long capacity;
    private long position = 0L;
    private long limit;

    MultiBuffer(ByteBuffer[] buffers, int chunkSize) {
        int i;
        for (i = 0; i < buffers.length; ++i) {
            ByteBuffer chunk = buffers[i];
            if (chunk.capacity() == chunkSize || i == buffers.length - 1) continue;
            throw new IllegalArgumentException("Chunk at index " + i + " is smaller than expected chunk size");
        }
        this.buffers = new ByteBuffer[buffers.length];
        for (i = 0; i < buffers.length; ++i) {
            this.buffers[i] = buffers[i].asReadOnlyBuffer();
        }
        long capacity = 0L;
        for (ByteBuffer buffer : this.buffers) {
            capacity += (long)buffer.capacity();
        }
        this.capacity = capacity;
        this.limit = capacity;
        this.chunkSize = chunkSize;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public Buffer position(long newPosition) {
        if (newPosition < 0L || newPosition > this.limit) {
            throw new IllegalArgumentException("Invalid position: " + newPosition);
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public Buffer limit(long newLimit) {
        if (newLimit < 0L || newLimit > this.capacity) {
            throw new IllegalArgumentException("Invalid limit: " + newLimit);
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        return this;
    }

    @Override
    public byte get() {
        byte value = this.get(this.position);
        ++this.position;
        return value;
    }

    @Override
    public Buffer get(byte[] dst) {
        int toRead;
        if (this.position > this.limit - (long)dst.length) {
            throw new IndexOutOfBoundsException("Read exceeds limit: position=" + this.position + ", length=" + dst.length + ", limit=" + this.limit);
        }
        long pos = this.position;
        int offset = 0;
        for (int length = dst.length; length > 0; length -= toRead) {
            int bufIndex = (int)(pos / (long)this.chunkSize);
            int bufOffset = (int)(pos % (long)this.chunkSize);
            ByteBuffer buf = this.buffers[bufIndex];
            buf.position(bufOffset);
            toRead = Math.min(buf.remaining(), length);
            buf.get(dst, offset, toRead);
            pos += (long)toRead;
            offset += toRead;
        }
        this.position = pos;
        return this;
    }

    @Override
    public byte get(long index) {
        if (index < 0L || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        int bufIndex = (int)(index / (long)this.chunkSize);
        int offset = (int)(index % (long)this.chunkSize);
        return this.buffers[bufIndex].get(offset);
    }

    @Override
    public double getDouble() {
        int bufIndex = (int)(this.position / (long)this.chunkSize);
        int off = (int)(this.position % (long)this.chunkSize);
        ByteBuffer buf = this.buffers[bufIndex];
        buf.position(off);
        if (buf.remaining() >= 8) {
            double value = buf.getDouble();
            this.position += 8L;
            return value;
        }
        byte[] eight = new byte[8];
        this.get(eight);
        return ByteBuffer.wrap(eight).getDouble();
    }

    @Override
    public float getFloat() {
        int bufIndex = (int)(this.position / (long)this.chunkSize);
        int off = (int)(this.position % (long)this.chunkSize);
        ByteBuffer buf = this.buffers[bufIndex];
        buf.position(off);
        if (buf.remaining() >= 4) {
            float value = buf.getFloat();
            this.position += 4L;
            return value;
        }
        byte[] four = new byte[4];
        this.get(four);
        return ByteBuffer.wrap(four).getFloat();
    }

    @Override
    public Buffer duplicate() {
        ByteBuffer[] duplicatedBuffers = new ByteBuffer[this.buffers.length];
        for (int i = 0; i < this.buffers.length; ++i) {
            duplicatedBuffers[i] = this.buffers[i].duplicate();
        }
        MultiBuffer copy = new MultiBuffer(duplicatedBuffers, this.chunkSize);
        copy.position = this.position;
        copy.limit = this.limit;
        return copy;
    }

    @Override
    public String decode(CharsetDecoder decoder) throws CharacterCodingException {
        return this.decode(decoder, Integer.MAX_VALUE);
    }

    String decode(CharsetDecoder decoder, int maxCharBufferSize) throws CharacterCodingException {
        long remainingBytes = this.limit - this.position;
        if (remainingBytes > (long)maxCharBufferSize) {
            throw new IllegalStateException("Decoding region too large to fit in a CharBuffer: " + remainingBytes);
        }
        CharBuffer out = CharBuffer.allocate((int)remainingBytes);
        long pos = this.position;
        while (remainingBytes > 0L) {
            int bufIndex = (int)(pos / (long)this.chunkSize);
            int bufOffset = (int)(pos % (long)this.chunkSize);
            ByteBuffer srcView = this.buffers[bufIndex];
            int savedLimit = srcView.limit();
            srcView.position(bufOffset);
            int toRead = (int)Math.min((long)srcView.remaining(), remainingBytes);
            srcView.limit(bufOffset + toRead);
            CoderResult result = decoder.decode(srcView, out, false);
            srcView.limit(savedLimit);
            if (result.isError()) {
                result.throwException();
            }
            pos += (long)toRead;
            remainingBytes -= (long)toRead;
        }
        this.position = pos;
        out.flip();
        return out.toString();
    }

    public static MultiBuffer mapFromChannel(FileChannel channel) throws IOException {
        long size = channel.size();
        if (size <= 0L) {
            throw new IllegalArgumentException("File channel has no data");
        }
        int fullChunks = (int)(size / 0x7FFFFFF7L);
        int remainder = (int)(size % 0x7FFFFFF7L);
        int totalChunks = fullChunks + (remainder > 0 ? 1 : 0);
        ByteBuffer[] buffers = new ByteBuffer[totalChunks];
        long remaining = size;
        for (int i = 0; i < totalChunks; ++i) {
            long chunkPos = (long)i * 0x7FFFFFF7L;
            long chunkSize = Math.min(0x7FFFFFF7L, remaining);
            buffers[i] = channel.map(FileChannel.MapMode.READ_ONLY, chunkPos, chunkSize);
            remaining -= chunkSize;
        }
        return new MultiBuffer(buffers, 0x7FFFFFF7);
    }
}

