/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.SpringPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;

public class ExtensionsInjector {
    private static final Logger log = LoggerFactory.getLogger(ExtensionsInjector.class);
    protected final SpringPluginManager springPluginManager;
    protected final AbstractAutowireCapableBeanFactory beanFactory;

    public ExtensionsInjector(SpringPluginManager springPluginManager, AbstractAutowireCapableBeanFactory beanFactory) {
        this.springPluginManager = springPluginManager;
        this.beanFactory = beanFactory;
    }

    public void injectExtensions() {
        Set extensionClassNames = this.springPluginManager.getExtensionClassNames(null);
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension '{}' as bean", (Object)extensionClassName);
                Class<?> extensionClass = this.getClass().getClassLoader().loadClass(extensionClassName);
                this.registerExtension(extensionClass);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        List startedPlugins = this.springPluginManager.getStartedPlugins();
        for (PluginWrapper plugin : startedPlugins) {
            log.debug("Registering extensions of the plugin '{}' as beans", (Object)plugin.getPluginId());
            extensionClassNames = this.springPluginManager.getExtensionClassNames(plugin.getPluginId());
            for (String extensionClassName : extensionClassNames) {
                try {
                    log.debug("Register extension '{}' as bean", (Object)extensionClassName);
                    Class<?> extensionClass = plugin.getPluginClassLoader().loadClass(extensionClassName);
                    this.registerExtension(extensionClass);
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void registerExtension(Class<?> extensionClass) {
        Map extensionBeanMap = this.springPluginManager.getApplicationContext().getBeansOfType(extensionClass);
        if (extensionBeanMap.isEmpty()) {
            Object extension = this.springPluginManager.getExtensionFactory().create(extensionClass);
            this.beanFactory.registerSingleton(extensionClass.getName(), extension);
        } else {
            log.debug("Bean registeration aborted! Extension '{}' already existed as bean!", (Object)extensionClass.getName());
        }
    }
}

