/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 8192;

    public static int copy(File in, File out) throws IOException {
        Assert.notNull((Object)in, "No input File specified");
        Assert.notNull((Object)out, "No output File specified");
        return FileCopyUtils.copy(Files.newInputStream(in.toPath(), new OpenOption[0]), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static void copy(byte[] in, File out) throws IOException {
        Assert.notNull((Object)in, "No input byte array specified");
        Assert.notNull((Object)out, "No output File specified");
        Files.write(out.toPath(), in, new OpenOption[0]);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        Assert.notNull((Object)in, "No input File specified");
        return Files.readAllBytes(in.toPath());
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        Assert.notNull((Object)in, "No InputStream specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        try (InputStream inputStream = in;){
            int n;
            block12: {
                OutputStream outputStream = out;
                try {
                    int count = (int)in.transferTo(out);
                    out.flush();
                    n = count;
                    if (outputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return n;
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull((Object)in, "No input byte array specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        try (OutputStream outputStream = out;){
            out.write(in);
        }
    }

    public static byte[] copyToByteArray(@Nullable InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        try (InputStream inputStream = in;){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    public static int copy(Reader in, Writer out) throws IOException {
        Assert.notNull((Object)in, "No Reader specified");
        Assert.notNull((Object)out, "No Writer specified");
        try (Reader reader = in;){
            int n;
            block12: {
                Writer writer = out;
                try {
                    int charCount = (int)in.transferTo(out);
                    out.flush();
                    n = charCount;
                    if (writer == null) break block12;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return n;
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        Assert.notNull((Object)in, "No input String specified");
        Assert.notNull((Object)out, "No Writer specified");
        try (Writer writer = out;){
            out.write(in);
        }
    }

    public static String copyToString(@Nullable Reader in) throws IOException {
        if (in == null) {
            return "";
        }
        StringWriter out = new StringWriter(8192);
        FileCopyUtils.copy(in, (Writer)out);
        return out.toString();
    }
}

