/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.stone.beecp.BeeConnectionPool;
import org.stone.beecp.BeeConnectionPoolMonitorVo;
import org.stone.beecp.BeeDataSourceConfig;
import org.stone.beecp.BeeMethodLog;
import org.stone.beecp.BeeMethodLogListener;
import org.stone.beecp.exception.BeeDataSourceCreatedException;
import org.stone.beecp.exception.BeeDataSourcePoolInstantiatedException;
import org.stone.beecp.exception.ConnectionGetInterruptedException;
import org.stone.beecp.exception.ConnectionGetTimeoutException;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.FastConnectionPool;
import org.stone.beecp.pool.FastConnectionPoolMonitorVo;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;
import org.stone.tools.LogPrinter;
import org.stone.tools.extension.InterruptableReentrantReadWriteLock;

public class BeeDataSource
extends BeeDataSourceConfig
implements DataSource,
XADataSource,
AutoCloseable {
    private final InterruptableReentrantReadWriteLock lock = new InterruptableReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private long maxWaitNanos = 8000L;
    private CommonDataSource subDs;
    private BeeConnectionPool pool = ConnectionPoolStatics.LAZY_POOL;
    private boolean poolInitialized;
    private SQLException poolInitializedCause;

    public BeeDataSource() {
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            BeeDataSource.createPool(this);
            this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxWait());
        }
        catch (SQLException e) {
            throw new BeeDataSourceCreatedException(e);
        }
    }

    private static void createPool(BeeDataSource ds) throws SQLException {
        String poolImplementClassName = ds.getPoolImplementClassName();
        if (CommonUtil.isBlank(poolImplementClassName)) {
            poolImplementClassName = FastConnectionPool.class.getName();
        }
        try {
            BeeConnectionPool pool = (BeeConnectionPool)BeanUtil.createClassInstance(poolImplementClassName, BeeConnectionPool.class, "pool");
            pool.start(ds);
            ds.pool = pool;
            ds.poolInitialized = true;
            Object connectionFactory = ds.getConnectionFactory();
            ds.subDs = connectionFactory instanceof CommonDataSource ? (CommonDataSource)connectionFactory : ConnectionPoolStatics.Dummy_CommonDataSource;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BeeDataSourcePoolInstantiatedException("Failed to create a pool with class:" + poolImplementClassName, e);
        }
    }

    private static void set(Object target, String setMethodName, String value) {
        try {
            Method method = target.getClass().getMethod(setMethodName, String.class);
            BeanUtil.setAccessible(target, method);
            method.invoke(target, value);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.poolInitialized) {
            return this.pool.getConnection();
        }
        return this.createPoolByLock().getConnection();
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.poolInitialized) {
            return this.pool.getXAConnection();
        }
        return this.createPoolByLock().getXAConnection();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        LogPrinter.DefaultLogPrinter.info("getConnection (user,password) ignores authentication - returning default connection");
        return this.getConnection();
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        LogPrinter.DefaultLogPrinter.info("getXAConnection (user,password) ignores authentication - returning default XAConnection");
        return this.getXAConnection();
    }

    /*
     * Unable to fully structure code
     */
    private BeeConnectionPool createPoolByLock() throws SQLException {
        if (!this.lock.isWriteLocked() && this.lock.writeLock().tryLock()) {
            try {
                if (this.poolInitialized) ** GOTO lbl20
                this.poolInitializedCause = null;
                BeeDataSource.createPool(this);
            }
            catch (SQLException e) {
                this.poolInitializedCause = e;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            try {
                if (!this.readLock.tryLock(this.maxWaitNanos, TimeUnit.NANOSECONDS)) {
                    throw new ConnectionGetTimeoutException("Timeout on waiting for pool ready");
                }
            }
            catch (InterruptedException e) {
                throw new ConnectionGetInterruptedException("An interruption occurred while waiting for pool ready");
            }
            this.readLock.unlock();
        }
lbl20:
        // 4 sources

        if (this.poolInitializedCause != null) {
            throw this.poolInitializedCause;
        }
        return this.pool;
    }

    public void enableLogCache(boolean enable) throws SQLException {
        this.pool.enableLogCache(enable);
    }

    public void changeLogListener(BeeMethodLogListener listener) throws SQLException {
        this.pool.changeLogListener(listener);
    }

    public List<BeeMethodLog> getLogs(int type) throws SQLException {
        return this.pool.getLogs(type);
    }

    public void clearLogs(int type) throws SQLException {
        this.pool.clearLogs(type);
    }

    public boolean cancelStatement(String logId) throws SQLException {
        return this.pool.cancelStatement(logId);
    }

    public boolean suspend() throws SQLException {
        return this.pool.suspendPool();
    }

    public boolean resume() throws SQLException {
        return this.pool.resumePool();
    }

    public void restart(boolean forceRecycleBorrowed) throws SQLException {
        this.pool.restart(forceRecycleBorrowed);
    }

    public void restart(boolean forceRecycleBorrowed, BeeDataSourceConfig config) throws SQLException {
        this.pool.restart(forceRecycleBorrowed, config);
        config.copyTo(this);
        this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxWait());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.poolInitialized) {
            BeeDataSource beeDataSource = this;
            synchronized (beeDataSource) {
                if (!this.pool.isClosed()) {
                    try {
                        this.pool.close();
                    }
                    finally {
                        this.pool = ConnectionPoolStatics.CLOSED_POOL;
                    }
                }
            }
        }
    }

    public String toString() {
        return this.pool.toString();
    }

    public boolean isClosed() {
        return this.pool.isClosed();
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        if (this.poolInitialized) {
            return this.pool.getPoolMonitorVo();
        }
        return new FastConnectionPoolMonitorVo(this.getPoolName(), this.isFairMode(), this.getMaxActive(), this.getSemaphoreSize(), this.isUseThreadLocal(), -1, 0, 0, this.getSemaphoreSize(), 0, 0, 0, 0, this.isPrintRuntimeLogs(), this.isEnableLogCache());
    }

    public void enableLogPrinter(boolean enable) throws SQLException {
        this.pool.enableLogPrinter(enable);
    }

    public List<Thread> interruptWaitingThreads() throws SQLException {
        if (this.poolInitialized) {
            return this.pool.interruptWaitingThreads();
        }
        return this.lock.interruptAllThreads();
    }

    @Override
    public void setMaxWait(long maxWait) {
        super.setMaxWait(maxWait);
        this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(maxWait);
    }

    @Override
    public void setUsername(String username) {
        if (this.subDs == null) {
            super.setUsername(username);
        } else {
            BeeDataSource.set(this.subDs, "setUsername", username);
        }
    }

    @Override
    public void setPassword(String password) {
        if (this.subDs == null) {
            super.setPassword(password);
        } else {
            BeeDataSource.set(this.subDs, "setPassword", password);
        }
    }

    @Override
    public void setJdbcUrl(String jdbcUrl) {
        if (this.subDs == null) {
            super.setJdbcUrl(jdbcUrl);
        } else {
            BeeDataSource.set(this.subDs, "setJdbcUrl", jdbcUrl);
        }
    }

    @Override
    public void setUrl(String jdbcUrl) {
        if (this.subDs == null) {
            super.setUrl(jdbcUrl);
        } else {
            BeeDataSource.set(this.subDs, "setUrl", jdbcUrl);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.subDs != null ? this.subDs.getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.subDs != null) {
            this.subDs.setLogWriter(out);
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.subDs != null ? this.subDs.getParentLogger() : null;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.subDs != null ? this.subDs.getLoginTimeout() : 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.subDs != null) {
            this.subDs.setLoginTimeout(seconds);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz != null && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException("The wrapper object was not an instance of " + clazz);
    }
}

