/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.beecp.BeeConnectionPredicate;
import org.stone.beecp.BeeDataSourceConfigMXBean;
import org.stone.beecp.BeeJdbcLinkInfoDecoder;
import org.stone.beecp.BeeMethodLogListener;
import org.stone.beecp.BeeMethodLogListenerFactory;
import org.stone.beecp.BeeTransactionIsolationNames;
import org.stone.beecp.BeeXaConnectionFactory;
import org.stone.beecp.exception.BeeDataSourceConfigException;
import org.stone.beecp.pool.ConnectionFactoryByDriver;
import org.stone.beecp.pool.ConnectionFactoryByDriverDs;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.XaConnectionFactoryByDriverDs;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;
import org.stone.tools.LogPrinter;
import org.stone.tools.exception.BeanException;

public class BeeDataSourceConfig
implements BeeDataSourceConfigMXBean {
    private static final AtomicInteger PoolNameIndex = new AtomicInteger();
    private static final List<String> DefaultExclusionList = Arrays.asList("username", "password", "jdbcUrl", "user", "url");
    private final List<String> exclusionListOfPrint = new ArrayList<String>(DefaultExclusionList);
    private final Map<String, Object> connectionFactoryProperties = new HashMap<String, Object>();
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private boolean asyncCreateInitConnections;
    private int maxActive = Math.min(Math.max(10, CommonUtil.NCPU), 50);
    private int semaphoreSize = Math.min(this.maxActive / 2, CommonUtil.NCPU);
    private boolean useThreadLocal = true;
    private long maxWait = 8000L;
    private long idleTimeout = 180000L;
    private long holdTimeout;
    private long intervalOfClearTimeout = 180000L;
    private boolean forceRecycleBorrowedOnClose;
    private long parkTimeForRetry = 3000L;
    private boolean registerMbeans;
    private boolean registerJvmHook = true;
    private boolean printRuntimeLogs;
    private boolean printConfiguration;
    private String poolImplementClassName;
    private String aliveTestSql = "SELECT 1";
    private int aliveTestTimeout = 3;
    private long aliveAssumeTime = 500L;
    private String defaultCatalog;
    private String defaultSchema;
    private Boolean defaultReadOnly;
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolation;
    private String defaultTransactionIsolationName;
    private boolean enableDefaultCatalog = true;
    private boolean enableDefaultSchema = true;
    private boolean enableDefaultReadOnly = true;
    private boolean enableDefaultAutoCommit = true;
    private boolean enableDefaultTransactionIsolation = true;
    private boolean forceDirtyWhenSetSchema;
    private boolean forceDirtyWhenSetCatalog;
    private Object connectionFactory;
    private Class<?> connectionFactoryClass;
    private String connectionFactoryClassName;
    private List<Integer> sqlExceptionCodeList;
    private List<String> sqlExceptionStateList;
    private BeeConnectionPredicate predicate;
    private Class<? extends BeeConnectionPredicate> predicateClass;
    private String predicateClassName;
    private BeeJdbcLinkInfoDecoder linkInfoDecoder;
    private Class<? extends BeeJdbcLinkInfoDecoder> linkInfoDecoderClass;
    private String linkInfoDecoderClassName;
    private boolean enableLogCache;
    private int logCacheSize = 1000;
    private long logTimeout;
    private long intervalOfClearTimeoutLogs = this.logTimeout = 180000L;
    private long slowConnectionThreshold = 30000L;
    private long slowSQLThreshold = 30000L;
    private BeeMethodLogListener logListener;
    private Class<? extends BeeMethodLogListener> logListenerClass;
    private String logListenerClassName;
    private BeeMethodLogListenerFactory logListenerFactory;
    private Class<? extends BeeMethodLogListenerFactory> logListenerFactoryClass;
    private String logListenerFactoryClassName;

    public BeeDataSourceConfig() {
    }

    public BeeDataSourceConfig(File propertiesFile) {
        this.loadFromPropertiesFile(propertiesFile);
    }

    public BeeDataSourceConfig(String propertiesFileName) {
        this.loadFromPropertiesFile(propertiesFileName);
    }

    public BeeDataSourceConfig(Properties configProperties) {
        this.loadFromProperties(configProperties);
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = CommonUtil.trimString(url);
        this.username = CommonUtil.trimString(user);
        this.password = CommonUtil.trimString(password);
        this.driverClassName = CommonUtil.trimString(driver);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = CommonUtil.trimString(jdbcUrl);
    }

    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        this.jdbcUrl = CommonUtil.trimString(jdbcUrl);
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = CommonUtil.trimString(driverClassName);
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = CommonUtil.trimString(poolName);
    }

    @Override
    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        this.fairMode = fairMode;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize < 0) {
            throw new BeeDataSourceConfigException("The given value for the configuration item 'initial-size' cannot be less than zero");
        }
        this.initialSize = initialSize;
    }

    public boolean isAsyncCreateInitConnections() {
        return this.asyncCreateInitConnections;
    }

    public void setAsyncCreateInitConnections(boolean asyncCreateInitConnections) {
        this.asyncCreateInitConnections = asyncCreateInitConnections;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (maxActive <= 0) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'max-active' must be greater than zero");
        }
        this.maxActive = maxActive;
        this.semaphoreSize = maxActive > 1 ? Math.min(maxActive / 2, CommonUtil.NCPU) : 1;
    }

    @Override
    public int getSemaphoreSize() {
        return this.semaphoreSize;
    }

    public void setSemaphoreSize(int semaphoreSize) {
        if (semaphoreSize <= 0) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'semaphore-size' must be greater than zero");
        }
        this.semaphoreSize = semaphoreSize;
    }

    public boolean isUseThreadLocal() {
        return this.useThreadLocal;
    }

    public void setUseThreadLocal(boolean useThreadLocal) {
        this.useThreadLocal = useThreadLocal;
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (maxWait <= 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'max-wait' must be greater than zero");
        }
        this.maxWait = maxWait;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout <= 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'idle-timeout' must be greater than zero");
        }
        this.idleTimeout = idleTimeout;
    }

    @Override
    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldTimeout(long holdTimeout) {
        if (holdTimeout < 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'hold-timeout' cannot be less than zero");
        }
        this.holdTimeout = holdTimeout;
    }

    @Override
    public long getIntervalOfClearTimeout() {
        return this.intervalOfClearTimeout;
    }

    public void setIntervalOfClearTimeout(long intervalOfClearTimeout) {
        if (intervalOfClearTimeout <= 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'interval-of-clear-timeout' must be greater than zero");
        }
        this.intervalOfClearTimeout = intervalOfClearTimeout;
    }

    @Override
    public boolean isForceRecycleBorrowedOnClose() {
        return this.forceRecycleBorrowedOnClose;
    }

    public void setForceRecycleBorrowedOnClose(boolean forceRecycleBorrowedOnClose) {
        this.forceRecycleBorrowedOnClose = forceRecycleBorrowedOnClose;
    }

    @Override
    public long getParkTimeForRetry() {
        return this.parkTimeForRetry;
    }

    public void setParkTimeForRetry(long parkTimeForRetry) {
        if (parkTimeForRetry < 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'park-time-for-retry' cannot be less than zero");
        }
        this.parkTimeForRetry = parkTimeForRetry;
    }

    @Override
    public boolean isRegisterMbeans() {
        return this.registerMbeans;
    }

    public void setRegisterMbeans(boolean registerMbeans) {
        this.registerMbeans = registerMbeans;
    }

    @Override
    public boolean isRegisterJvmHook() {
        return this.registerJvmHook;
    }

    public void setRegisterJvmHook(boolean registerJvmHook) {
        this.registerJvmHook = registerJvmHook;
    }

    public boolean isPrintRuntimeLogs() {
        return this.printRuntimeLogs;
    }

    public void setPrintRuntimeLogs(boolean printRuntimeLogs) {
        this.printRuntimeLogs = printRuntimeLogs;
    }

    public boolean isPrintConfiguration() {
        return this.printConfiguration;
    }

    public void setPrintConfiguration(boolean printConfiguration) {
        this.printConfiguration = printConfiguration;
    }

    @Override
    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        this.poolImplementClassName = CommonUtil.trimString(poolImplementClassName);
    }

    public void clearExclusionListOfPrint() {
        this.exclusionListOfPrint.clear();
    }

    public void addExclusionNameOfPrint(String fieldName) {
        if (!this.exclusionListOfPrint.contains(fieldName)) {
            this.exclusionListOfPrint.add(fieldName);
        }
    }

    public boolean removeExclusionNameOfPrint(String fieldName) {
        return this.exclusionListOfPrint.remove(fieldName);
    }

    public boolean existExclusionNameOfPrint(String fieldName) {
        return this.exclusionListOfPrint.contains(fieldName);
    }

    public Object getConnectionFactoryProperty(String key) {
        return this.connectionFactoryProperties.get(key);
    }

    public Object removeConnectionFactoryProperty(String key) {
        return this.connectionFactoryProperties.remove(key);
    }

    public void addConnectionFactoryProperty(String key, Object value) {
        if (CommonUtil.isBlank(key)) {
            throw new BeeDataSourceConfigException("The given key cannot be null or blank");
        }
        this.connectionFactoryProperties.put(key, value);
    }

    public void addConnectionFactoryProperty(String connectPropertyText) {
        if (CommonUtil.isNotBlank(connectPropertyText)) {
            for (String attribute : connectPropertyText.split("&")) {
                String[] pair = attribute.split("=");
                if (pair.length == 2) {
                    this.addConnectionFactoryProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                pair = attribute.split(":");
                if (pair.length != 2) continue;
                this.addConnectionFactoryProperty(pair[0].trim(), pair[1].trim());
            }
        }
    }

    @Override
    public String getAliveTestSql() {
        return this.aliveTestSql;
    }

    public void setAliveTestSql(String aliveTestSql) {
        if (CommonUtil.isBlank(aliveTestSql)) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'alive-test-sql' cannot be null or empty");
        }
        if (!(aliveTestSql = CommonUtil.trimString(aliveTestSql)).toUpperCase(Locale.US).startsWith("SELECT ")) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'alive-test-sql' must start with 'select '");
        }
        this.aliveTestSql = aliveTestSql;
    }

    @Override
    public int getAliveTestTimeout() {
        return this.aliveTestTimeout;
    }

    public void setAliveTestTimeout(int aliveTestTimeout) {
        if ((long)aliveTestTimeout < 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'alive-test-timeout' cannot  be less than zero");
        }
        this.aliveTestTimeout = aliveTestTimeout;
    }

    @Override
    public long getAliveAssumeTime() {
        return this.aliveAssumeTime;
    }

    public void setAliveAssumeTime(long aliveAssumeTime) {
        if (aliveAssumeTime < 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'alive-assume-time' cannot be less than zero");
        }
        this.aliveAssumeTime = aliveAssumeTime;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = CommonUtil.trimString(defaultCatalog);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = CommonUtil.trimString(defaultSchema);
    }

    @Override
    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(Integer transactionIsolationCode) {
        this.defaultTransactionIsolation = transactionIsolationCode;
    }

    @Override
    public String getDefaultTransactionIsolationName() {
        return this.defaultTransactionIsolationName;
    }

    public void setDefaultTransactionIsolationName(String transactionIsolationName) {
        String transactionIsolationNameTemp = CommonUtil.trimString(transactionIsolationName);
        if (CommonUtil.isBlank(transactionIsolationNameTemp)) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'default-transaction-isolation-name' cannot be null or empty");
        }
        this.defaultTransactionIsolation = BeeTransactionIsolationNames.getTransactionIsolationCode(transactionIsolationNameTemp);
        if (this.defaultTransactionIsolation == null) {
            throw new BeeDataSourceConfigException("Invalid transaction isolation name:" + transactionIsolationNameTemp + ", value is one of[" + "0,2,1,4,8" + "]");
        }
        this.defaultTransactionIsolationName = transactionIsolationNameTemp;
    }

    public boolean isEnableDefaultCatalog() {
        return this.enableDefaultCatalog;
    }

    public void setEnableDefaultCatalog(boolean enableDefaultCatalog) {
        this.enableDefaultCatalog = enableDefaultCatalog;
    }

    public boolean isEnableDefaultSchema() {
        return this.enableDefaultSchema;
    }

    public void setEnableDefaultSchema(boolean enableDefaultSchema) {
        this.enableDefaultSchema = enableDefaultSchema;
    }

    public boolean isEnableDefaultReadOnly() {
        return this.enableDefaultReadOnly;
    }

    public void setEnableDefaultReadOnly(boolean enableDefaultReadOnly) {
        this.enableDefaultReadOnly = enableDefaultReadOnly;
    }

    public boolean isEnableDefaultAutoCommit() {
        return this.enableDefaultAutoCommit;
    }

    public void setEnableDefaultAutoCommit(boolean enableDefaultAutoCommit) {
        this.enableDefaultAutoCommit = enableDefaultAutoCommit;
    }

    public boolean isEnableDefaultTransactionIsolation() {
        return this.enableDefaultTransactionIsolation;
    }

    public void setEnableDefaultTransactionIsolation(boolean enableDefaultTransactionIsolation) {
        this.enableDefaultTransactionIsolation = enableDefaultTransactionIsolation;
    }

    public boolean isForceDirtyWhenSetSchema() {
        return this.forceDirtyWhenSetSchema;
    }

    public void setForceDirtyWhenSetSchema(boolean forceDirtyWhenSetSchema) {
        this.forceDirtyWhenSetSchema = forceDirtyWhenSetSchema;
    }

    public boolean isForceDirtyWhenSetCatalog() {
        return this.forceDirtyWhenSetCatalog;
    }

    public void setForceDirtyWhenSetCatalog(boolean forceDirtyWhenSetCatalog) {
        this.forceDirtyWhenSetCatalog = forceDirtyWhenSetCatalog;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(BeeConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setXaConnectionFactory(BeeXaConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public Class<?> getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(Class<?> connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    @Override
    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = CommonUtil.trimString(connectionFactoryClassName);
    }

    public BeeConnectionPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(BeeConnectionPredicate predicate) {
        this.predicate = predicate;
    }

    public Class<? extends BeeConnectionPredicate> getPredicateClass() {
        return this.predicateClass;
    }

    public void setPredicateClass(Class<? extends BeeConnectionPredicate> predicateClass) {
        this.predicateClass = predicateClass;
    }

    public String getPredicateClassName() {
        return this.predicateClassName;
    }

    public void setPredicateClassName(String predicateClassName) {
        this.predicateClassName = predicateClassName;
    }

    public List<Integer> getSqlExceptionCodeList() {
        return this.sqlExceptionCodeList;
    }

    public void addSqlExceptionCode(int code) {
        if (this.sqlExceptionCodeList == null) {
            this.sqlExceptionCodeList = new ArrayList<Integer>(1);
        }
        if (!this.sqlExceptionCodeList.contains(code)) {
            this.sqlExceptionCodeList.add(code);
        }
    }

    public void removeSqlExceptionCode(int code) {
        if (this.sqlExceptionCodeList != null) {
            this.sqlExceptionCodeList.remove((Object)code);
        }
    }

    public List<String> getSqlExceptionStateList() {
        return this.sqlExceptionStateList;
    }

    public void addSqlExceptionState(String state) {
        if (this.sqlExceptionStateList == null) {
            this.sqlExceptionStateList = new ArrayList<String>(1);
        }
        if (!this.sqlExceptionStateList.contains(state)) {
            this.sqlExceptionStateList.add(state);
        }
    }

    public void removeSqlExceptionState(String state) {
        if (this.sqlExceptionStateList != null) {
            this.sqlExceptionStateList.remove(state);
        }
    }

    public BeeJdbcLinkInfoDecoder getLinkInfoDecoder() {
        return this.linkInfoDecoder;
    }

    public void setLinkInfoDecoder(BeeJdbcLinkInfoDecoder linkInfoDecoder) {
        this.linkInfoDecoder = linkInfoDecoder;
    }

    public Class<? extends BeeJdbcLinkInfoDecoder> getLinkInfoDecoderClass() {
        return this.linkInfoDecoderClass;
    }

    public void setLinkInfoDecoderClass(Class<? extends BeeJdbcLinkInfoDecoder> linkInfoDecoderClass) {
        this.linkInfoDecoderClass = linkInfoDecoderClass;
    }

    public String getLinkInfoDecoderClassName() {
        return this.linkInfoDecoderClassName;
    }

    public void setLinkInfoDecoderClassName(String linkInfoDecoderClassName) {
        this.linkInfoDecoderClassName = linkInfoDecoderClassName;
    }

    public boolean isEnableLogCache() {
        return this.enableLogCache;
    }

    public void setEnableLogCache(boolean enableLogCache) {
        this.enableLogCache = enableLogCache;
    }

    public int getLogCacheSize() {
        return this.logCacheSize;
    }

    public void setLogCacheSize(int logCacheSize) {
        if (logCacheSize <= 0) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'method-execution-log-cache-size' must be greater than zero");
        }
        this.logCacheSize = logCacheSize;
    }

    public long getLogTimeout() {
        return this.logTimeout;
    }

    public void setLogTimeout(long logTimeout) {
        if (logTimeout <= 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'method-execution-log-timeout' must be greater than zero");
        }
        this.logTimeout = logTimeout;
    }

    public long getIntervalOfClearTimeoutLogs() {
        return this.intervalOfClearTimeoutLogs;
    }

    public void setIntervalOfClearTimeoutLogs(long intervalOfClearTimeoutLogs) {
        if (intervalOfClearTimeoutLogs <= 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'interval-of-clear-timeout-execution-logs' must be greater than zero");
        }
        this.intervalOfClearTimeoutLogs = intervalOfClearTimeoutLogs;
    }

    public long getSlowConnectionThreshold() {
        return this.slowConnectionThreshold;
    }

    public void setSlowConnectionThreshold(long slowConnectionThreshold) {
        if (slowConnectionThreshold < 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'slow-connection-threshold' must be greater than zero");
        }
        this.slowConnectionThreshold = slowConnectionThreshold;
    }

    public long getSlowSQLThreshold() {
        return this.slowSQLThreshold;
    }

    public void setSlowSQLThreshold(long slowSQLThreshold) {
        if (slowSQLThreshold < 0L) {
            throw new BeeDataSourceConfigException("The given value for configuration item 'slow-SQL-threshold' must be greater than zero");
        }
        this.slowSQLThreshold = slowSQLThreshold;
    }

    public BeeMethodLogListener getLogListener() {
        return this.logListener;
    }

    public void setLogListener(BeeMethodLogListener logListener) {
        this.logListener = logListener;
    }

    public Class<? extends BeeMethodLogListener> getLogListenerClass() {
        return this.logListenerClass;
    }

    public void setLogListenerClass(Class<? extends BeeMethodLogListener> logListenerClass) {
        this.logListenerClass = logListenerClass;
    }

    public String getLogListenerClassName() {
        return this.logListenerClassName;
    }

    public void setLogListenerClassName(String logListenerClassName) {
        this.logListenerClassName = logListenerClassName;
    }

    public Class<? extends BeeMethodLogListenerFactory> getLogListenerFactoryClass() {
        return this.logListenerFactoryClass;
    }

    public void setLogListenerFactoryClass(Class<? extends BeeMethodLogListenerFactory> logListenerFactoryClass) {
        this.logListenerFactoryClass = logListenerFactoryClass;
    }

    public BeeMethodLogListenerFactory getLogListenerFactory() {
        return this.logListenerFactory;
    }

    public void setLogListenerFactory(BeeMethodLogListenerFactory logListenerFactory) {
        this.logListenerFactory = logListenerFactory;
    }

    public String getLogListenerFactoryClassName() {
        return this.logListenerFactoryClassName;
    }

    public void setLogListenerFactoryClassName(String logListenerFactoryClassName) {
        this.logListenerFactoryClassName = logListenerFactoryClassName;
    }

    public void loadFromPropertiesFile(String filename) {
        this.loadFromPropertiesFile(filename, null);
    }

    public void loadFromPropertiesFile(File file) {
        this.loadFromPropertiesFile(file, null);
    }

    public void loadFromProperties(Properties configProperties) {
        this.loadFromProperties(configProperties, null);
    }

    public void loadFromPropertiesFile(String filename, String keyPrefix) {
        if (CommonUtil.isBlank(filename)) {
            throw new BeeDataSourceConfigException("Load file name cannot be null or empty");
        }
        String fileLowerCaseName = filename.toLowerCase(Locale.US);
        if (!fileLowerCaseName.endsWith(".properties")) {
            throw new BeeDataSourceConfigException("Load file extension name must be 'properties':" + filename);
        }
        if (fileLowerCaseName.startsWith("cp:")) {
            String cpFileName = fileLowerCaseName.substring("cp:".length());
            Properties fileProperties = CommonUtil.loadPropertiesFromClassPathFile(cpFileName);
            this.loadFromProperties(fileProperties, keyPrefix);
        } else if (fileLowerCaseName.startsWith("classpath:")) {
            String cpFileName = fileLowerCaseName.substring("classpath:".length());
            Properties fileProperties = CommonUtil.loadPropertiesFromClassPathFile(cpFileName);
            this.loadFromProperties(fileProperties, keyPrefix);
        } else {
            this.loadFromPropertiesFile(new File(filename), keyPrefix);
        }
    }

    public void loadFromPropertiesFile(File file, String keyPrefix) {
        if (file == null) {
            throw new BeeDataSourceConfigException("Load file cannot be null");
        }
        if (!file.exists()) {
            throw new BeeDataSourceConfigException("Load file not found:(" + file + ")");
        }
        if (!file.isFile()) {
            throw new BeeDataSourceConfigException("Load file cannot be a folder:(" + file + ")");
        }
        if (!file.getAbsolutePath().toLowerCase(Locale.US).endsWith(".properties")) {
            throw new BeeDataSourceConfigException("Load file extension name must be 'properties':(" + file + ")");
        }
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Properties configProperties = new Properties();
            configProperties.load(stream);
            this.loadFromProperties(configProperties, keyPrefix);
        }
        catch (IOException e) {
            throw new BeeDataSourceConfigException("Failed to load configuration file:" + file, e);
        }
    }

    public void loadFromProperties(Properties configProperties, String keyPrefix) {
        HashMap<Object, Object> setValueMap;
        if (configProperties == null || configProperties.isEmpty()) {
            throw new BeeDataSourceConfigException("Load properties cannot be null or empty");
        }
        if (CommonUtil.isNotBlank(keyPrefix)) {
            if (keyPrefix.charAt(keyPrefix.length() - 1) != '.') {
                keyPrefix = keyPrefix + ".";
            }
            int keyPrefixLen = keyPrefix.length();
            setValueMap = new HashMap(configProperties.size());
            for (Map.Entry<Object, Object> entry : configProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(keyPrefix)) continue;
                setValueMap.put(key.substring(keyPrefixLen), (String)entry.getValue());
            }
        } else {
            setValueMap = new HashMap<Object, Object>(configProperties);
        }
        String connectPropertiesText = (String)setValueMap.remove("connectionFactoryProperties");
        String connectPropertiesSize = (String)setValueMap.remove("connectionFactoryProperties.size");
        String sqlExceptionCode = (String)setValueMap.remove("sqlExceptionCodeList");
        String sqlExceptionState = (String)setValueMap.remove("sqlExceptionStateList");
        String exclusionListText = (String)setValueMap.remove("exclusionListOfPrint");
        try {
            BeanUtil.setPropertiesValue(this, setValueMap);
        }
        catch (BeanException e) {
            throw new BeeDataSourceConfigException(e.getMessage(), e);
        }
        this.addConnectionFactoryProperty(connectPropertiesText);
        if (CommonUtil.isNotBlank(connectPropertiesSize)) {
            int size = Integer.parseInt(connectPropertiesSize.trim());
            for (int i = 1; i <= size; ++i) {
                this.addConnectionFactoryProperty(BeanUtil.getPropertyValue(setValueMap, "connectionFactoryProperties." + i));
            }
        }
        if (CommonUtil.isNotBlank(sqlExceptionCode)) {
            for (String code : sqlExceptionCode.trim().split(",")) {
                try {
                    this.addSqlExceptionCode(Integer.parseInt(code));
                }
                catch (NumberFormatException e) {
                    throw new BeeDataSourceConfigException(code + " is not a valid SQLException error code");
                }
            }
        }
        if (CommonUtil.isNotBlank(sqlExceptionState)) {
            for (String state : sqlExceptionState.trim().split(",")) {
                this.addSqlExceptionState(state);
            }
        }
        if (CommonUtil.isNotBlank(exclusionListText)) {
            this.clearExclusionListOfPrint();
            for (String exclusion : exclusionListText.trim().split(",")) {
                this.addExclusionNameOfPrint(exclusion);
            }
        }
    }

    public BeeDataSourceConfig check() throws SQLException {
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("The configured value of item 'initial-size' cannot be greater than the configured value of item 'max-active'");
        }
        Object connectionFactory = this.createConnectionFactory();
        BeeConnectionPredicate predicate = this.createConnectionEvictPredicate();
        BeeMethodLogListener methodExecutionListener = this.createMethodExecutionListener();
        BeeDataSourceConfig checkedConfig = new BeeDataSourceConfig();
        this.copyTo(checkedConfig);
        if ((this.connectionFactory != null || this.connectionFactoryClass != null || CommonUtil.isNotBlank(this.connectionFactoryClassName)) && (CommonUtil.isNotBlank(this.username) || CommonUtil.isNotBlank(this.password) || CommonUtil.isNotBlank(this.jdbcUrl) || CommonUtil.isNotBlank(this.driverClassName))) {
            LogPrinter.DefaultLogPrinter.info("BeeCP({})configured jdbc link info abandoned according that a connection factory has been existed", "...");
            checkedConfig.username = null;
            checkedConfig.password = null;
            checkedConfig.jdbcUrl = null;
            checkedConfig.driverClassName = null;
        }
        this.connectionFactory = connectionFactory;
        checkedConfig.connectionFactory = connectionFactory;
        checkedConfig.predicate = predicate;
        checkedConfig.logListener = methodExecutionListener;
        if (CommonUtil.isBlank(checkedConfig.poolName)) {
            checkedConfig.poolName = "FastPool-" + PoolNameIndex.incrementAndGet();
        }
        if (checkedConfig.printConfiguration) {
            this.printConfiguration(checkedConfig);
        }
        return checkedConfig;
    }

    void copyTo(BeeDataSourceConfig config) {
        String fieldName = null;
        try {
            block14: for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                switch (fieldName = field.getName()) {
                    case "connectionFactoryProperties": {
                        config.connectionFactoryProperties.putAll(this.connectionFactoryProperties);
                        continue block14;
                    }
                    case "exclusionListOfPrint": {
                        if (this.exclusionListOfPrint.isEmpty()) {
                            config.exclusionListOfPrint.clear();
                            continue block14;
                        }
                        config.exclusionListOfPrint.addAll(this.exclusionListOfPrint);
                        continue block14;
                    }
                    case "sqlExceptionCodeList": {
                        if (this.sqlExceptionCodeList == null) {
                            config.sqlExceptionCodeList = null;
                            continue block14;
                        }
                        if (this.sqlExceptionCodeList.isEmpty()) continue block14;
                        if (config.sqlExceptionCodeList == null) {
                            config.sqlExceptionCodeList = new ArrayList<Integer>(this.sqlExceptionCodeList);
                            continue block14;
                        }
                        config.sqlExceptionCodeList.clear();
                        config.sqlExceptionCodeList.addAll(this.sqlExceptionCodeList);
                        continue block14;
                    }
                    case "sqlExceptionStateList": {
                        if (this.sqlExceptionStateList == null) {
                            config.sqlExceptionStateList = null;
                            continue block14;
                        }
                        if (this.sqlExceptionStateList.isEmpty()) continue block14;
                        if (config.sqlExceptionStateList == null) {
                            config.sqlExceptionStateList = new ArrayList<String>(this.sqlExceptionStateList);
                            continue block14;
                        }
                        config.sqlExceptionStateList.clear();
                        config.sqlExceptionStateList.addAll(this.sqlExceptionStateList);
                        continue block14;
                    }
                    default: {
                        field.set(config, field.get(this));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BeeDataSourceConfigException("Failed to copy field[" + fieldName + "]", e);
        }
    }

    private BeeJdbcLinkInfoDecoder createJdbcLinkInfoDecoder() {
        if (this.linkInfoDecoder != null) {
            return this.linkInfoDecoder;
        }
        if (this.linkInfoDecoderClass != null || CommonUtil.isNotBlank(this.linkInfoDecoderClassName)) {
            Class<BeeJdbcLinkInfoDecoder> decoderClass = null;
            try {
                decoderClass = this.linkInfoDecoderClass != null ? this.linkInfoDecoderClass : BeanUtil.loadClass(this.linkInfoDecoderClassName);
                return BeanUtil.createClassInstance(decoderClass, BeeJdbcLinkInfoDecoder.class, "jdbc link info decoder");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Failed to create jdbc link info decoder with class[" + this.linkInfoDecoderClassName + "]", e);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create jdbc link info decoder with class[" + decoderClass + "]", e);
            }
        }
        return null;
    }

    private BeeMethodLogListener createMethodExecutionListener() {
        if (this.logListener != null) {
            return this.logListener;
        }
        if (this.logListenerFactory != null) {
            try {
                return this.logListenerFactory.create(this);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create method execution listener by listener factory", e);
            }
        }
        if (this.logListenerFactoryClass != null || CommonUtil.isNotBlank(this.logListenerFactoryClassName)) {
            BeeMethodLogListenerFactory factory;
            Class<BeeMethodLogListenerFactory> listenerFactoryClass = null;
            try {
                listenerFactoryClass = this.logListenerFactoryClass != null ? this.logListenerFactoryClass : BeanUtil.loadClass(this.logListenerFactoryClassName);
                factory = BeanUtil.createClassInstance(listenerFactoryClass, BeeMethodLogListenerFactory.class, "method execution listener factory");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Failed to create method execution listener factory with class[" + this.logListenerFactoryClassName + "]", e);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create method execution listener factory with class[" + listenerFactoryClass + "]", e);
            }
            try {
                return factory.create(this);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create method execution listener by listener factory", e);
            }
        }
        if (this.logListenerClass != null || CommonUtil.isNotBlank(this.logListenerClassName)) {
            Class<BeeMethodLogListener> listenerClass = null;
            try {
                listenerClass = this.logListenerClass != null ? this.logListenerClass : BeanUtil.loadClass(this.logListenerClassName);
                return BeanUtil.createClassInstance(listenerClass, BeeMethodLogListener.class, "method execution listener");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Failed to create method execution listener with class[" + this.logListenerClassName + "]", e);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create method execution listener with class[" + listenerClass + "]", e);
            }
        }
        return null;
    }

    private Object createConnectionFactory() throws SQLException {
        Properties jdbcLinkInfoProperties = this.getJdbcLinkInfoProperties();
        BeeJdbcLinkInfoDecoder jdbcLinkInfoDecoder = this.createJdbcLinkInfoDecoder();
        if (this.connectionFactory == null && this.connectionFactoryClass == null && CommonUtil.isBlank(this.connectionFactoryClassName)) {
            Driver driver;
            String url = jdbcLinkInfoProperties.getProperty("url");
            if (CommonUtil.isBlank(url)) {
                throw new BeeDataSourceConfigException("jdbcUrl must not be null or blank");
            }
            if (jdbcLinkInfoDecoder != null) {
                url = jdbcLinkInfoDecoder.decodeUrl(url);
            }
            if (CommonUtil.isNotBlank(this.driverClassName)) {
                driver = ConnectionPoolStatics.loadDriver(this.driverClassName);
                if (!driver.acceptsURL(url)) {
                    throw new BeeDataSourceConfigException("jdbcUrl(" + url + ")can not match configured driver[" + this.driverClassName + "]");
                }
            } else {
                driver = DriverManager.getDriver(url);
            }
            String username = jdbcLinkInfoProperties.getProperty("user");
            String password = jdbcLinkInfoProperties.getProperty("password");
            if (jdbcLinkInfoDecoder != null) {
                if (CommonUtil.isNotBlank(username)) {
                    username = jdbcLinkInfoDecoder.decodeUsername(username);
                }
                if (CommonUtil.isNotBlank(password)) {
                    password = jdbcLinkInfoDecoder.decodePassword(password);
                }
            }
            Properties localConnectProperties = new Properties();
            localConnectProperties.putAll(this.connectionFactoryProperties);
            if (CommonUtil.isNotBlank(username)) {
                localConnectProperties.setProperty("user", username);
                if (CommonUtil.isNotBlank(password)) {
                    localConnectProperties.setProperty("password", password);
                }
            }
            return new ConnectionFactoryByDriver(url, driver, localConnectProperties);
        }
        Class<Object> conFactClass = null;
        try {
            Object factory = this.connectionFactory;
            if (factory == null) {
                conFactClass = this.connectionFactoryClass != null ? this.connectionFactoryClass : BeanUtil.loadClass(this.connectionFactoryClassName);
                Class[] parentClasses = new Class[]{BeeConnectionFactory.class, BeeXaConnectionFactory.class, DataSource.class, XADataSource.class};
                factory = BeanUtil.createClassInstance(conFactClass, parentClasses, "connection factory");
            }
            HashMap<String, Object> localConnectProperties = new HashMap<String, Object>(this.connectionFactoryProperties);
            String url = jdbcLinkInfoProperties.getProperty("url");
            String username = jdbcLinkInfoProperties.getProperty("user");
            String password = jdbcLinkInfoProperties.getProperty("password");
            if (jdbcLinkInfoDecoder != null) {
                if (CommonUtil.isNotBlank(url)) {
                    url = jdbcLinkInfoDecoder.decodeUrl(url);
                }
                if (CommonUtil.isNotBlank(username)) {
                    username = jdbcLinkInfoDecoder.decodeUsername(username);
                }
                if (CommonUtil.isNotBlank(password)) {
                    password = jdbcLinkInfoDecoder.decodePassword(password);
                }
            }
            if (CommonUtil.isNotBlank(url)) {
                localConnectProperties.put("url", url);
                localConnectProperties.put("URL", url);
                localConnectProperties.put("jdbcUrl", url);
            }
            if (CommonUtil.isNotBlank(username)) {
                localConnectProperties.put("user", username);
                localConnectProperties.put("username", username);
                if (CommonUtil.isNotBlank(password)) {
                    localConnectProperties.put("password", password);
                }
            }
            BeanUtil.setPropertiesValue(factory, localConnectProperties);
            if (factory instanceof BeeConnectionFactory || factory instanceof BeeXaConnectionFactory) {
                return factory;
            }
            if (factory instanceof XADataSource) {
                return new XaConnectionFactoryByDriverDs((XADataSource)factory, username, password);
            }
            return new ConnectionFactoryByDriverDs((DataSource)factory, username, password);
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found connection factory class[" + conFactClass + "]", e);
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to create connection factory with class[" + conFactClass + "]", e);
        }
    }

    private Properties getJdbcLinkInfoProperties() {
        String url = this.jdbcUrl;
        String username = this.username;
        String password = this.password;
        if (CommonUtil.isBlank(url)) {
            url = (String)this.connectionFactoryProperties.get("url");
            if (CommonUtil.isBlank(url)) {
                url = (String)this.connectionFactoryProperties.get("URL");
            }
            if (CommonUtil.isBlank(url)) {
                url = (String)this.connectionFactoryProperties.get("jdbcUrl");
            }
            if (CommonUtil.isNotBlank(url)) {
                username = (String)this.connectionFactoryProperties.get("user");
                password = (String)this.connectionFactoryProperties.get("password");
            } else {
                url = System.getProperty("beecp.url");
                if (CommonUtil.isBlank(url)) {
                    url = System.getProperty("beecp.URL");
                }
                if (CommonUtil.isBlank(url)) {
                    url = System.getProperty("beecp.jdbcUrl");
                }
                if (CommonUtil.isNotBlank(url)) {
                    username = System.getProperty("beecp.user");
                    password = System.getProperty("beecp.password");
                }
            }
        }
        Properties jdbcLinkInfoProperties = new Properties();
        if (CommonUtil.isNotBlank(url)) {
            jdbcLinkInfoProperties.put("url", url);
        }
        if (CommonUtil.isNotBlank(username)) {
            jdbcLinkInfoProperties.put("user", username);
        }
        if (CommonUtil.isNotBlank(password)) {
            jdbcLinkInfoProperties.put("password", password);
        }
        return jdbcLinkInfoProperties;
    }

    private BeeConnectionPredicate createConnectionEvictPredicate() throws BeeDataSourceConfigException {
        if (this.predicate != null) {
            return this.predicate;
        }
        if (this.predicateClass != null || CommonUtil.isNotBlank(this.predicateClassName)) {
            Class<BeeConnectionPredicate> predicationClass = null;
            try {
                predicationClass = this.predicateClass != null ? this.predicateClass : BeanUtil.loadClass(this.predicateClassName);
                return BeanUtil.createClassInstance(predicationClass, BeeConnectionPredicate.class, "sql exception predicate");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Not found sql exception predicate class[" + this.predicateClassName + "]", e);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create sql exception predicate with class[" + predicationClass + "]", e);
            }
        }
        return null;
    }

    private void printConfiguration(BeeDataSourceConfig checkedConfig) {
        String poolName = checkedConfig.poolName;
        LogPrinter.DefaultLogPrinter.info("................................................BeeCP({})configuration[start]................................................", poolName);
        try {
            block10: for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                String fieldName = field.getName();
                boolean infoPrint = !checkedConfig.exclusionListOfPrint.contains(fieldName);
                switch (fieldName) {
                    case "exclusionListOfPrint": {
                        continue block10;
                    }
                    case "connectionFactoryProperties": {
                        if (this.connectionFactoryProperties.isEmpty()) continue block10;
                        if (infoPrint) {
                            for (Map.Entry<String, Object> entry : checkedConfig.connectionFactoryProperties.entrySet()) {
                                LogPrinter.DefaultLogPrinter.info("BeeCP({})-config.connectionFactoryProperties.{}={}", poolName, entry.getKey(), entry.getValue());
                            }
                            continue block10;
                        }
                        for (Map.Entry<String, Object> entry : checkedConfig.connectionFactoryProperties.entrySet()) {
                            LogPrinter.DefaultLogPrinter.debug("BeeCP({})-config.connectionFactoryProperties.{}={}", poolName, entry.getKey(), entry.getValue());
                        }
                        continue block10;
                    }
                    default: {
                        if (infoPrint) {
                            LogPrinter.DefaultLogPrinter.info("BeeCP({})-config.{}={}", poolName, fieldName, field.get(checkedConfig));
                            continue block10;
                        }
                        LogPrinter.DefaultLogPrinter.debug("BeeCP({})-config.{}={}", poolName, fieldName, field.get(checkedConfig));
                    }
                }
            }
        }
        catch (Throwable e) {
            LogPrinter.DefaultLogPrinter.warn("BeeCP({})-failed to print configuration", poolName, e);
        }
        LogPrinter.DefaultLogPrinter.info("................................................BeeCP({})configuration[end]................................................", poolName);
    }
}

