/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.stone.beecp.BeeDataSource;
import org.stone.beecp.BeeDataSourceConfig;
import org.stone.beecp.exception.BeeDataSourceConfigException;
import org.stone.beecp.jta.BeeJtaDataSource;
import org.stone.tools.BeanUtil;
import org.stone.tools.CommonUtil;
import org.stone.tools.LogPrinter;

public final class BeeDataSourceFactory
implements ObjectFactory {
    private static String getConfigValue(Reference ref, String propertyName) {
        String value = BeeDataSourceFactory.readConfig(ref, propertyName);
        if (value != null) {
            return value;
        }
        value = BeeDataSourceFactory.readConfig(ref, BeanUtil.propertyNameToFieldId(propertyName, "-"));
        if (value != null) {
            return value;
        }
        value = BeeDataSourceFactory.readConfig(ref, BeanUtil.propertyNameToFieldId(propertyName, "_"));
        if (value != null) {
            return value;
        }
        String firstChar = propertyName.substring(0, 1);
        if (Character.isLowerCase(firstChar.charAt(0))) {
            return BeeDataSourceFactory.readConfig(ref, firstChar.toUpperCase() + propertyName.substring(1));
        }
        return null;
    }

    private static String readConfig(Reference ref, String propertyName) {
        RefAddr refAddr = ref.get(propertyName);
        if (refAddr != null) {
            Object refObject = refAddr.getContent();
            if (refObject == null) {
                return null;
            }
            String value = refObject.toString().trim();
            if (CommonUtil.isNotBlank(value)) {
                LogPrinter.DefaultLogPrinter.info("beecp.{}={}", propertyName, value);
                return value;
            }
        }
        return null;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        TransactionManager tm = null;
        String tmJndiName = BeeDataSourceFactory.getConfigValue(ref, "transactionManagerName");
        if (CommonUtil.isNotBlank(tmJndiName) && nameCtx != null) {
            tm = (TransactionManager)nameCtx.lookup(tmJndiName);
        }
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        Map<String, Method> setMethodMap = BeanUtil.getClassSetMethodMap(config.getClass());
        HashMap<String, String> setValueMap = new HashMap<String, String>(setMethodMap.size());
        for (String propertyName : setMethodMap.keySet()) {
            String configVal = BeeDataSourceFactory.getConfigValue(ref, propertyName);
            if (CommonUtil.isBlank(configVal)) continue;
            setValueMap.put(propertyName, configVal);
        }
        BeanUtil.setPropertiesValue(config, setMethodMap, setValueMap);
        config.addConnectionFactoryProperty(BeeDataSourceFactory.getConfigValue(ref, "connectionFactoryProperties"));
        String connectPropertiesCount = BeeDataSourceFactory.getConfigValue(ref, "connectionFactoryProperties.size");
        if (CommonUtil.isNotBlank(connectPropertiesCount)) {
            int count = Integer.parseInt(connectPropertiesCount.trim());
            for (int i = 1; i <= count; ++i) {
                config.addConnectionFactoryProperty(BeeDataSourceFactory.getConfigValue(ref, "connectionFactoryProperties." + i));
            }
        }
        String sqlExceptionCode = BeeDataSourceFactory.getConfigValue(ref, "sqlExceptionCodeList");
        String sqlExceptionState = BeeDataSourceFactory.getConfigValue(ref, "sqlExceptionStateList");
        if (CommonUtil.isNotBlank(sqlExceptionCode)) {
            for (String code : sqlExceptionCode.trim().split(",")) {
                try {
                    config.addSqlExceptionCode(Integer.parseInt(code));
                }
                catch (NumberFormatException e) {
                    throw new BeeDataSourceConfigException(code + " is not valid error code");
                }
            }
        }
        if (CommonUtil.isNotBlank(sqlExceptionState)) {
            for (String state : sqlExceptionState.trim().split(",")) {
                config.addSqlExceptionState(state);
            }
        }
        BeeDataSource ds = new BeeDataSource(config);
        return tm != null ? new BeeJtaDataSource(ds, tm) : ds;
    }
}

