/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.stone.beecp.pool.ConnectionPoolStatics;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyBaseWrapper;
import org.stone.beecp.pool.ProxyStatementBase;

abstract class ProxyResultSetBase
extends ProxyBaseWrapper
implements ResultSet {
    protected ResultSet raw;
    private ProxyStatementBase owner;

    ProxyResultSetBase(ResultSet raw, PooledConnection p) {
        super(p);
        this.raw = raw;
    }

    ProxyResultSetBase(ResultSet raw, ProxyStatementBase o, PooledConnection p) {
        this(raw, p);
        o.setOpenResultSet(this);
        this.owner = o;
    }

    boolean containsRaw(ResultSet raw) {
        return this.raw == raw;
    }

    final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed on closed resultSet");
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.owner;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.raw.close();
        }
        finally {
            this.raw = ConnectionPoolStatics.CLOSED_RSLT;
            if (this.owner != null) {
                this.owner.removeOpenResultSet(this);
            }
        }
    }

    public String toString() {
        return this.raw.toString();
    }
}

