/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.stone.beecp.BeeXaConnectionFactory;
import org.stone.tools.CommonUtil;

public class XaConnectionFactoryByDriverDs
implements BeeXaConnectionFactory,
CommonDataSource {
    private final XADataSource dataSource;
    private String username;
    private String password;
    private boolean useUsername;

    public XaConnectionFactoryByDriverDs(XADataSource dataSource, String username, String password) {
        this.dataSource = dataSource;
        this.username = username;
        this.password = password;
        this.useUsername = CommonUtil.isNotBlank(username);
    }

    @Override
    public final XAConnection create() throws SQLException {
        return this.useUsername ? this.dataSource.getXAConnection(this.username, this.password) : this.dataSource.getXAConnection();
    }

    public void setUsername(String username) {
        this.username = username;
        this.useUsername = CommonUtil.isNotBlank(username);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public final PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public final void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public final void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }
}

