/*
 * Decompiled with CFR 0.152.
 */
package org.stone.tools;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.stone.tools.CommonUtil;
import org.stone.tools.exception.BeanException;
import org.stone.tools.exception.PropertyValueConvertException;
import org.stone.tools.exception.PropertyValueSetFailedException;

public class BeanUtil {
    public static final String Separator_Comma = ",";
    public static final String Separator_MiddleLine = "-";
    public static final String Separator_UnderLine = "_";
    public static final ClassLoader BeeClassLoader = BeanUtil.class.getClassLoader();

    public static void setAccessible(Object object, Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public static void setAccessible(Object object, Method method) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
    }

    public static Map<String, Method> getClassSetMethodMap(Class<?> beanClass) {
        Method[] methods = beanClass.getMethods();
        LinkedHashMap<String, Method> methodMap = new LinkedHashMap<String, Method>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            methodMap.put(methodName.substring(3, 4).toLowerCase() + methodName.substring(4), method);
        }
        return methodMap;
    }

    public static String getPropertyValue(Map<String, String> valueMap, String propertyName) {
        String value = valueMap.get(propertyName);
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_MiddleLine));
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_UnderLine));
        if (value != null) {
            return value;
        }
        String firstChar = propertyName.substring(0, 1);
        if (Character.isLowerCase(firstChar.charAt(0))) {
            return valueMap.get(firstChar.toUpperCase() + propertyName.substring(1));
        }
        return null;
    }

    private static Object getFieldValue(Map<String, ?> valueMap, String propertyName) {
        Object value = valueMap.get(propertyName);
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_MiddleLine));
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_UnderLine));
        if (value != null) {
            return value;
        }
        String firstChar = propertyName.substring(0, 1);
        if (Character.isLowerCase(firstChar.charAt(0))) {
            return valueMap.get(firstChar.toUpperCase() + propertyName.substring(1));
        }
        return null;
    }

    public static String propertyNameToFieldId(String propertyName, String separator) {
        char[] chars = propertyName.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (char c : chars) {
            if (Character.isUpperCase(c)) {
                sb.append(separator).append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void setPropertiesValue(Object bean, Map<String, ?> valueMap) throws BeanException {
        if (bean == null) {
            throw new BeanException("Bean can't be null");
        }
        BeanUtil.setPropertiesValue(bean, BeanUtil.getClassSetMethodMap(bean.getClass()), valueMap);
    }

    public static void setPropertiesValue(Object bean, Map<String, Method> setMethodMap, Map<String, ?> valueMap) throws BeanException {
        if (bean == null) {
            throw new BeanException("Bean can't be null");
        }
        if (setMethodMap == null || setMethodMap.isEmpty() || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Method> entry : setMethodMap.entrySet()) {
            String propertyName = entry.getKey();
            Method setMethod = entry.getValue();
            Object setValue = BeanUtil.getFieldValue(valueMap, propertyName);
            if (setValue == null) continue;
            Class<?> type = setMethod.getParameterTypes()[0];
            try {
                setValue = BeanUtil.convert(setValue, type, setMethod);
            }
            catch (Throwable e) {
                throw new PropertyValueConvertException("Failed to convert value[" + setValue + "]to property type(" + propertyName + ":" + type + ")", e);
            }
            try {
                setMethod.invoke(bean, setValue);
            }
            catch (IllegalAccessException e) {
                throw new PropertyValueSetFailedException("Failed to set value on property[" + propertyName + "],message:" + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause == null) {
                    throw new PropertyValueSetFailedException("Failed to set value on property[" + propertyName + "],message:" + e.getMessage(), e);
                }
                throw new PropertyValueSetFailedException("Failed to set value on property[" + propertyName + "],message:" + cause.getMessage(), cause);
            }
        }
    }

    public static <V> Class<V> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, BeeClassLoader);
    }

    public static <V> V createClassInstance(String className) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (V)Class.forName(className, true, BeeClassLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <V> V createClassInstance(String beanClassName, Class<?> parentClass, String objectClassType) throws ClassNotFoundException, BeanException {
        Class[] classArray;
        Class<V> clazz = BeanUtil.loadClass(beanClassName);
        if (parentClass != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = parentClass;
        } else {
            classArray = null;
        }
        return BeanUtil.createClassInstance(clazz, classArray, objectClassType);
    }

    public static <V> V createClassInstance(Class<V> beanClass, Class<?> parentClass, String objectClassType) throws BeanException {
        Class[] classArray;
        if (parentClass != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = parentClass;
        } else {
            classArray = null;
        }
        return BeanUtil.createClassInstance(beanClass, classArray, objectClassType);
    }

    public static <V> V createClassInstance(Class<V> beanClass, Class<?>[] parentClasses, String beanClassType) throws BeanException {
        if (beanClass == null) {
            throw new BeanException("Bean class can't be null");
        }
        int modifiers = beanClass.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new BeanException("Bean class can't be abstract");
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new BeanException("Bean class must be public");
        }
        if (parentClasses != null && parentClasses.length > 0) {
            int parentClassCount = 0;
            boolean isSubClass = false;
            for (Class<V> clazz : parentClasses) {
                if (clazz == null) continue;
                ++parentClassCount;
                if (!clazz.isAssignableFrom(beanClass)) continue;
                isSubClass = true;
                break;
            }
            if (parentClassCount > 0 && !isSubClass) {
                throw new BeanException("Can\u2018t create instance on class[" + beanClass.getName() + "]which must extend from one of type[" + BeanUtil.getClassName(parentClasses) + "]at least,creation category[" + beanClassType + "]");
            }
        }
        try {
            return beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new BeanException("Failed to create instance on class[" + beanClass.getName() + "]", e);
        }
    }

    private static String getClassName(Class<?>[] classes) {
        StringBuilder buf = new StringBuilder(classes.length * 10);
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            if (buf.length() > 0) {
                buf.append(Separator_Comma);
            }
            buf.append(clazz.getName());
        }
        return buf.toString();
    }

    private static Object convert(Object propValue, Class<?> targetType, Method setMethod) throws Exception {
        if (targetType.isInstance(propValue)) {
            return propValue;
        }
        if (targetType == String.class) {
            return propValue.toString();
        }
        String text = propValue.toString();
        if (CommonUtil.isBlank(text)) {
            return null;
        }
        text = text.trim();
        if (targetType == Character.TYPE || targetType == Character.class) {
            return Character.valueOf(text.charAt(0));
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return Boolean.valueOf(text);
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return Byte.valueOf(text);
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return Short.valueOf(text);
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return Integer.valueOf(text);
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return Long.valueOf(text);
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(text);
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return Double.valueOf(text);
        }
        if (targetType == BigInteger.class) {
            return new BigInteger(text);
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(text);
        }
        if (targetType == Class.class) {
            return BeanUtil.loadClass(text);
        }
        if (targetType.isArray()) {
            String[] textArray = text.split(Separator_Comma);
            int elementSize = textArray.length;
            Class<?> elementType = targetType.getComponentType();
            Object elementArray = Array.newInstance(elementType, elementSize);
            for (int i = 0; i < elementSize; ++i) {
                Array.set(elementArray, i, BeanUtil.convert(textArray[i], elementType, null));
            }
            return elementArray;
        }
        if (Collection.class.isAssignableFrom(targetType)) {
            if (setMethod == null) {
                return null;
            }
            AbstractCollection collection = !Modifier.isAbstract(targetType.getModifiers()) ? (HashSet)targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (Set.class.isAssignableFrom(targetType) ? new HashSet(1) : new ArrayList(1));
            Type genericParameterType = setMethod.getGenericParameterTypes()[0];
            if (genericParameterType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericParameterType;
                Class elementType = (Class)parameterizedType.getActualTypeArguments()[0];
                for (String s : text.split(Separator_Comma)) {
                    collection.add(BeanUtil.convert(s, elementType, null));
                }
            } else {
                Collections.addAll(collection, text.split(Separator_Comma));
            }
            return collection;
        }
        Object objInstance = Class.forName(text, true, BeeClassLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (targetType.isInstance(objInstance)) {
            return objInstance;
        }
        throw new ClassCastException();
    }

    public static boolean isRegisteredMBean(String beanName) throws Exception {
        try {
            return ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(beanName));
        }
        catch (Throwable e) {
            throw new BeanException("Failed to check MBean with name:" + beanName, e);
        }
    }

    public static void registerMBean(String beanName, Object bean) throws Exception {
        ManagementFactory.getPlatformMBeanServer().registerMBean(bean, new ObjectName(beanName));
    }

    public static void unregisterMBean(String beanName) throws Exception {
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(beanName));
    }
}

