/*
 * Decompiled with CFR 0.152.
 */
package org.stone.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.stone.tools.BeanUtil;

public class CommonUtil {
    public static final int NCPU = Runtime.getRuntime().availableProcessors();
    public static final int maxTimedSpins = NCPU < 2 ? 0 : 32;
    public static final int maxUntimedSpins = maxTimedSpins << 4;
    public static final long SPIN_FOR_TIMEOUT_THRESHOLD = 1023L;
    public static final int INT_MOVE_SHIFT = 16;
    public static final int INT_CLN_HIGH_MASK = 65535;

    public static int low16(int v) {
        return v & 0xFFFF;
    }

    public static int high16(int v) {
        return v >>> 16;
    }

    public static int contact(int h, int l) {
        return h << 16 | l & 0xFFFF;
    }

    public static String trimString(String value) {
        return value == null ? null : value.trim();
    }

    public static boolean objectEquals(Object a, Object b) {
        return Objects.equals(a, b);
    }

    public static int getArrayIndex(int hash, int arrayLen) {
        return arrayLen - 1 & (hash ^ hash >>> 16);
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        for (char aChar : str.toCharArray()) {
            if (Character.isWhitespace((int)aChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        if (str == null) {
            return false;
        }
        for (char aChar : str.toCharArray()) {
            if (Character.isWhitespace((int)aChar)) continue;
            return true;
        }
        return false;
    }

    public static int advanceProbe(int probe) {
        int adProbe = probe;
        adProbe ^= adProbe << 13;
        adProbe ^= adProbe >>> 17;
        adProbe ^= adProbe << 5;
        return adProbe;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadPropertiesFromClassPathFile(String filename) {
        try (InputStream fileStream = BeanUtil.BeeClassLoader.getResourceAsStream(filename);){
            if (fileStream == null) {
                throw new FileNotFoundException("Not found file:" + filename);
            }
            Properties properties = new Properties();
            properties.load(fileStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load classpath file:" + filename, e);
        }
    }
}

