/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.util;

import io.javalin.util.NamedVirtualThreadFactory;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/javalin/util/LoomUtil;", "", "()V", "loomAvailable", "", "getLoomAvailable", "()Z", "getExecutorService", "Ljava/util/concurrent/ExecutorService;", "name", "", "getThreadPool", "Lorg/eclipse/jetty/util/thread/ThreadPool;", "isLoomThreadPool", "threadPool", "LoomThreadPool", "javalin"})
@SourceDebugExtension(value={"SMAP\nConcurrencyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrencyUtil.kt\nio/javalin/util/LoomUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class LoomUtil {
    @NotNull
    public static final LoomUtil INSTANCE;
    private static final boolean loomAvailable;

    private LoomUtil() {
    }

    public final boolean getLoomAvailable() {
        return loomAvailable;
    }

    @NotNull
    public final ExecutorService getExecutorService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!loomAvailable) {
            boolean bl = false;
            String string = "Your Java version (" + System.getProperty("java.version") + ") doesn't support Loom";
            throw new IllegalArgumentException(string.toString());
        }
        Class[] classArray = new Class[]{ThreadFactory.class};
        Method factoryMethod = Executors.class.getMethod("newThreadPerTaskExecutor", classArray);
        Object[] objectArray = new Object[]{new NamedVirtualThreadFactory(name)};
        Object object = factoryMethod.invoke(Executors.class, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.concurrent.ExecutorService");
        return (ExecutorService)object;
    }

    @NotNull
    public final ThreadPool getThreadPool(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new LoomThreadPool(name);
    }

    public final boolean isLoomThreadPool(@NotNull ThreadPool threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        return threadPool instanceof LoomThreadPool;
    }

    static {
        Object object;
        LoomUtil loomUtil = INSTANCE = new LoomUtil();
        try {
            LoomUtil $this$loomAvailable_u24lambda_u240 = loomUtil;
            boolean bl = false;
            Method factoryMethod = Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]);
            Object object2 = factoryMethod.invoke(Executors.class, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.concurrent.ExecutorService");
            object = Result.constructor-impl((Object)((ExecutorService)object2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        loomAvailable = Result.isSuccess-impl((Object)object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/javalin/util/LoomUtil$LoomThreadPool;", "Lorg/eclipse/jetty/util/thread/ThreadPool;", "name", "", "(Ljava/lang/String;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "execute", "", "command", "Ljava/lang/Runnable;", "getIdleThreads", "", "getThreads", "isLowOnThreads", "", "join", "javalin"})
    private static final class LoomThreadPool
    implements ThreadPool {
        @NotNull
        private final ExecutorService executorService;

        public LoomThreadPool(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.executorService = INSTANCE.getExecutorService(name);
        }

        public void join() {
        }

        public int getThreads() {
            return 1;
        }

        public int getIdleThreads() {
            return 1;
        }

        public boolean isLowOnThreads() {
            return false;
        }

        public void execute(@NotNull Runnable command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.executorService.submit(command);
        }
    }
}

