/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.mapper;

import com.baomidou.mybatisplus.core.batch.BatchSqlSession;
import com.baomidou.mybatisplus.core.batch.MybatisBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.MapperProxyMetadata;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.MybatisBatchUtils;
import com.baomidou.mybatisplus.core.toolkit.MybatisUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public interface BaseMapper<T>
extends Mapper<T> {
    public int insert(T var1);

    default public int deleteById(Serializable id) {
        return this.deleteById(id, true);
    }

    default public int deleteById(Object obj, boolean useFill) {
        Class<?> entityClass = ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapper.class, 0);
        Assert.notNull(entityClass, "entityClass must not be null", new Object[0]);
        if (!entityClass.isAssignableFrom(obj.getClass()) && useFill) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
            Assert.notNull(tableInfo, "Can not get TableInfo for entity " + entityClass, new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty(keyProperty, "The current table has no primary key.", new Object[0]);
            if (tableInfo.isWithLogicDelete() && tableInfo.isWithUpdateFill()) {
                Object instance = tableInfo.newInstance();
                tableInfo.setPropertyValue(instance, keyProperty, OgnlOps.convertValue((Object)obj, tableInfo.getKeyType()));
                return this.deleteById(instance);
            }
        }
        MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this);
        SqlSession sqlSession = mapperProxyMetadata.getSqlSession();
        return sqlSession.delete(mapperProxyMetadata.getMapperInterface().getName() + "." + SqlMethod.DELETE_BY_ID.getMethod(), obj);
    }

    public int deleteById(T var1);

    default public int deleteByMap(Map<String, Object> columnMap) {
        return this.delete((Wrapper)Wrappers.query().allEq(columnMap));
    }

    public int delete(@Param(value="ew") Wrapper<T> var1);

    @Deprecated
    default public int deleteBatchIds(@Param(value="coll") Collection<?> idList) {
        return this.deleteByIds(idList);
    }

    default public int deleteByIds(@Param(value="coll") Collection<?> idList) {
        return this.deleteByIds(idList, true);
    }

    default public int deleteByIds(@Param(value="coll") Collection<?> collections, boolean useFill) {
        if (CollectionUtils.isEmpty(collections)) {
            return 0;
        }
        MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this);
        Class<?> entityClass = ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapper.class, 0);
        Assert.notNull(entityClass, "entityClass must not be null", new Object[0]);
        SqlSession sqlSession = mapperProxyMetadata.getSqlSession();
        Class<?> mapperInterface = mapperProxyMetadata.getMapperInterface();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull(tableInfo, "Can not get TableInfo for entity " + entityClass, new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (useFill && tableInfo.isWithLogicDelete() && tableInfo.isWithUpdateFill()) {
            params.put("mpFillEt", tableInfo.newInstance());
        }
        params.put("coll", collections);
        return sqlSession.delete(mapperInterface.getName() + "." + SqlMethod.DELETE_BY_IDS.getMethod(), params);
    }

    public int updateById(@Param(value="et") T var1);

    public int update(@Param(value="et") T var1, @Param(value="ew") Wrapper<T> var2);

    default public int update(@Param(value="ew") Wrapper<T> updateWrapper) {
        return this.update(null, updateWrapper);
    }

    public T selectById(Serializable var1);

    public List<T> selectByIds(@Param(value="coll") Collection<? extends Serializable> var1);

    default public List<T> selectBatchIds(@Param(value="coll") Collection<? extends Serializable> idList) {
        return this.selectByIds(idList);
    }

    public void selectByIds(@Param(value="coll") Collection<? extends Serializable> var1, ResultHandler<T> var2);

    @Deprecated
    default public void selectBatchIds(@Param(value="coll") Collection<? extends Serializable> idList, ResultHandler<T> resultHandler) {
        this.selectByIds(idList, resultHandler);
    }

    default public List<T> selectByMap(Map<String, Object> columnMap) {
        return this.selectList((Wrapper)Wrappers.query().allEq(columnMap));
    }

    default public void selectByMap(Map<String, Object> columnMap, ResultHandler<T> resultHandler) {
        this.selectList((Wrapper)Wrappers.query().allEq(columnMap), resultHandler);
    }

    default public T selectOne(@Param(value="ew") Wrapper<T> queryWrapper) {
        return this.selectOne(queryWrapper, true);
    }

    default public T selectOne(@Param(value="ew") Wrapper<T> queryWrapper, boolean throwEx) {
        List<T> list = this.selectList(queryWrapper);
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        if (size > 1) {
            if (throwEx) {
                throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + size);
            }
            return list.get(0);
        }
        return null;
    }

    default public boolean exists(Wrapper<T> queryWrapper) {
        Long count = this.selectCount(queryWrapper);
        return null != count && count > 0L;
    }

    public Long selectCount(@Param(value="ew") Wrapper<T> var1);

    public List<T> selectList(@Param(value="ew") Wrapper<T> var1);

    public void selectList(@Param(value="ew") Wrapper<T> var1, ResultHandler<T> var2);

    public List<T> selectList(IPage<T> var1, @Param(value="ew") Wrapper<T> var2);

    public void selectList(IPage<T> var1, @Param(value="ew") Wrapper<T> var2, ResultHandler<T> var3);

    public List<Map<String, Object>> selectMaps(@Param(value="ew") Wrapper<T> var1);

    public void selectMaps(@Param(value="ew") Wrapper<T> var1, ResultHandler<Map<String, Object>> var2);

    public List<Map<String, Object>> selectMaps(IPage<? extends Map<String, Object>> var1, @Param(value="ew") Wrapper<T> var2);

    public void selectMaps(IPage<? extends Map<String, Object>> var1, @Param(value="ew") Wrapper<T> var2, ResultHandler<Map<String, Object>> var3);

    public <E> List<E> selectObjs(@Param(value="ew") Wrapper<T> var1);

    public <E> void selectObjs(@Param(value="ew") Wrapper<T> var1, ResultHandler<E> var2);

    default public <P extends IPage<T>> P selectPage(P page, @Param(value="ew") Wrapper<T> queryWrapper) {
        page.setRecords(this.selectList(page, queryWrapper));
        return page;
    }

    default public <P extends IPage<Map<String, Object>>> P selectMapsPage(P page, @Param(value="ew") Wrapper<T> queryWrapper) {
        page.setRecords(this.selectMaps(page, queryWrapper));
        return page;
    }

    default public boolean insertOrUpdate(T entity) {
        Class<?> entityClass = ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapper.class, 0);
        Assert.notNull(entityClass, "entityClass must not be null", new Object[0]);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull(tableInfo, "Can not get TableInfo for entity " + entityClass, new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty(keyProperty, "The current table has no primary key.", new Object[0]);
        Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
        return StringUtils.checkValNull(idVal) || Objects.isNull(this.selectById((Serializable)idVal)) ? this.insert(entity) > 0 : this.updateById(entity) > 0;
    }

    default public List<BatchResult> insert(Collection<T> entityList) {
        return this.insert(entityList, 1000);
    }

    default public List<BatchResult> insert(Collection<T> entityList, int batchSize) {
        MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this);
        MybatisBatch.Method method = new MybatisBatch.Method(mapperProxyMetadata.getMapperInterface());
        SqlSessionFactory sqlSessionFactory = MybatisUtils.getSqlSessionFactory(mapperProxyMetadata.getSqlSession());
        return MybatisBatchUtils.execute(sqlSessionFactory, entityList, method.insert(), batchSize);
    }

    default public List<BatchResult> updateById(Collection<T> entityList) {
        return this.updateById(entityList, 1000);
    }

    default public List<BatchResult> updateById(Collection<T> entityList, int batchSize) {
        MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this);
        MybatisBatch.Method method = new MybatisBatch.Method(mapperProxyMetadata.getMapperInterface());
        SqlSessionFactory sqlSessionFactory = MybatisUtils.getSqlSessionFactory(mapperProxyMetadata.getSqlSession());
        return MybatisBatchUtils.execute(sqlSessionFactory, entityList, method.updateById(), batchSize);
    }

    default public List<BatchResult> insertOrUpdate(Collection<T> entityList) {
        return this.insertOrUpdate(entityList, 1000);
    }

    default public List<BatchResult> insertOrUpdate(Collection<T> entityList, int batchSize) {
        MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this);
        Class<?> entityClass = ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapper.class, 0);
        Assert.notNull(entityClass, "entityClass must not be null", new Object[0]);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull(tableInfo, "Can not get TableInfo for entity " + entityClass, new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty(keyProperty, "The current table has no primary key.", new Object[0]);
        String statement = mapperProxyMetadata.getMapperInterface().getName() + "." + SqlMethod.SELECT_BY_ID.getMethod();
        return this.insertOrUpdate(entityList, (sqlSession, entity) -> {
            Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
            return StringUtils.checkValNull(idVal) || CollectionUtils.isEmpty(sqlSession.selectList(statement, entity));
        }, batchSize);
    }

    default public List<BatchResult> insertOrUpdate(Collection<T> entityList, BiPredicate<BatchSqlSession, T> insertPredicate) {
        return this.insertOrUpdate(entityList, insertPredicate, 1000);
    }

    default public List<BatchResult> insertOrUpdate(Collection<T> entityList, BiPredicate<BatchSqlSession, T> insertPredicate, int batchSize) {
        MapperProxyMetadata mapperProxyMetadata = MybatisUtils.getMapperProxy(this);
        MybatisBatch.Method method = new MybatisBatch.Method(mapperProxyMetadata.getMapperInterface());
        SqlSessionFactory sqlSessionFactory = MybatisUtils.getSqlSessionFactory(mapperProxyMetadata.getSqlSession());
        return MybatisBatchUtils.saveOrUpdate(sqlSessionFactory, entityList, method.insert(), insertPredicate, method.updateById(), batchSize);
    }
}

