/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.handlers.IJsonTypeHandler;
import com.baomidou.mybatisplus.core.metadata.MapperProxyMetadata;
import com.baomidou.mybatisplus.core.override.MybatisMapperProxy;
import com.baomidou.mybatisplus.core.spi.CompatibleHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MybatisUtils {
    private static final Logger log = LoggerFactory.getLogger(MybatisUtils.class);

    public static TypeHandler<?> newJsonTypeHandler(Class<? extends TypeHandler<?>> typeHandler, Class<?> javaTypeClass, Field field) {
        TypeHandler<?> result = null;
        if (IJsonTypeHandler.class.isAssignableFrom(typeHandler)) {
            if (field != null) {
                try {
                    result = typeHandler.getConstructor(Class.class, Field.class).newInstance(javaTypeClass, field);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    result = typeHandler.getConstructor(Class.class).newInstance(javaTypeClass);
                }
                catch (ReflectiveOperationException ex) {
                    throw new TypeException("Failed invoking constructor for handler " + typeHandler, (Throwable)ex);
                }
            }
        }
        return result;
    }

    public static SqlSessionFactory getSqlSessionFactory(MybatisMapperProxy<?> mybatisMapperProxy) {
        SqlSession sqlSession = mybatisMapperProxy.getSqlSession();
        return MybatisUtils.getSqlSessionFactory(sqlSession);
    }

    public static SqlSessionFactory getSqlSessionFactory(SqlSession sqlSession) {
        String property;
        MetaObject metaObject = SystemMetaObject.forObject((Object)sqlSession);
        if (metaObject.hasGetter(property = "sqlSessionFactory")) {
            return (SqlSessionFactory)metaObject.getValue(property);
        }
        SqlSessionFactory sqlSessionFactory = GlobalConfigUtils.getGlobalConfig(sqlSession.getConfiguration()).getSqlSessionFactory();
        Assert.isTrue(sqlSessionFactory != null, "Please implement access to the sqlSessionFactory property or bind sqlSessionFactory to global access.", new Object[0]);
        return sqlSessionFactory;
    }

    public static MybatisMapperProxy<?> getMybatisMapperProxy(Object mapper) {
        Object result = MybatisUtils.extractMapperProxy(mapper);
        if (result instanceof MybatisMapperProxy) {
            return (MybatisMapperProxy)result;
        }
        throw new MybatisPlusException("Unable to get MybatisMapperProxy : " + mapper);
    }

    public static Object extractMapperProxy(Object mapper) {
        Object proxyTargetObject;
        if (mapper instanceof MybatisMapperProxy) {
            return mapper;
        }
        Object result = mapper;
        if (CompatibleHelper.hasCompatibleSet() && (proxyTargetObject = CompatibleHelper.getCompatibleSet().getProxyTargetObject(result)) != null) {
            result = proxyTargetObject;
        }
        if (result != null) {
            while (Proxy.isProxyClass(result.getClass())) {
                result = Proxy.getInvocationHandler(result);
            }
        }
        return result;
    }

    public static MapperProxyMetadata getMapperProxy(Object mapper) {
        Object mapperProxy = MybatisUtils.extractMapperProxy(mapper);
        MetaObject metaObject = SystemMetaObject.forObject((Object)mapperProxy);
        return new MapperProxyMetadata(metaObject);
    }

    private MybatisUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

