/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@FunctionalInterface
public interface AutowiredArguments {
    default public <T> @Nullable T get(int index, Class<T> requiredType) {
        Object value = this.getObject(index);
        if (!ClassUtils.isAssignableValue(requiredType, (Object)value)) {
            throw new IllegalArgumentException("Argument type mismatch: expected '" + ClassUtils.getQualifiedName(requiredType) + "' for value [" + String.valueOf(value) + "]");
        }
        return (T)value;
    }

    default public <T> @Nullable T get(int index) {
        return (T)this.getObject(index);
    }

    default public @Nullable Object getObject(int index) {
        return this.toArray()[index];
    }

    public @Nullable Object[] toArray();

    public static AutowiredArguments of(@Nullable Object[] arguments) {
        Assert.notNull((Object)arguments, (String)"'arguments' must not be null");
        return () -> arguments;
    }
}

