/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.ocsp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.ocsp.IoTransport;
import io.netty.handler.ssl.ocsp.OcspHttpHandler;
import io.netty.handler.ssl.ocsp.OcspServerCertificateValidator;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

final class OcspClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OcspClient.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final int OCSP_RESPONSE_MAX_SIZE = SystemPropertyUtil.getInt((String)"io.netty.ocsp.responseSize", (int)10240);

    static Promise<BasicOCSPResp> query(final X509Certificate x509Certificate, final X509Certificate issuer, final boolean validateResponseNonce, final IoTransport ioTransport, final DnsNameResolver dnsNameResolver) {
        final EventLoop eventLoop = ioTransport.eventLoop();
        final Promise responsePromise = eventLoop.newPromise();
        eventLoop.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String path;
                    CertificateID certificateID = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(issuer), x509Certificate.getSerialNumber());
                    OCSPReqBuilder builder = new OCSPReqBuilder();
                    builder.addRequest(certificateID);
                    byte[] nonce = new byte[16];
                    SECURE_RANDOM.nextBytes(nonce);
                    DEROctetString derNonce = new DEROctetString(nonce);
                    builder.setRequestExtensions(new Extensions(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)derNonce)));
                    URL uri = new URL(OcspClient.parseOcspUrlFromCertificate(x509Certificate));
                    int port = uri.getPort();
                    if (port == -1) {
                        port = uri.getDefaultPort();
                    }
                    if ((path = uri.getPath()).isEmpty()) {
                        path = "/";
                    } else if (uri.getQuery() != null) {
                        path = path + '?' + uri.getQuery();
                    }
                    Promise ocspResponsePromise = OcspClient.query(eventLoop, Unpooled.wrappedBuffer((byte[])builder.build().getEncoded()), uri.getHost(), port, path, ioTransport, dnsNameResolver);
                    ocspResponsePromise.addListener(future -> {
                        if (future.isSuccess()) {
                            try {
                                BasicOCSPResp resp = (BasicOCSPResp)((OCSPResp)future.getNow()).getResponseObject();
                                OcspClient.validateResponse((Promise<BasicOCSPResp>)responsePromise, resp, derNonce, issuer, validateResponseNonce);
                            }
                            catch (Throwable t) {
                                responsePromise.tryFailure(t);
                            }
                        } else {
                            responsePromise.tryFailure(future.cause());
                        }
                    });
                }
                catch (Exception ex) {
                    responsePromise.tryFailure((Throwable)ex);
                }
            }
        });
        return responsePromise;
    }

    private static Promise<OCSPResp> query(EventLoop eventLoop, ByteBuf ocspRequest, String host, int port, String path, IoTransport ioTransport, DnsNameResolver dnsNameResolver) {
        Promise responsePromise = eventLoop.newPromise();
        try {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)ioTransport.eventLoop())).option(ChannelOption.TCP_NODELAY, (Object)true)).channelFactory(ioTransport.socketChannel())).attr(OcspServerCertificateValidator.OCSP_PIPELINE_ATTRIBUTE, (Object)Boolean.TRUE)).handler((ChannelHandler)new Initializer((Promise<OCSPResp>)responsePromise));
            dnsNameResolver.resolve(host).addListener((GenericFutureListener)((FutureListener)future -> {
                if (future.isSuccess()) {
                    InetAddress hostAddress = (InetAddress)future.getNow();
                    ChannelFuture channelFuture = bootstrap.connect(hostAddress, port);
                    channelFuture.addListener(f -> {
                        if (f.isSuccess()) {
                            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, path, ocspRequest);
                            request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)host);
                            request.headers().add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"Netty OCSP Client");
                            request.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/ocsp-request");
                            request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)"application/ocsp-response");
                            request.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)ocspRequest.readableBytes());
                            channelFuture.channel().writeAndFlush((Object)request);
                        } else {
                            responsePromise.tryFailure((Throwable)new IllegalStateException("Connection to OCSP Responder Failed", f.cause()));
                        }
                    });
                } else {
                    responsePromise.tryFailure(future.cause());
                }
            }));
        }
        catch (Exception ex) {
            responsePromise.tryFailure((Throwable)ex);
        }
        return responsePromise;
    }

    private static void validateResponse(Promise<BasicOCSPResp> responsePromise, BasicOCSPResp basicResponse, DEROctetString derNonce, X509Certificate issuer, boolean validateNonce) {
        try {
            int responses = basicResponse.getResponses().length;
            if (responses != 1) {
                throw new IllegalArgumentException("Expected number of responses was 1 but got: " + responses);
            }
            if (validateNonce) {
                OcspClient.validateNonce(basicResponse, derNonce);
            }
            OcspClient.validateSignature(basicResponse, issuer);
            responsePromise.trySuccess((Object)basicResponse);
        }
        catch (Exception ex) {
            responsePromise.tryFailure((Throwable)ex);
        }
    }

    private static void validateNonce(BasicOCSPResp basicResponse, DEROctetString encodedNonce) throws OCSPException {
        Extension nonceExt = basicResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (nonceExt != null) {
            DEROctetString responseNonceString = (DEROctetString)nonceExt.getExtnValue();
            if (!responseNonceString.equals((ASN1Primitive)encodedNonce)) {
                throw new OCSPException("Nonce does not match");
            }
        } else {
            throw new IllegalArgumentException("Nonce is not present");
        }
    }

    static void validateSignature(BasicOCSPResp resp, X509Certificate issuerCertificate) throws OCSPException {
        try {
            X509CertificateHolder[] certs = resp.getCerts();
            JcaContentVerifierProviderBuilder providerBuilder = new JcaContentVerifierProviderBuilder();
            if (certs != null && certs.length > 0) {
                X509CertificateHolder responderCert = certs[0];
                ContentVerifierProvider responderVerifier = providerBuilder.build(responderCert);
                if (!resp.isSignatureValid(responderVerifier)) {
                    throw new OCSPException("OCSP response signature is not valid");
                }
                OcspClient.validateCertificateChain(responderCert, certs, issuerCertificate);
            } else {
                ContentVerifierProvider issuerVerifier = providerBuilder.build(issuerCertificate);
                if (!resp.isSignatureValid(issuerVerifier)) {
                    throw new OCSPException("OCSP response signature is not valid");
                }
            }
        }
        catch (OperatorCreationException e) {
            throw new OCSPException("Error validating OCSP-Signature", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new OCSPException("Error while processing certificates for OCSP signature validation", (Throwable)e);
        }
    }

    private static void validateCertificateChain(X509CertificateHolder responderCert, X509CertificateHolder[] allCerts, X509Certificate issuerCertificate) throws OCSPException {
        try {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(allCerts.length);
            for (X509CertificateHolder certHolder : allCerts) {
                certList.add(new JcaX509CertificateConverter().getCertificate(certHolder));
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
            X509CertSelector targetConstraints = new X509CertSelector();
            targetConstraints.setCertificate(new JcaX509CertificateConverter().getCertificate(responderCert));
            TrustAnchor trustAnchor = new TrustAnchor(issuerCertificate, null);
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(Collections.singleton(trustAnchor), (CertSelector)targetConstraints);
            pkixParams.addCertStore(certStore);
            pkixParams.setRevocationEnabled(false);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            builder.build(pkixParams);
        }
        catch (CertPathBuilderException e) {
            throw new OCSPException("OCSP responder certificate is not trusted by issuer: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new OCSPException("Error setting up certificate path validation", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new OCSPException("Error converting certificates for path validation", (Throwable)e);
        }
    }

    private static String parseOcspUrlFromCertificate(X509Certificate cert) {
        JcaX509CertificateHolder holder;
        try {
            holder = new JcaX509CertificateHolder(cert);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Error while parsing X509Certificate into JcaX509CertificateHolder", e);
        }
        AuthorityInformationAccess aiaExtension = AuthorityInformationAccess.fromExtensions((Extensions)holder.getExtensions());
        for (AccessDescription accessDescription : aiaExtension.getAccessDescriptions()) {
            if (!accessDescription.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.id_ad_ocsp)) continue;
            return accessDescription.getAccessLocation().getName().toASN1Primitive().toString();
        }
        throw new NullPointerException("Unable to find OCSP responder URL in Certificate");
    }

    private OcspClient() {
    }

    static {
        logger.debug("-Dio.netty.ocsp.responseSize: {} bytes", (Object)OCSP_RESPONSE_MAX_SIZE);
    }

    static final class Initializer
    extends ChannelInitializer<SocketChannel> {
        private final Promise<OCSPResp> responsePromise;

        Initializer(Promise<OCSPResp> responsePromise) {
            this.responsePromise = (Promise)ObjectUtil.checkNotNull(responsePromise, (String)"ResponsePromise");
        }

        protected void initChannel(SocketChannel socketChannel) {
            ChannelPipeline pipeline = socketChannel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(OCSP_RESPONSE_MAX_SIZE)});
            pipeline.addLast(new ChannelHandler[]{new OcspHttpHandler(this.responsePromise)});
        }
    }
}

